/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.mockito.internal.util.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.hadoop.shaded.net.bytebuddy.ClassFileVersion;
import org.apache.hadoop.shaded.org.mockito.internal.util.reflection.InstrumentationMemberAccessor;
import org.apache.hadoop.shaded.org.mockito.internal.util.reflection.ReflectionMemberAccessor;
import org.apache.hadoop.shaded.org.mockito.plugins.MemberAccessor;

public class ModuleMemberAccessor
implements MemberAccessor {
    private final MemberAccessor delegate;

    public ModuleMemberAccessor() {
        MemberAccessor delegate;
        try {
            delegate = ModuleMemberAccessor.delegate();
        }
        catch (Throwable ignored) {
            delegate = new ReflectionMemberAccessor();
        }
        this.delegate = delegate;
    }

    private static MemberAccessor delegate() {
        if (ClassFileVersion.ofThisVm().isAtLeast(ClassFileVersion.JAVA_V9)) {
            return new InstrumentationMemberAccessor();
        }
        return new ReflectionMemberAccessor();
    }

    @Override
    public Object newInstance(Constructor<?> constructor, Object ... arguments) throws InstantiationException, InvocationTargetException, IllegalAccessException {
        return this.delegate.newInstance(constructor, arguments);
    }

    @Override
    public Object newInstance(Constructor<?> constructor, MemberAccessor.OnConstruction onConstruction, Object ... arguments) throws InstantiationException, InvocationTargetException, IllegalAccessException {
        return this.delegate.newInstance(constructor, onConstruction, arguments);
    }

    @Override
    public Object invoke(Method method, Object target, Object ... arguments) throws InvocationTargetException, IllegalAccessException {
        return this.delegate.invoke(method, target, arguments);
    }

    @Override
    public Object get(Field field, Object target) throws IllegalAccessException {
        return this.delegate.get(field, target);
    }

    @Override
    public void set(Field field, Object target, Object value) throws IllegalAccessException {
        this.delegate.set(field, target, value);
    }
}

