/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.mockito.internal.util.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import org.apache.hadoop.shaded.org.mockito.internal.configuration.plugins.Plugins;
import org.apache.hadoop.shaded.org.mockito.plugins.MemberAccessor;

public class BeanPropertySetter {
    private static final String SET_PREFIX = "set";
    private final Object target;
    private final boolean reportNoSetterFound;
    private final Field field;

    public BeanPropertySetter(Object target, Field propertyField, boolean reportNoSetterFound) {
        this.field = propertyField;
        this.target = target;
        this.reportNoSetterFound = reportNoSetterFound;
    }

    public BeanPropertySetter(Object target, Field propertyField) {
        this(target, propertyField, false);
    }

    public boolean set(Object value) {
        MemberAccessor accessor = Plugins.getMemberAccessor();
        Method writeMethod = null;
        try {
            writeMethod = this.target.getClass().getMethod(this.setterName(this.field.getName()), this.field.getType());
            accessor.invoke(writeMethod, this.target, value);
            return true;
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Setter '" + writeMethod + "' of '" + this.target + "' with value '" + value + "' threw exception : '" + e.getTargetException() + "'", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Access not authorized on field '" + this.field + "' of object '" + this.target + "' with value: '" + value + "'", e);
        }
        catch (NoSuchMethodException e) {
            this.reportNoSetterFound();
            this.reportNoSetterFound();
            return false;
        }
    }

    private String setterName(String fieldName) {
        return new StringBuilder(SET_PREFIX).append(fieldName.substring(0, 1).toUpperCase(Locale.ENGLISH)).append(fieldName, 1, fieldName.length()).toString();
    }

    private void reportNoSetterFound() {
        if (this.reportNoSetterFound) {
            throw new RuntimeException("Problems setting value on object: [" + this.target + "] for property : [" + this.field.getName() + "], setter not found");
        }
    }
}

