/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.mockito.internal.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    private static final Pattern CAPS = Pattern.compile("([A-Z\\d][^A-Z\\d]*)");

    private StringUtil() {
    }

    public static String removeFirstLine(String text) {
        return text.replaceFirst(".*?\n", "");
    }

    public static String join(Object ... linesToBreak) {
        return StringUtil.join("\n", Arrays.asList(linesToBreak));
    }

    public static String join(String start, Collection<?> lines) {
        return StringUtil.join(start, "", lines);
    }

    public static String join(String start, String linePrefix, Collection<?> lines) {
        if (lines.isEmpty()) {
            return "";
        }
        StringBuilder out = new StringBuilder(start);
        for (Object line : lines) {
            out.append(linePrefix).append(line).append("\n");
        }
        return out.substring(0, out.length() - 1);
    }

    public static String decamelizeMatcherName(String className) {
        if (className.length() == 0) {
            return "<custom argument matcher>";
        }
        String decamelized = StringUtil.decamelizeClassName(className);
        if (decamelized.length() == 0) {
            return "<" + className + ">";
        }
        return "<" + decamelized + ">";
    }

    private static String decamelizeClassName(String className) {
        Matcher match = CAPS.matcher(className);
        StringBuilder deCameled = new StringBuilder();
        while (match.find()) {
            if (deCameled.length() == 0) {
                deCameled.append(match.group());
                continue;
            }
            deCameled.append(" ");
            deCameled.append(match.group().toLowerCase());
        }
        return deCameled.toString();
    }
}

