/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.mockito.internal.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.hadoop.shaded.org.mockito.internal.exceptions.Reporter;
import org.apache.hadoop.shaded.org.mockito.internal.stubbing.answers.InvocationInfo;
import org.apache.hadoop.shaded.org.mockito.invocation.InvocationOnMock;

public class KotlinInlineClassUtil {
    private static Class<Annotation> jvmInlineAnnotation;

    public static boolean isInlineClassWithAssignableUnderlyingType(Class<?> inlineClass, Class<?> underlyingType) {
        try {
            if (jvmInlineAnnotation == null || !inlineClass.isAnnotationPresent(jvmInlineAnnotation)) {
                return false;
            }
            Method ignored = inlineClass.getDeclaredMethod("box-impl", underlyingType);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private static Object unboxInlineClassIfPossible(Object boxedValue) {
        Class<?> inlineClass = boxedValue.getClass();
        try {
            Method unboxImpl = inlineClass.getDeclaredMethod("unbox-impl", new Class[0]);
            return unboxImpl.invoke(boxedValue, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw Reporter.inlineClassWithoutUnboxImpl(inlineClass, e);
        }
    }

    public static Object unboxUnderlyingValueIfNeeded(InvocationOnMock invocation, Object value) {
        InvocationInfo invocationInfo;
        Class<?> returnType;
        if (value == null || jvmInlineAnnotation == null) {
            return value;
        }
        Class<?> valueType = value.getClass();
        if (valueType.isAssignableFrom(returnType = (invocationInfo = new InvocationInfo(invocation)).getMethod().getReturnType())) {
            return value;
        }
        if (KotlinInlineClassUtil.isInlineClassWithAssignableUnderlyingType(valueType, returnType)) {
            return KotlinInlineClassUtil.unboxInlineClassIfPossible(value);
        }
        return value;
    }

    static {
        try {
            jvmInlineAnnotation = Class.forName("kotlin.jvm.JvmInline");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

