/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.mockito.internal.stubbing.defaultanswers;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.apache.hadoop.shaded.org.mockito.internal.stubbing.defaultanswers.ReturnsEmptyValues;
import org.apache.hadoop.shaded.org.mockito.internal.stubbing.defaultanswers.ReturnsMoreEmptyValues;
import org.apache.hadoop.shaded.org.mockito.internal.util.MockUtil;
import org.apache.hadoop.shaded.org.mockito.internal.util.reflection.GenericMetadataSupport;
import org.apache.hadoop.shaded.org.mockito.invocation.InvocationOnMock;
import org.apache.hadoop.shaded.org.mockito.mock.MockCreationSettings;

final class RetrieveGenericsForDefaultAnswers {
    static Object returnTypeForMockWithCorrectGenerics(InvocationOnMock invocation, AnswerCallback answerCallback) {
        Class<?> type = invocation.getMethod().getReturnType();
        Type returnType = invocation.getMethod().getGenericReturnType();
        Object defaultReturnValue = null;
        if (returnType instanceof TypeVariable && (type = RetrieveGenericsForDefaultAnswers.findTypeFromGeneric(invocation, (TypeVariable)returnType)) != null) {
            defaultReturnValue = RetrieveGenericsForDefaultAnswers.delegateChains(type);
        }
        if (defaultReturnValue != null) {
            return defaultReturnValue;
        }
        if (type != null) {
            MockCreationSettings mockSettings = MockUtil.getMockSettings(invocation.getMock());
            if (!MockUtil.typeMockabilityOf(type, mockSettings.getMockMaker()).mockable()) {
                return null;
            }
            return answerCallback.apply(type);
        }
        return answerCallback.apply(null);
    }

    private static Object delegateChains(Class<?> type) {
        ReturnsEmptyValues returnsEmptyValues = new ReturnsEmptyValues();
        Object result = returnsEmptyValues.returnValueFor(type);
        if (result == null) {
            for (Class<?> emptyValueForClass = type; emptyValueForClass != null && result == null; emptyValueForClass = emptyValueForClass.getSuperclass()) {
                Class<?> clazz;
                Class<?>[] classes;
                Class<?>[] classArray = classes = emptyValueForClass.getInterfaces();
                int n = classArray.length;
                for (int i = 0; i < n && (result = returnsEmptyValues.returnValueFor(clazz = classArray[i])) == null; ++i) {
                }
            }
        }
        if (result == null) {
            result = new ReturnsMoreEmptyValues().returnValueFor(type);
        }
        return result;
    }

    private static Class<?> findTypeFromGeneric(InvocationOnMock invocation, TypeVariable returnType) {
        MockCreationSettings<?> mockSettings = MockUtil.getMockHandler(invocation.getMock()).getMockSettings();
        GenericMetadataSupport returnTypeSupport = GenericMetadataSupport.inferFrom(mockSettings.getTypeToMock()).resolveGenericReturnType(invocation.getMethod());
        Class<?> rawType = returnTypeSupport.rawType();
        if (rawType == Object.class) {
            return RetrieveGenericsForDefaultAnswers.findTypeFromGenericInArguments(invocation, returnType);
        }
        return rawType;
    }

    private static Class<?> findTypeFromGenericInArguments(InvocationOnMock invocation, TypeVariable returnType) {
        Type[] parameterTypes = invocation.getMethod().getGenericParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Type argType = parameterTypes[i];
            if (returnType.equals(argType)) {
                Object argument = invocation.getArgument(i);
                if (argument == null) {
                    return null;
                }
                return argument.getClass();
            }
            if (!(argType instanceof GenericArrayType) || !returnType.equals(argType = ((GenericArrayType)argType).getGenericComponentType())) continue;
            return invocation.getArgument(i).getClass();
        }
        return null;
    }

    private RetrieveGenericsForDefaultAnswers() {
    }

    static interface AnswerCallback {
        public Object apply(Class<?> var1);
    }
}

