/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.mockito.internal.stubbing.answers;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.shaded.org.mockito.internal.invocation.AbstractAwareMethod;
import org.apache.hadoop.shaded.org.mockito.internal.util.MockUtil;
import org.apache.hadoop.shaded.org.mockito.internal.util.Primitives;
import org.apache.hadoop.shaded.org.mockito.internal.util.reflection.GenericMetadataSupport;
import org.apache.hadoop.shaded.org.mockito.invocation.InvocationOnMock;
import org.apache.hadoop.shaded.org.mockito.mock.MockCreationSettings;

public class InvocationInfo
implements AbstractAwareMethod {
    private final Method method;
    private final InvocationOnMock invocation;

    public InvocationInfo(InvocationOnMock theInvocation) {
        this.method = theInvocation.getMethod();
        this.invocation = theInvocation;
    }

    public boolean isValidException(Throwable throwable) {
        if (this.isValidException(this.method, throwable)) {
            return true;
        }
        return this.isValidExceptionForParents(this.method.getDeclaringClass(), throwable);
    }

    private boolean isValidExceptionForParents(Class<?> parent, Throwable throwable) {
        boolean validException;
        ArrayList ancestors = new ArrayList(Arrays.asList(parent.getInterfaces()));
        if (parent.getSuperclass() != null) {
            ancestors.add(parent.getSuperclass());
        }
        if (validException = ancestors.stream().anyMatch(ancestor -> this.isValidExceptionForClass((Class<?>)ancestor, throwable))) {
            return true;
        }
        return ancestors.stream().anyMatch(ancestor -> this.isValidExceptionForParents((Class<?>)ancestor, throwable));
    }

    private boolean isValidExceptionForClass(Class<?> parent, Throwable throwable) {
        try {
            Method parentMethod = parent.getMethod(this.method.getName(), this.method.getParameterTypes());
            return this.isValidException(parentMethod, throwable);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private boolean isValidException(Method method, Throwable throwable) {
        Class<?>[] exceptions = method.getExceptionTypes();
        Class<?> throwableClass = throwable.getClass();
        for (Class<?> exception : exceptions) {
            if (!exception.isAssignableFrom(throwableClass)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidReturnType(Class<?> clazz) {
        if (this.method.getReturnType().isPrimitive() || clazz.isPrimitive()) {
            return Primitives.primitiveTypeOf(clazz) == Primitives.primitiveTypeOf(this.method.getReturnType());
        }
        return this.method.getReturnType().isAssignableFrom(clazz);
    }

    public boolean isVoid() {
        MockCreationSettings<?> mockSettings = MockUtil.getMockHandler(this.invocation.getMock()).getMockSettings();
        Class<?> returnType = GenericMetadataSupport.inferFrom(mockSettings.getTypeToMock()).resolveGenericReturnType(this.method).rawType();
        return returnType == Void.TYPE || returnType == Void.class;
    }

    public String printMethodReturnType() {
        return this.method.getReturnType().getSimpleName();
    }

    public String getMethodName() {
        return this.method.getName();
    }

    public boolean returnsPrimitive() {
        return this.method.getReturnType().isPrimitive();
    }

    public Method getMethod() {
        return this.method;
    }

    public boolean isDeclaredOnInterface() {
        return this.method.getDeclaringClass().isInterface();
    }

    @Override
    public boolean isAbstract() {
        return (this.method.getModifiers() & 0x400) != 0;
    }
}

