/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.mockito.internal.matchers.text;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.shaded.org.mockito.ArgumentMatcher;
import org.apache.hadoop.shaded.org.mockito.internal.matchers.ContainsExtraTypeInfo;
import org.apache.hadoop.shaded.org.mockito.internal.matchers.text.FormattedText;
import org.apache.hadoop.shaded.org.mockito.internal.matchers.text.MatcherToString;
import org.apache.hadoop.shaded.org.mockito.internal.matchers.text.ValuePrinter;
import org.apache.hadoop.shaded.org.mockito.internal.reporting.PrintSettings;

public class MatchersPrinter {
    public String getArgumentsLine(List<ArgumentMatcher> matchers, PrintSettings printSettings) {
        Iterator<FormattedText> args = this.applyPrintSettings(matchers, printSettings);
        return ValuePrinter.printValues("(", ", ", ");", args);
    }

    public String getArgumentsBlock(List<ArgumentMatcher> matchers, PrintSettings printSettings) {
        Iterator<FormattedText> args = this.applyPrintSettings(matchers, printSettings);
        return ValuePrinter.printValues("(\n    ", ",\n    ", "\n);", args);
    }

    private Iterator<FormattedText> applyPrintSettings(List<ArgumentMatcher> matchers, PrintSettings printSettings) {
        LinkedList<FormattedText> out = new LinkedList<FormattedText>();
        int i = 0;
        for (ArgumentMatcher matcher : matchers) {
            if (matcher instanceof ContainsExtraTypeInfo) {
                String fullyQualifiedClassName;
                ContainsExtraTypeInfo typeInfoMatcher = (ContainsExtraTypeInfo)((Object)matcher);
                Object wanted = typeInfoMatcher.getWanted();
                String simpleNameOfArgument = wanted != null ? wanted.getClass().getSimpleName() : "";
                String string = fullyQualifiedClassName = wanted != null ? wanted.getClass().getCanonicalName() : "";
                if (printSettings.extraTypeInfoFor(i)) {
                    out.add(new FormattedText(typeInfoMatcher.toStringWithType(simpleNameOfArgument)));
                } else if (printSettings.fullyQualifiedNameFor(simpleNameOfArgument)) {
                    out.add(new FormattedText(typeInfoMatcher.toStringWithType(fullyQualifiedClassName)));
                } else {
                    out.add(new FormattedText(MatcherToString.toString(matcher)));
                }
            } else {
                out.add(new FormattedText(MatcherToString.toString(matcher)));
            }
            ++i;
        }
        return out.iterator();
    }
}

