/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.mockito.internal.junit;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Set;
import org.apache.hadoop.shaded.org.mockito.internal.creation.settings.CreationSettings;
import org.apache.hadoop.shaded.org.mockito.internal.junit.ArgMismatchFinder;
import org.apache.hadoop.shaded.org.mockito.internal.junit.DefaultStubbingLookupListener;
import org.apache.hadoop.shaded.org.mockito.internal.junit.MockitoTestListener;
import org.apache.hadoop.shaded.org.mockito.internal.junit.TestFinishedEvent;
import org.apache.hadoop.shaded.org.mockito.internal.junit.UnusedStubbings;
import org.apache.hadoop.shaded.org.mockito.internal.junit.UnusedStubbingsFinder;
import org.apache.hadoop.shaded.org.mockito.internal.listeners.AutoCleanableListener;
import org.apache.hadoop.shaded.org.mockito.mock.MockCreationSettings;
import org.apache.hadoop.shaded.org.mockito.plugins.MockitoLogger;
import org.apache.hadoop.shaded.org.mockito.quality.Strictness;

public class UniversalTestListener
implements MockitoTestListener,
AutoCleanableListener {
    private Strictness currentStrictness;
    private final MockitoLogger logger;
    private IdentityHashMap mocks = new IdentityHashMap();
    private final DefaultStubbingLookupListener stubbingLookupListener;
    private boolean listenerDirty;

    public UniversalTestListener(Strictness initialStrictness, MockitoLogger logger) {
        this.currentStrictness = initialStrictness;
        this.logger = logger;
        this.stubbingLookupListener = new DefaultStubbingLookupListener(this.currentStrictness);
    }

    @Override
    public void testFinished(TestFinishedEvent event) {
        Set<Object> createdMocks = this.mocks.keySet();
        this.mocks = new IdentityHashMap();
        switch (this.currentStrictness) {
            case WARN: {
                UniversalTestListener.emitWarnings(this.logger, event, createdMocks);
                break;
            }
            case STRICT_STUBS: {
                this.reportUnusedStubs(event, createdMocks);
                break;
            }
            case LENIENT: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown strictness: " + (Object)((Object)this.currentStrictness));
            }
        }
    }

    private void reportUnusedStubs(TestFinishedEvent event, Collection<Object> mocks) {
        if (event.getFailure() == null && !this.stubbingLookupListener.isMismatchesReported()) {
            UnusedStubbings unused = new UnusedStubbingsFinder().getUnusedStubbings(mocks);
            unused.reportUnused();
        }
    }

    private static void emitWarnings(MockitoLogger logger, TestFinishedEvent event, Collection<Object> mocks) {
        if (event.getFailure() != null) {
            new ArgMismatchFinder().getStubbingArgMismatches(mocks).format(event.getTestName(), logger);
        } else {
            new UnusedStubbingsFinder().getUnusedStubbings(mocks).format(event.getTestName(), logger);
        }
    }

    @Override
    public void onMockCreated(Object mock, MockCreationSettings settings) {
        this.mocks.put(mock, settings);
        ((CreationSettings)settings).getStubbingLookupListeners().add(this.stubbingLookupListener);
    }

    public void setStrictness(Strictness strictness) {
        this.currentStrictness = strictness;
        this.stubbingLookupListener.setCurrentStrictness(strictness);
    }

    @Override
    public boolean isListenerDirty() {
        return this.listenerDirty;
    }

    public void setListenerDirty() {
        this.listenerDirty = true;
    }
}

