/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.mockito.internal.invocation;

import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.shaded.org.mockito.ArgumentMatcher;
import org.apache.hadoop.shaded.org.mockito.internal.invocation.ArgumentMatcherAction;

public class TypeSafeMatching
implements ArgumentMatcherAction {
    private static final ArgumentMatcherAction TYPE_SAFE_MATCHING_ACTION = new TypeSafeMatching();
    private static final ConcurrentMap<Class<?>, Class<?>> argumentTypeCache = new ConcurrentHashMap();

    private TypeSafeMatching() {
    }

    public static ArgumentMatcherAction matchesTypeSafe() {
        return TYPE_SAFE_MATCHING_ACTION;
    }

    public boolean apply(ArgumentMatcher matcher, Object argument) {
        return TypeSafeMatching.isCompatible(matcher, argument) && matcher.matches(argument);
    }

    private static boolean isCompatible(ArgumentMatcher<?> argumentMatcher, Object argument) {
        if (argument == null) {
            return true;
        }
        Class<?> expectedArgumentType = TypeSafeMatching.getArgumentType(argumentMatcher);
        return expectedArgumentType.isInstance(argument);
    }

    private static Class<?> getArgumentType(ArgumentMatcher<?> matcher) {
        Class<?> argumentMatcherType = matcher.getClass();
        Class cached = (Class)argumentTypeCache.get(argumentMatcherType);
        if (cached != null) {
            return cached;
        }
        return argumentTypeCache.computeIfAbsent(argumentMatcherType, unusedKey -> TypeSafeMatching.getArgumentTypeUncached(matcher));
    }

    private static Class<?> getArgumentTypeUncached(ArgumentMatcher<?> argumentMatcher) {
        Method[] methods;
        for (Method method : methods = argumentMatcher.getClass().getMethods()) {
            if (!TypeSafeMatching.isMatchesMethod(method)) continue;
            return method.getParameterTypes()[0];
        }
        throw new NoSuchMethodError("Method 'matches(T)' not found in ArgumentMatcher: " + argumentMatcher + " !\r\n Please file a bug with this stack trace at: https://github.com/mockito/mockito/issues/new ");
    }

    private static boolean isMatchesMethod(Method method) {
        if (method.getParameterTypes().length != 1) {
            return false;
        }
        if (method.isBridge()) {
            return false;
        }
        return "matches".equals(method.getName());
    }
}

