/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.mockito.internal.invocation;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.shaded.org.mockito.ArgumentMatcher;
import org.apache.hadoop.shaded.org.mockito.internal.hamcrest.HamcrestArgumentMatcher;
import org.apache.hadoop.shaded.org.mockito.internal.invocation.ArgumentMatcherAction;
import org.apache.hadoop.shaded.org.mockito.internal.matchers.VarargMatcher;
import org.apache.hadoop.shaded.org.mockito.invocation.Invocation;

public class MatcherApplicationStrategy {
    private final Invocation invocation;
    private final List<? extends ArgumentMatcher<?>> matchers;

    private MatcherApplicationStrategy(Invocation invocation, List<? extends ArgumentMatcher<?>> matchers) {
        this.invocation = invocation;
        this.matchers = matchers;
    }

    public static MatcherApplicationStrategy getMatcherApplicationStrategyFor(Invocation invocation, List<? extends ArgumentMatcher<?>> matchers) {
        return new MatcherApplicationStrategy(invocation, matchers);
    }

    public boolean forEachMatcherAndArgument(ArgumentMatcherAction action) {
        boolean maybeVararg;
        boolean bl = maybeVararg = this.invocation.getMethod().isVarArgs() && this.invocation.getRawArguments().length == this.matchers.size();
        if (maybeVararg) {
            Class<?> matcherType = this.lastMatcher().type();
            Class<?> paramType = this.lastParameterType();
            if (paramType.isAssignableFrom(matcherType)) {
                return this.argsMatch(this.invocation.getRawArguments(), this.matchers, action);
            }
        }
        if (this.invocation.getArguments().length == this.matchers.size()) {
            return this.argsMatch(this.invocation.getArguments(), this.matchers, action);
        }
        if (maybeVararg && this.isLastMatcherVarargMatcher()) {
            int times = this.varargLength();
            List<? extends ArgumentMatcher<?>> matchers = this.appendLastMatcherNTimes(times);
            return this.argsMatch(this.invocation.getArguments(), matchers, action);
        }
        return false;
    }

    private boolean argsMatch(Object[] arguments, List<? extends ArgumentMatcher<?>> matchers, ArgumentMatcherAction action) {
        for (int i = 0; i < arguments.length; ++i) {
            Object argument;
            ArgumentMatcher<?> matcher = matchers.get(i);
            if (action.apply(matcher, argument = arguments[i])) continue;
            return false;
        }
        return true;
    }

    private boolean isLastMatcherVarargMatcher() {
        ArgumentMatcher<?> argumentMatcher = this.lastMatcher();
        if (argumentMatcher instanceof HamcrestArgumentMatcher) {
            return ((HamcrestArgumentMatcher)argumentMatcher).isVarargMatcher();
        }
        return argumentMatcher instanceof VarargMatcher;
    }

    private List<? extends ArgumentMatcher<?>> appendLastMatcherNTimes(int timesToAppendLastMatcher) {
        ArgumentMatcher<?> lastMatcher = this.lastMatcher();
        ArrayList expandedMatchers = new ArrayList(this.matchers);
        for (int i = 0; i < timesToAppendLastMatcher; ++i) {
            expandedMatchers.add(lastMatcher);
        }
        return expandedMatchers;
    }

    private int varargLength() {
        int rawArgumentCount = this.invocation.getRawArguments().length;
        int expandedArgumentCount = this.invocation.getArguments().length;
        return expandedArgumentCount - rawArgumentCount;
    }

    private ArgumentMatcher<?> lastMatcher() {
        return this.matchers.get(this.matchers.size() - 1);
    }

    private Class<?> lastParameterType() {
        Class<?>[] parameterTypes = this.invocation.getMethod().getParameterTypes();
        return parameterTypes[parameterTypes.length - 1];
    }
}

