/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.mockito.internal.framework;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.shaded.org.mockito.Mockito;
import org.apache.hadoop.shaded.org.mockito.MockitoAnnotations;
import org.apache.hadoop.shaded.org.mockito.MockitoSession;
import org.apache.hadoop.shaded.org.mockito.exceptions.base.MockitoException;
import org.apache.hadoop.shaded.org.mockito.exceptions.misusing.RedundantListenerException;
import org.apache.hadoop.shaded.org.mockito.internal.exceptions.Reporter;
import org.apache.hadoop.shaded.org.mockito.internal.junit.TestFinishedEvent;
import org.apache.hadoop.shaded.org.mockito.internal.junit.UniversalTestListener;
import org.apache.hadoop.shaded.org.mockito.plugins.MockitoLogger;
import org.apache.hadoop.shaded.org.mockito.quality.Strictness;

public class DefaultMockitoSession
implements MockitoSession {
    private final String name;
    private final UniversalTestListener listener;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();

    public DefaultMockitoSession(List<Object> testClassInstances, String name, Strictness strictness, MockitoLogger logger) {
        this.name = name;
        this.listener = new UniversalTestListener(strictness, logger);
        try {
            Mockito.framework().addListener(this.listener);
        }
        catch (RedundantListenerException e) {
            Reporter.unfinishedMockingSession();
        }
        try {
            for (Object testClassInstance : testClassInstances) {
                this.closeables.add(MockitoAnnotations.openMocks(testClassInstance));
            }
        }
        catch (RuntimeException e) {
            try {
                this.release();
            }
            catch (Throwable t) {
                e.addSuppressed(t);
            }
            this.listener.setListenerDirty();
            throw e;
        }
    }

    @Override
    public void setStrictness(Strictness strictness) {
        this.listener.setStrictness(strictness);
    }

    @Override
    public void finishMocking() {
        this.finishMocking(null);
    }

    @Override
    public void finishMocking(final Throwable failure) {
        try {
            Mockito.framework().removeListener(this.listener);
            this.listener.testFinished(new TestFinishedEvent(){

                public Throwable getFailure() {
                    return failure;
                }

                public String getTestName() {
                    return DefaultMockitoSession.this.name;
                }
            });
            if (failure == null) {
                Mockito.validateMockitoUsage();
            }
        }
        finally {
            this.release();
        }
    }

    private void release() {
        for (AutoCloseable closeable : this.closeables) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                throw new MockitoException("Failed to release " + closeable, e);
            }
        }
    }
}

