/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.mockito.internal.debugging;

import org.apache.hadoop.shaded.org.mockito.internal.debugging.Java8LocationImpl;
import org.apache.hadoop.shaded.org.mockito.internal.debugging.Java9PlusLocationImpl;
import org.apache.hadoop.shaded.org.mockito.invocation.Location;

public final class LocationFactory {
    private static final Factory factory = LocationFactory.createLocationFactory();

    private LocationFactory() {
    }

    public static Location create() {
        return LocationFactory.create(false);
    }

    public static Location create(boolean inline) {
        return factory.create(inline);
    }

    private static Factory createLocationFactory() {
        try {
            Class.forName("java.lang.StackWalker");
            return new Java9PlusLocationFactory();
        }
        catch (ClassNotFoundException e) {
            return new Java8LocationFactory();
        }
    }

    private static final class Java9PlusLocationFactory
    implements Factory {
        private Java9PlusLocationFactory() {
        }

        @Override
        public Location create(boolean inline) {
            return new Java9PlusLocationImpl(inline);
        }
    }

    private static final class Java8LocationFactory
    implements Factory {
        private Java8LocationFactory() {
        }

        @Override
        public Location create(boolean inline) {
            return new Java8LocationImpl(new Throwable(), inline);
        }
    }

    private static interface Factory {
        public Location create(boolean var1);
    }
}

