/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.mockito.internal.debugging;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.shaded.org.mockito.exceptions.base.MockitoException;
import org.apache.hadoop.shaded.org.mockito.exceptions.stacktrace.StackTraceCleaner;
import org.apache.hadoop.shaded.org.mockito.internal.configuration.plugins.Plugins;
import org.apache.hadoop.shaded.org.mockito.internal.exceptions.stacktrace.DefaultStackTraceCleaner;
import org.apache.hadoop.shaded.org.mockito.invocation.Location;

class Java9PlusLocationImpl
implements Location,
Serializable {
    private static final long serialVersionUID = 2954388321980069195L;
    private static final String UNEXPECTED_ERROR_SUFFIX = "\nThis is unexpected and is likely due to a change in either Java's StackWalker or Reflection APIs.\nIt's worth trying to upgrade to a newer version of Mockito, or otherwise to file a bug report.";
    private static final String STACK_WALKER = "java.lang.StackWalker";
    private static final String STACK_FRAME = "java.lang.StackWalker$StackFrame";
    private static final String OPTION = "java.lang.StackWalker$Option";
    private static final String SHOW_REFLECT_FRAMES = "SHOW_REFLECT_FRAMES";
    private static final int BUFFER_SIZE = 16;
    private static final Class<?> stackWalkerClazz = Java9PlusLocationImpl.clazz("java.lang.StackWalker");
    private static final Class<?> stackFrameClazz = Java9PlusLocationImpl.clazz("java.lang.StackWalker$StackFrame");
    private static final Class<?> optionClazz = Java9PlusLocationImpl.clazz("java.lang.StackWalker$Option");
    private static final Object stackWalker = Java9PlusLocationImpl.stackWalker();
    private static final Method walk = Java9PlusLocationImpl.walk();
    private static final String PREFIX = "-> at ";
    private static final StackTraceCleaner CLEANER = Plugins.getStackTraceCleanerProvider().getStackTraceCleaner(new DefaultStackTraceCleaner());
    private static final Function<Object, StackTraceCleaner.StackFrameMetadata> toStackFrameMetadata = x$0 -> new MetadataShim(x$0);
    private static final Predicate<StackTraceCleaner.StackFrameMetadata> cleanerIsIn = CLEANER::isIn;
    private static final int FRAMES_TO_SKIP = Java9PlusLocationImpl.framesToSkip();
    private final StackTraceCleaner.StackFrameMetadata sfm;
    private volatile String stackTraceLine;

    Java9PlusLocationImpl(boolean isInline) {
        this.sfm = Java9PlusLocationImpl.getStackFrame(isInline);
    }

    @Override
    public String getSourceFile() {
        return this.sfm.getFileName();
    }

    @Override
    public String toString() {
        return this.stackTraceLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String stackTraceLine() {
        if (this.stackTraceLine == null) {
            Java9PlusLocationImpl java9PlusLocationImpl = this;
            synchronized (java9PlusLocationImpl) {
                if (this.stackTraceLine == null) {
                    this.stackTraceLine = PREFIX + this.sfm.toString();
                }
            }
        }
        return this.stackTraceLine;
    }

    private static StackTraceCleaner.StackFrameMetadata getStackFrame(boolean isInline) {
        return Java9PlusLocationImpl.stackWalk(stream -> stream.map(toStackFrameMetadata).skip(FRAMES_TO_SKIP).filter(cleanerIsIn).skip(isInline ? 1L : 0L).findFirst().orElseThrow(() -> new MockitoException(Java9PlusLocationImpl.noStackTraceFailureMessage())));
    }

    private static boolean usingDefaultStackTraceCleaner() {
        return CLEANER instanceof DefaultStackTraceCleaner;
    }

    private static String noStackTraceFailureMessage() {
        if (Java9PlusLocationImpl.usingDefaultStackTraceCleaner()) {
            return "Mockito could not find the first non-Mockito stack frame.\nThis is unexpected and is likely due to a change in either Java's StackWalker or Reflection APIs.\nIt's worth trying to upgrade to a newer version of Mockito, or otherwise to file a bug report.";
        }
        String cleanerType = CLEANER.getClass().getName();
        String fmt = "Mockito could not find the first non-Mockito stack frame. A custom stack frame cleaner \n(type %s) is in use and this has mostly likely filtered out all the relevant stack frames.";
        return String.format(fmt, cleanerType);
    }

    private static int framesToSkip() {
        return Java9PlusLocationImpl.stackWalk(stream -> {
            List metadata = stream.map(toStackFrameMetadata).map(StackTraceCleaner.StackFrameMetadata::getClassName).collect(Collectors.toList());
            return metadata.indexOf(Java9PlusLocationImpl.class.getName());
        });
    }

    private static <T> T stackWalk(Function<Stream<Object>, T> function) {
        try {
            return (T)walk.invoke(stackWalker, function);
        }
        catch (IllegalAccessException e) {
            throw new MockitoException("Unexpected access exception while stack walking.\nThis is unexpected and is likely due to a change in either Java's StackWalker or Reflection APIs.\nIt's worth trying to upgrade to a newer version of Mockito, or otherwise to file a bug report.", e);
        }
        catch (InvocationTargetException e) {
            throw new MockitoException(Java9PlusLocationImpl.stackWalkFailureMessage());
        }
    }

    private static String stackWalkFailureMessage() {
        if (Java9PlusLocationImpl.usingDefaultStackTraceCleaner()) {
            return "Caught an unexpected exception while stack walking.\nThis is unexpected and is likely due to a change in either Java's StackWalker or Reflection APIs.\nIt's worth trying to upgrade to a newer version of Mockito, or otherwise to file a bug report.";
        }
        String className = CLEANER.getClass().getName();
        String fmt = "Caught an unexpected exception while stack walking.\nThis is likely caused by the custom stack trace cleaner in use (class %s).";
        return String.format(fmt, className);
    }

    private static Method walk() {
        try {
            return stackWalkerClazz.getMethod("walk", Function.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static Class<?> clazz(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static Object stackWalker() {
        try {
            Set<?> options = Collections.singleton(Enum.valueOf(optionClazz, SHOW_REFLECT_FRAMES));
            Method getInstance = stackWalkerClazz.getDeclaredMethod("getInstance", Set.class, Integer.TYPE);
            return getInstance.invoke(null, options, 16);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new MockitoException("Mockito received an exception while trying to acquire a StackWalker.\nThis is unexpected and is likely due to a change in either Java's StackWalker or Reflection APIs.\nIt's worth trying to upgrade to a newer version of Mockito, or otherwise to file a bug report.");
        }
    }

    private static final class SerializableShim
    implements StackTraceCleaner.StackFrameMetadata,
    Serializable {
        private static final long serialVersionUID = 7908320459080898690L;
        private final StackTraceElement ste;

        private SerializableShim(StackTraceElement ste) {
            this.ste = ste;
        }

        @Override
        public String getClassName() {
            return this.ste.getClassName();
        }

        @Override
        public String getMethodName() {
            return this.ste.getMethodName();
        }

        @Override
        public String getFileName() {
            return this.ste.getFileName();
        }

        @Override
        public int getLineNumber() {
            return this.ste.getLineNumber();
        }
    }

    private static final class MetadataShim
    implements StackTraceCleaner.StackFrameMetadata,
    Serializable {
        private static final long serialVersionUID = 8491903719411428648L;
        private static final Method getClassName = MetadataShim.getter("getClassName");
        private static final Method getMethodName = MetadataShim.getter("getMethodName");
        private static final Method getFileName = MetadataShim.getter("getFileName");
        private static final Method getLineNumber = MetadataShim.getter("getLineNumber");
        private static final Method toString = MetadataShim.getter(Object.class, "toString");
        private final Object stackFrame;

        private MetadataShim(Object stackFrame) {
            this.stackFrame = stackFrame;
        }

        @Override
        public String getClassName() {
            return (String)this.get(getClassName);
        }

        @Override
        public String getMethodName() {
            return (String)this.get(getMethodName);
        }

        @Override
        public String getFileName() {
            return (String)this.get(getFileName);
        }

        @Override
        public int getLineNumber() {
            return (Integer)this.get(getLineNumber);
        }

        public String toString() {
            return (String)this.get(toString);
        }

        private Object writeReplace() {
            return new SerializableShim(this.toStackTraceElement());
        }

        private StackTraceElement toStackTraceElement() {
            try {
                Method method = stackFrameClazz.getMethod("toStackTraceElement", new Class[0]);
                return (StackTraceElement)method.invoke(this.stackFrame, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        private Object get(Method handle) {
            try {
                return handle.invoke(this.stackFrame, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        private static Method getter(String name) {
            return MetadataShim.getter(stackFrameClazz, name);
        }

        private static Method getter(Class<?> clazz, String name) {
            try {
                return clazz.getDeclaredMethod(name, new Class[0]);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }
}

