/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.mockito.internal.creation.bytebuddy;

import java.lang.reflect.Method;
import org.apache.hadoop.shaded.org.mockito.exceptions.base.MockitoException;

class TypeSupport {
    static final TypeSupport INSTANCE;
    private final Method isSealed;

    private TypeSupport(Method isSealed) {
        this.isSealed = isSealed;
    }

    boolean isSealed(Class<?> type) {
        if (this.isSealed == null) {
            return false;
        }
        try {
            return (Boolean)this.isSealed.invoke(type, new Object[0]);
        }
        catch (Throwable t) {
            throw new MockitoException("Failed to check if type is sealed using handle " + this.isSealed, t);
        }
    }

    static {
        Method isSealed;
        try {
            isSealed = Class.class.getMethod("isSealed", new Class[0]);
        }
        catch (NoSuchMethodException ignored) {
            isSealed = null;
        }
        INSTANCE = new TypeSupport(isSealed);
    }
}

