/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.mockito.internal.creation.bytebuddy;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.hadoop.shaded.net.bytebuddy.ByteBuddy;
import org.apache.hadoop.shaded.net.bytebuddy.description.method.MethodDescription;
import org.apache.hadoop.shaded.net.bytebuddy.description.modifier.SynchronizationState;
import org.apache.hadoop.shaded.net.bytebuddy.description.modifier.Visibility;
import org.apache.hadoop.shaded.net.bytebuddy.dynamic.DynamicType;
import org.apache.hadoop.shaded.net.bytebuddy.dynamic.Transformer;
import org.apache.hadoop.shaded.net.bytebuddy.dynamic.loading.MultipleParentClassLoader;
import org.apache.hadoop.shaded.net.bytebuddy.dynamic.scaffold.TypeValidation;
import org.apache.hadoop.shaded.net.bytebuddy.implementation.FieldAccessor;
import org.apache.hadoop.shaded.net.bytebuddy.implementation.Implementation;
import org.apache.hadoop.shaded.net.bytebuddy.implementation.MethodDelegation;
import org.apache.hadoop.shaded.net.bytebuddy.implementation.attribute.MethodAttributeAppender;
import org.apache.hadoop.shaded.net.bytebuddy.matcher.ElementMatcher;
import org.apache.hadoop.shaded.net.bytebuddy.matcher.ElementMatchers;
import org.apache.hadoop.shaded.net.bytebuddy.utility.GraalImageCode;
import org.apache.hadoop.shaded.net.bytebuddy.utility.RandomString;
import org.apache.hadoop.shaded.org.mockito.codegen.InjectionBase;
import org.apache.hadoop.shaded.org.mockito.exceptions.base.MockitoException;
import org.apache.hadoop.shaded.org.mockito.internal.creation.bytebuddy.ByteBuddyCrossClassLoaderSerializationSupport;
import org.apache.hadoop.shaded.org.mockito.internal.creation.bytebuddy.BytecodeGenerator;
import org.apache.hadoop.shaded.org.mockito.internal.creation.bytebuddy.MockAccess;
import org.apache.hadoop.shaded.org.mockito.internal.creation.bytebuddy.MockFeatures;
import org.apache.hadoop.shaded.org.mockito.internal.creation.bytebuddy.MockMethodInterceptor;
import org.apache.hadoop.shaded.org.mockito.internal.creation.bytebuddy.ModuleHandler;
import org.apache.hadoop.shaded.org.mockito.internal.creation.bytebuddy.SubclassInjectionLoader;
import org.apache.hadoop.shaded.org.mockito.internal.creation.bytebuddy.SubclassLoader;
import org.apache.hadoop.shaded.org.mockito.internal.util.StringUtil;
import org.apache.hadoop.shaded.org.mockito.mock.SerializableMode;

class SubclassBytecodeGenerator
implements BytecodeGenerator {
    private static final String CODEGEN_PACKAGE = "org.apache.hadoop.shaded.org.mockito.codegen.";
    private final SubclassLoader loader;
    private final ModuleHandler handler;
    private final ByteBuddy byteBuddy;
    private final Implementation readReplace;
    private final ElementMatcher<? super MethodDescription> matcher;
    private final Implementation dispatcher = MethodDelegation.to(MockMethodInterceptor.DispatcherDefaultingToRealMethod.class);
    private final Implementation hashCode = MethodDelegation.to(MockMethodInterceptor.ForHashCode.class);
    private final Implementation equals = MethodDelegation.to(MockMethodInterceptor.ForEquals.class);
    private final Implementation writeReplace = MethodDelegation.to(MockMethodInterceptor.ForWriteReplace.class);

    public SubclassBytecodeGenerator() {
        this(new SubclassInjectionLoader());
    }

    public SubclassBytecodeGenerator(SubclassLoader loader) {
        this(loader, null, ElementMatchers.any());
    }

    public SubclassBytecodeGenerator(Implementation readReplace, ElementMatcher<? super MethodDescription> matcher) {
        this(new SubclassInjectionLoader(), readReplace, matcher);
    }

    protected SubclassBytecodeGenerator(SubclassLoader loader, Implementation readReplace, ElementMatcher<? super MethodDescription> matcher) {
        this.loader = loader;
        this.readReplace = readReplace;
        this.matcher = matcher;
        this.byteBuddy = new ByteBuddy().with(TypeValidation.DISABLED);
        this.handler = ModuleHandler.make(this.byteBuddy, loader);
    }

    private static boolean needsSamePackageClassLoader(MockFeatures<?> features) {
        if (!Modifier.isPublic(features.mockedType.getModifiers()) || !features.mockedType.isInterface()) {
            return true;
        }
        if (SubclassBytecodeGenerator.hasNonPublicTypeReference(features.mockedType)) {
            return true;
        }
        for (Class<?> iface : features.interfaces) {
            if (!Modifier.isPublic(iface.getModifiers())) {
                return true;
            }
            if (!SubclassBytecodeGenerator.hasNonPublicTypeReference(iface)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasNonPublicTypeReference(Class<?> iface) {
        for (Method method : iface.getMethods()) {
            if (!Modifier.isPublic(method.getReturnType().getModifiers())) {
                return true;
            }
            for (Class<?> param : method.getParameterTypes()) {
                if (Modifier.isPublic(param.getModifiers())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public <T> Class<? extends T> mockClass(MockFeatures<T> features) {
        Class target;
        ClassLoader classLoader;
        MultipleParentClassLoader.Builder loaderBuilder = new MultipleParentClassLoader.Builder().appendMostSpecific(features.mockedType).appendMostSpecific(features.interfaces).appendMostSpecific(MockAccess.class, MockMethodInterceptor.DispatcherDefaultingToRealMethod.class).appendMostSpecific(MockMethodInterceptor.class, MockMethodInterceptor.ForHashCode.class, MockMethodInterceptor.ForEquals.class);
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        boolean shouldIncludeContextLoader = true;
        if (SubclassBytecodeGenerator.needsSamePackageClassLoader(features)) {
            ClassLoader candidateLoader = loaderBuilder.build();
            for (ClassLoader parent = contextLoader; parent != null; parent = parent.getParent()) {
                if (parent != candidateLoader) continue;
                shouldIncludeContextLoader = false;
                break;
            }
        }
        if (shouldIncludeContextLoader) {
            loaderBuilder = loaderBuilder.appendMostSpecific(contextLoader);
        }
        boolean localMock = (classLoader = loaderBuilder.build()) == features.mockedType.getClassLoader() && features.serializableMode != SerializableMode.ACROSS_CLASSLOADERS && !this.isComingFromJDK(features.mockedType) && (this.loader.isDisrespectingOpenness() || this.handler.isOpened(features.mockedType, MockAccess.class)) && !GraalImageCode.getCurrent().isDefined();
        String typeName = localMock || this.loader instanceof MultipleParentClassLoader && !this.isComingFromJDK(features.mockedType) ? features.mockedType.getName() : InjectionBase.class.getPackage().getName() + "." + features.mockedType.getSimpleName();
        String name = String.format("%s$%s$%s", typeName, "MockitoMock", GraalImageCode.getCurrent().isDefined() ? SubclassBytecodeGenerator.suffix(features) : RandomString.make());
        if (localMock) {
            this.handler.adjustModuleGraph(features.mockedType, MockAccess.class, false, true);
            for (Class<?> iFace : features.interfaces) {
                this.handler.adjustModuleGraph(iFace, features.mockedType, true, false);
                this.handler.adjustModuleGraph(features.mockedType, iFace, false, true);
            }
        } else {
            boolean exported = this.handler.isExported(features.mockedType);
            Iterator<Class<?>> it = features.interfaces.iterator();
            while (exported && it.hasNext()) {
                exported = this.handler.isExported(it.next());
            }
            if (exported) {
                SubclassBytecodeGenerator.assertVisibility(features.mockedType);
                for (Class<?> iFace : features.interfaces) {
                    SubclassBytecodeGenerator.assertVisibility(iFace);
                }
            } else {
                Class<?> hook = this.handler.injectionBase(classLoader, typeName);
                SubclassBytecodeGenerator.assertVisibility(features.mockedType);
                this.handler.adjustModuleGraph(features.mockedType, hook, true, false);
                for (Class<?> iFace : features.interfaces) {
                    SubclassBytecodeGenerator.assertVisibility(iFace);
                    this.handler.adjustModuleGraph(iFace, hook, true, false);
                }
            }
        }
        Class<Object> clazz = target = GraalImageCode.getCurrent().isDefined() && features.mockedType.isInterface() ? Object.class : features.mockedType;
        Annotation[] annotationsOnType = features.stripAnnotations ? new Annotation[]{} : (!features.mockedType.isInterface() || features.interfaces.isEmpty() ? features.mockedType.getAnnotations() : new Annotation[]{});
        DynamicType.Builder<Object> builder = this.byteBuddy.subclass(target).name(name).ignoreAlso(BytecodeGenerator.isGroovyMethod(false)).annotateType(annotationsOnType).implement(new ArrayList(GraalImageCode.getCurrent().isDefined() ? SubclassBytecodeGenerator.sortedSerializable(features.interfaces, GraalImageCode.getCurrent().isDefined() && features.mockedType.isInterface() ? features.mockedType : Void.TYPE) : features.interfaces)).method(this.matcher).intercept(this.dispatcher).transform(Transformer.ForMethod.withModifiers(SynchronizationState.PLAIN)).attribute((MethodAttributeAppender.Factory)((Object)(features.stripAnnotations ? MethodAttributeAppender.NoOp.INSTANCE : MethodAttributeAppender.ForInstrumentedMethod.INCLUDING_RECEIVER))).serialVersionUid(42L).defineField("mockitoInterceptor", (Type)((Object)MockMethodInterceptor.class), Visibility.PRIVATE).implement(new Type[]{MockAccess.class}).intercept(FieldAccessor.ofBeanProperty()).method(ElementMatchers.isHashCode()).intercept(this.hashCode).method(ElementMatchers.isEquals()).intercept(this.equals);
        if (features.serializableMode == SerializableMode.ACROSS_CLASSLOADERS) {
            builder = builder.implement(new Type[]{ByteBuddyCrossClassLoaderSerializationSupport.CrossClassLoaderSerializableMock.class}).intercept(this.writeReplace);
        }
        if (this.readReplace != null) {
            builder = builder.defineMethod("readObject", Void.TYPE, Visibility.PRIVATE).withParameters(new Type[]{ObjectInputStream.class}).throwing(new Type[]{ClassNotFoundException.class, IOException.class}).intercept(this.readReplace);
        }
        if (name.startsWith(CODEGEN_PACKAGE) || classLoader instanceof MultipleParentClassLoader) {
            builder = builder.ignoreAlso(ElementMatchers.isPackagePrivate().or(ElementMatchers.returns(ElementMatchers.isPackagePrivate())).or(ElementMatchers.hasParameters(ElementMatchers.whereAny(ElementMatchers.hasType(ElementMatchers.isPackagePrivate())))));
        }
        return builder.make().load(classLoader, this.loader.resolveStrategy(features.mockedType, classLoader, localMock)).getLoaded();
    }

    private static CharSequence suffix(MockFeatures<?> features) {
        StringBuilder sb = new StringBuilder();
        TreeSet<String> names = new TreeSet<String>();
        names.add(features.mockedType.getName());
        for (Class<?> type : features.interfaces) {
            names.add(type.getName());
        }
        return sb.append(RandomString.hashOf(names.hashCode())).append(RandomString.hashOf(features.serializableMode.name().hashCode())).append(features.stripAnnotations ? "S" : "N");
    }

    private static Collection<? extends Type> sortedSerializable(Collection<Class<?>> interfaces, Class<?> mockedType) {
        TreeSet<Class> types = new TreeSet<Class>(Comparator.comparing(Class::getName));
        types.addAll(interfaces);
        if (mockedType != Void.TYPE) {
            types.add(mockedType);
        }
        types.add(Serializable.class);
        return types;
    }

    @Override
    public void mockClassStatic(Class<?> type) {
        throw new MockitoException("The subclass byte code generator cannot create static mocks");
    }

    @Override
    public void mockClassConstruction(Class<?> type) {
        throw new MockitoException("The subclass byte code generator cannot create construction mocks");
    }

    private boolean isComingFromJDK(Class<?> type) {
        return type.getPackage() != null && "Java Runtime Environment".equalsIgnoreCase(type.getPackage().getImplementationTitle()) || type.getName().startsWith("java.") || type.getName().startsWith("javax.");
    }

    private static void assertVisibility(Class<?> type) {
        if (!Modifier.isPublic(type.getModifiers())) {
            throw new MockitoException(StringUtil.join("Cannot create mock for " + type, "", "The type is not public and its mock class is loaded by a different class loader.", "This can have multiple reasons:", " - You are mocking a class with additional interfaces of another class loader", " - Mockito is loaded by a different class loader than the mocked type (e.g. with OSGi)", " - The thread's context class loader is different than the mock's class loader"));
        }
    }
}

