/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.mockito.internal.creation.bytebuddy;

import java.util.function.Predicate;

class StackTraceChecker
implements Predicate<Class<?>> {
    StackTraceChecker() {
    }

    @Override
    public boolean test(Class<?> type) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        for (int index = 1; index < stackTrace.length - 1; ++index) {
            if (stackTrace[index].getClassName().startsWith("org.apache.hadoop.shaded.org.mockito.internal.") || !stackTrace[index + 1].getMethodName().startsWith("<init>")) continue;
            try {
                if (!stackTrace[index + 1].getClassName().equals(type.getName()) && type.isAssignableFrom(Class.forName(stackTrace[index + 1].getClassName(), false, type.getClassLoader()))) {
                    return true;
                }
            }
            catch (ClassNotFoundException ignored) {}
            break;
        }
        return false;
    }
}

