/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.mockito.internal.creation.bytebuddy;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.hadoop.shaded.net.bytebuddy.ByteBuddy;
import org.apache.hadoop.shaded.net.bytebuddy.ClassFileVersion;
import org.apache.hadoop.shaded.net.bytebuddy.asm.Advice;
import org.apache.hadoop.shaded.net.bytebuddy.asm.AsmVisitorWrapper;
import org.apache.hadoop.shaded.net.bytebuddy.description.field.FieldDescription;
import org.apache.hadoop.shaded.net.bytebuddy.description.field.FieldList;
import org.apache.hadoop.shaded.net.bytebuddy.description.method.MethodDescription;
import org.apache.hadoop.shaded.net.bytebuddy.description.method.MethodList;
import org.apache.hadoop.shaded.net.bytebuddy.description.method.ParameterDescription;
import org.apache.hadoop.shaded.net.bytebuddy.description.type.TypeDescription;
import org.apache.hadoop.shaded.net.bytebuddy.dynamic.ClassFileLocator;
import org.apache.hadoop.shaded.net.bytebuddy.dynamic.scaffold.MethodGraph;
import org.apache.hadoop.shaded.net.bytebuddy.dynamic.scaffold.TypeValidation;
import org.apache.hadoop.shaded.net.bytebuddy.implementation.Implementation;
import org.apache.hadoop.shaded.net.bytebuddy.implementation.MethodDelegation;
import org.apache.hadoop.shaded.net.bytebuddy.implementation.bind.annotation.TargetMethodAnnotationDrivenBinder;
import org.apache.hadoop.shaded.net.bytebuddy.jar.asm.ClassVisitor;
import org.apache.hadoop.shaded.net.bytebuddy.jar.asm.MethodVisitor;
import org.apache.hadoop.shaded.net.bytebuddy.matcher.ElementMatchers;
import org.apache.hadoop.shaded.net.bytebuddy.pool.TypePool;
import org.apache.hadoop.shaded.net.bytebuddy.utility.OpenedClassReader;
import org.apache.hadoop.shaded.net.bytebuddy.utility.RandomString;
import org.apache.hadoop.shaded.org.mockito.exceptions.base.MockitoException;
import org.apache.hadoop.shaded.org.mockito.internal.SuppressSignatureCheck;
import org.apache.hadoop.shaded.org.mockito.internal.creation.bytebuddy.BytecodeGenerator;
import org.apache.hadoop.shaded.org.mockito.internal.creation.bytebuddy.ConstructionCallback;
import org.apache.hadoop.shaded.org.mockito.internal.creation.bytebuddy.MockFeatures;
import org.apache.hadoop.shaded.org.mockito.internal.creation.bytebuddy.MockMethodAdvice;
import org.apache.hadoop.shaded.org.mockito.internal.creation.bytebuddy.MockMethodInterceptor;
import org.apache.hadoop.shaded.org.mockito.internal.creation.bytebuddy.SubclassBytecodeGenerator;
import org.apache.hadoop.shaded.org.mockito.internal.creation.bytebuddy.TypeCachingBytecodeGenerator;
import org.apache.hadoop.shaded.org.mockito.internal.creation.bytebuddy.TypeSupport;
import org.apache.hadoop.shaded.org.mockito.internal.creation.bytebuddy.inject.MockMethodDispatcher;
import org.apache.hadoop.shaded.org.mockito.internal.util.StringUtil;
import org.apache.hadoop.shaded.org.mockito.internal.util.concurrent.DetachedThreadLocal;
import org.apache.hadoop.shaded.org.mockito.internal.util.concurrent.WeakConcurrentMap;
import org.apache.hadoop.shaded.org.mockito.internal.util.concurrent.WeakConcurrentSet;
import org.apache.hadoop.shaded.org.mockito.mock.SerializableMode;

@SuppressSignatureCheck
public class InlineBytecodeGenerator
implements BytecodeGenerator,
ClassFileTransformer {
    private static final String PRELOAD = "org.apache.hadoop.shaded.org.mockito.inline.preload";
    static final Set<Class<?>> EXCLUDES = new HashSet<Class>(Arrays.asList(Class.class, Boolean.class, Byte.class, Short.class, Character.class, Integer.class, Long.class, Float.class, Double.class, String.class));
    private final Instrumentation instrumentation;
    private final ByteBuddy byteBuddy;
    private final WeakConcurrentSet<Class<?>> mocked;
    private final WeakConcurrentSet<Class<?>> flatMocked;
    private final BytecodeGenerator subclassEngine;
    private final AsmVisitorWrapper mockTransformer;
    private final Method getModule;
    private final Method canRead;
    private final Method redefineModule;
    private volatile Throwable lastException;

    public InlineBytecodeGenerator(Instrumentation instrumentation, WeakConcurrentMap<Object, MockMethodInterceptor> mocks, DetachedThreadLocal<Map<Class<?>, MockMethodInterceptor>> mockedStatics, Predicate<Class<?>> isMockConstruction, ConstructionCallback onConstruction) {
        Method redefineModule;
        Method canRead;
        Method getModule;
        InlineBytecodeGenerator.preload();
        this.instrumentation = instrumentation;
        this.byteBuddy = new ByteBuddy().with(TypeValidation.DISABLED).with(Implementation.Context.Disabled.Factory.INSTANCE).with(MethodGraph.Compiler.ForDeclaredMethods.INSTANCE).ignore(ElementMatchers.isSynthetic().and(ElementMatchers.not(ElementMatchers.isConstructor())).or(ElementMatchers.isDefaultFinalizer()));
        this.mocked = new WeakConcurrentSet(WeakConcurrentSet.Cleaner.MANUAL);
        this.flatMocked = new WeakConcurrentSet(WeakConcurrentSet.Cleaner.MANUAL);
        String identifier = RandomString.make();
        this.subclassEngine = new TypeCachingBytecodeGenerator(new SubclassBytecodeGenerator(MethodDelegation.withDefaultConfiguration().withBinders(TargetMethodAnnotationDrivenBinder.ParameterBinder.ForFixedValue.OfConstant.of(MockMethodAdvice.Identifier.class, identifier)).to(MockMethodAdvice.ForReadObject.class), ElementMatchers.isAbstract().or(ElementMatchers.isNative()).or(ElementMatchers.isToString())), false);
        this.mockTransformer = new AsmVisitorWrapper.ForDeclaredMethods().method(ElementMatchers.isVirtual().and(ElementMatchers.not(ElementMatchers.isBridge().or(ElementMatchers.isHashCode()).or(ElementMatchers.isEquals()).or(ElementMatchers.isDefaultFinalizer()))).and(ElementMatchers.not(ElementMatchers.isDeclaredBy(ElementMatchers.nameStartsWith("java.")).and(ElementMatchers.isPackagePrivate())).and(ElementMatchers.not(BytecodeGenerator.isGroovyMethod(true)))), Advice.withCustomMapping().bind(MockMethodAdvice.Identifier.class, identifier).to(MockMethodAdvice.class)).method(ElementMatchers.isStatic().and(ElementMatchers.not(BytecodeGenerator.isGroovyMethod(true))), Advice.withCustomMapping().bind(MockMethodAdvice.Identifier.class, identifier).to(MockMethodAdvice.ForStatic.class)).constructor(ElementMatchers.any(), new MockMethodAdvice.ConstructorShortcut(identifier)).method(ElementMatchers.isHashCode(), Advice.withCustomMapping().bind(MockMethodAdvice.Identifier.class, identifier).to(MockMethodAdvice.ForHashCode.class)).method(ElementMatchers.isEquals(), Advice.withCustomMapping().bind(MockMethodAdvice.Identifier.class, identifier).to(MockMethodAdvice.ForEquals.class));
        try {
            getModule = Class.class.getMethod("getModule", new Class[0]);
            canRead = getModule.getReturnType().getMethod("canRead", getModule.getReturnType());
            redefineModule = Instrumentation.class.getMethod("redefineModule", getModule.getReturnType(), Set.class, Map.class, Map.class, Set.class, Map.class);
        }
        catch (Exception ignored) {
            getModule = null;
            canRead = null;
            redefineModule = null;
        }
        this.getModule = getModule;
        this.canRead = canRead;
        this.redefineModule = redefineModule;
        MockMethodDispatcher.set((String)identifier, (MockMethodDispatcher)new MockMethodAdvice(mocks, mockedStatics, identifier, isMockConstruction, onConstruction));
        instrumentation.addTransformer(this, true);
    }

    private static void preload() {
        String preloads = System.getProperty(PRELOAD);
        if (preloads == null) {
            preloads = "java.lang.WeakPairMap,java.lang.WeakPairMap$Pair,java.lang.WeakPairMap$Pair$Weak";
        }
        for (String preload : preloads.split(",")) {
            try {
                Class.forName(preload, false, null);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Class<? extends T> mockClass(MockFeatures<T> features) {
        boolean subclassingRequired = !features.interfaces.isEmpty() || features.serializableMode != SerializableMode.NONE || Modifier.isAbstract(features.mockedType.getModifiers());
        this.checkSupportedCombination(subclassingRequired, features);
        HashSet types = new HashSet();
        types.add(features.mockedType);
        types.addAll(features.interfaces);
        InlineBytecodeGenerator inlineBytecodeGenerator = this;
        synchronized (inlineBytecodeGenerator) {
            this.triggerRetransformation(types, false);
        }
        return subclassingRequired ? this.subclassEngine.mockClass(features) : features.mockedType;
    }

    @Override
    public synchronized void mockClassStatic(Class<?> type) {
        this.triggerRetransformation(Collections.singleton(type), true);
    }

    @Override
    public synchronized void mockClassConstruction(Class<?> type) {
        this.triggerRetransformation(Collections.singleton(type), false);
    }

    private static void assureInitialization(Class<?> type) {
        try {
            Class.forName(type.getName(), true, type.getClassLoader());
        }
        catch (ExceptionInInitializerError e) {
            throw new MockitoException("Cannot instrument " + type + " because it or one of its supertypes could not be initialized", e.getException());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private <T> void triggerRetransformation(Set<Class<?>> types, boolean flat) {
        HashSet targets = new HashSet();
        try {
            for (Class<?> type : types) {
                if (flat) {
                    if (this.mocked.contains(type) || !this.flatMocked.add(type)) continue;
                    InlineBytecodeGenerator.assureInitialization(type);
                    targets.add(type);
                    continue;
                }
                do {
                    if (!this.mocked.add(type)) continue;
                    if (!this.flatMocked.remove(type)) {
                        InlineBytecodeGenerator.assureInitialization(type);
                        targets.add(type);
                    }
                    this.addInterfaces(targets, type.getInterfaces());
                } while ((type = type.getSuperclass()) != null);
            }
        }
        catch (Throwable t) {
            for (Class clazz : targets) {
                this.mocked.remove(clazz);
                this.flatMocked.remove(clazz);
            }
            throw t;
        }
        if (!targets.isEmpty()) {
            try {
                this.assureCanReadMockito(targets);
                this.instrumentation.retransformClasses(targets.toArray(new Class[targets.size()]));
                Throwable throwable = this.lastException;
                if (throwable != null) {
                    throw new IllegalStateException(StringUtil.join("Byte Buddy could not instrument all classes within the mock's type hierarchy", "", "This problem should never occur for javac-compiled classes. This problem has been observed for classes that are:", " - Compiled by older versions of scalac", " - Classes that are part of the Android distribution"), throwable);
                }
            }
            catch (Exception exception) {
                for (Class clazz : targets) {
                    this.mocked.remove(clazz);
                    this.flatMocked.remove(clazz);
                }
                throw new MockitoException("Could not modify all classes " + targets, exception);
            }
            finally {
                this.lastException = null;
            }
        }
        this.mocked.expungeStaleEntries();
        this.flatMocked.expungeStaleEntries();
    }

    private void assureCanReadMockito(Set<Class<?>> types) {
        if (this.redefineModule == null) {
            return;
        }
        HashSet<Object> modules = new HashSet<Object>();
        try {
            Object target = this.getModule.invoke(Class.forName("org.apache.hadoop.shaded.org.mockito.internal.creation.bytebuddy.inject.MockMethodDispatcher", false, null), new Object[0]);
            for (Class<?> clazz : types) {
                Object module = this.getModule.invoke(clazz, new Object[0]);
                if (modules.contains(module) || ((Boolean)this.canRead.invoke(module, target)).booleanValue()) continue;
                modules.add(module);
            }
            for (Class<Object> clazz : modules) {
                this.redefineModule.invoke((Object)this.instrumentation, clazz, Collections.singleton(target), Collections.emptyMap(), Collections.emptyMap(), Collections.emptySet(), Collections.emptyMap());
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(StringUtil.join("Could not adjust module graph to make the mock instance dispatcher visible to some classes", "", "At least one of those modules: " + modules + " is not reading the unnamed module of the bootstrap loader", "Without such a read edge, the classes that are redefined to become mocks cannot access the mock dispatcher.", "To circumvent this, Mockito attempted to add a read edge to this module what failed for an unexpected reason"), e);
        }
    }

    private <T> void checkSupportedCombination(boolean subclassingRequired, MockFeatures<T> features) {
        block2: {
            block3: {
                if (!subclassingRequired || features.mockedType.isArray() || features.mockedType.isPrimitive()) break block2;
                if (Modifier.isFinal(features.mockedType.getModifiers()) || TypeSupport.INSTANCE.isSealed(features.mockedType)) break block3;
                if (!features.interfaces.stream().anyMatch(TypeSupport.INSTANCE::isSealed)) break block2;
            }
            throw new MockitoException("Unsupported settings with this type '" + features.mockedType.getName() + "'");
        }
    }

    private void addInterfaces(Set<Class<?>> types, Class<?>[] interfaces) {
        for (Class<?> type : interfaces) {
            if (!this.mocked.add(type)) continue;
            if (!this.flatMocked.remove(type)) {
                InlineBytecodeGenerator.assureInitialization(type);
                types.add(type);
            }
            this.addInterfaces(types, type.getInterfaces());
        }
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        if (classBeingRedefined == null || !this.mocked.contains(classBeingRedefined) && !this.flatMocked.contains(classBeingRedefined) || EXCLUDES.contains(classBeingRedefined)) {
            return null;
        }
        try {
            return this.byteBuddy.redefine(classBeingRedefined, ClassFileLocator.Simple.of(classBeingRedefined.getName(), classfileBuffer)).visit(new ParameterWritingVisitorWrapper(classBeingRedefined)).visit(this.mockTransformer).make().getBytes();
        }
        catch (Throwable throwable) {
            this.lastException = throwable;
            return null;
        }
    }

    @Override
    public synchronized void clearAllCaches() {
        HashSet types = new HashSet();
        this.mocked.forEach(types::add);
        if (types.isEmpty()) {
            return;
        }
        this.mocked.clear();
        this.flatMocked.clear();
        try {
            this.instrumentation.retransformClasses(types.toArray(new Class[0]));
        }
        catch (UnmodifiableClassException e) {
            throw new MockitoException(StringUtil.join("Failed to reset mocks.", "", "This should not influence the working of Mockito.", "But if the reset intends to remove mocking code to improve performance, it is still impacted."), e);
        }
    }

    private static class ParameterWritingVisitorWrapper
    extends AsmVisitorWrapper.AbstractBase {
        private final Class<?> type;

        private ParameterWritingVisitorWrapper(Class<?> type) {
            this.type = type;
        }

        @Override
        public ClassVisitor wrap(TypeDescription instrumentedType, ClassVisitor classVisitor, Implementation.Context implementationContext, TypePool typePool, FieldList<FieldDescription.InDefinedShape> fields, MethodList<?> methods, int writerFlags, int readerFlags) {
            return implementationContext.getClassFileVersion().isAtLeast(ClassFileVersion.JAVA_V8) ? new ParameterAddingClassVisitor(classVisitor, new TypeDescription.ForLoadedType(this.type)) : classVisitor;
        }

        private static class MethodParameterStrippingMethodVisitor
        extends MethodVisitor {
            public MethodParameterStrippingMethodVisitor(MethodVisitor mv) {
                super(OpenedClassReader.ASM_API, mv);
            }

            @Override
            public void visitParameter(String name, int access) {
            }
        }

        private static class ParameterAddingClassVisitor
        extends ClassVisitor {
            private final TypeDescription typeDescription;

            private ParameterAddingClassVisitor(ClassVisitor cv, TypeDescription typeDescription) {
                super(OpenedClassReader.ASM_API, cv);
                this.typeDescription = typeDescription;
            }

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor methodVisitor = super.visitMethod(access, name, desc, signature, exceptions);
                MethodList methodList = (MethodList)this.typeDescription.getDeclaredMethods().filter((name.equals("<init>") ? ElementMatchers.isConstructor() : ElementMatchers.named(name)).and(ElementMatchers.hasDescriptor(desc)));
                if (methodList.size() == 1 && ((MethodDescription)methodList.getOnly()).getParameters().hasExplicitMetaData()) {
                    for (ParameterDescription parameterDescription : ((MethodDescription)methodList.getOnly()).getParameters()) {
                        methodVisitor.visitParameter(parameterDescription.getName(), parameterDescription.getModifiers());
                    }
                    return new MethodParameterStrippingMethodVisitor(methodVisitor);
                }
                return methodVisitor;
            }
        }
    }
}

