/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.mockito.internal.configuration.injection.filter;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.shaded.org.mockito.internal.configuration.injection.filter.MockCandidateFilter;
import org.apache.hadoop.shaded.org.mockito.internal.configuration.injection.filter.OngoingInjector;
import org.apache.hadoop.shaded.org.mockito.internal.configuration.plugins.Plugins;
import org.apache.hadoop.shaded.org.mockito.internal.exceptions.Reporter;
import org.apache.hadoop.shaded.org.mockito.internal.util.reflection.BeanPropertySetter;
import org.apache.hadoop.shaded.org.mockito.plugins.MemberAccessor;

public class TerminalMockCandidateFilter
implements MockCandidateFilter {
    @Override
    public OngoingInjector filterCandidate(Collection<Object> mocks, Field candidateFieldToBeInjected, List<Field> allRemainingCandidateFields, Object injectee) {
        if (mocks.size() == 1) {
            Object matchingMock = mocks.iterator().next();
            MemberAccessor accessor = Plugins.getMemberAccessor();
            return () -> {
                try {
                    if (!new BeanPropertySetter(injectee, candidateFieldToBeInjected).set(matchingMock)) {
                        accessor.set(candidateFieldToBeInjected, injectee, matchingMock);
                    }
                }
                catch (IllegalAccessException | RuntimeException e) {
                    throw Reporter.cannotInjectDependency(candidateFieldToBeInjected, matchingMock, e);
                }
                return matchingMock;
            };
        }
        return OngoingInjector.nop;
    }
}

