/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.mockito.internal;

import org.apache.hadoop.shaded.org.mockito.MockedStatic;
import org.apache.hadoop.shaded.org.mockito.MockingDetails;
import org.apache.hadoop.shaded.org.mockito.Mockito;
import org.apache.hadoop.shaded.org.mockito.exceptions.base.MockitoAssertionError;
import org.apache.hadoop.shaded.org.mockito.exceptions.base.MockitoException;
import org.apache.hadoop.shaded.org.mockito.internal.debugging.LocationFactory;
import org.apache.hadoop.shaded.org.mockito.internal.exceptions.Reporter;
import org.apache.hadoop.shaded.org.mockito.internal.listeners.VerificationStartedNotifier;
import org.apache.hadoop.shaded.org.mockito.internal.progress.MockingProgress;
import org.apache.hadoop.shaded.org.mockito.internal.progress.ThreadSafeMockingProgress;
import org.apache.hadoop.shaded.org.mockito.internal.stubbing.InvocationContainerImpl;
import org.apache.hadoop.shaded.org.mockito.internal.util.MockUtil;
import org.apache.hadoop.shaded.org.mockito.internal.util.StringUtil;
import org.apache.hadoop.shaded.org.mockito.internal.verification.MockAwareVerificationMode;
import org.apache.hadoop.shaded.org.mockito.internal.verification.VerificationDataImpl;
import org.apache.hadoop.shaded.org.mockito.internal.verification.VerificationModeFactory;
import org.apache.hadoop.shaded.org.mockito.invocation.Location;
import org.apache.hadoop.shaded.org.mockito.invocation.MockHandler;
import org.apache.hadoop.shaded.org.mockito.plugins.MockMaker;
import org.apache.hadoop.shaded.org.mockito.stubbing.OngoingStubbing;
import org.apache.hadoop.shaded.org.mockito.verification.VerificationMode;

public final class MockedStaticImpl<T>
implements MockedStatic<T> {
    private final MockMaker.StaticMockControl<T> control;
    private boolean closed;
    private final Location location = LocationFactory.create();

    protected MockedStaticImpl(MockMaker.StaticMockControl<T> control) {
        this.control = control;
    }

    @Override
    public <S> OngoingStubbing<S> when(MockedStatic.Verification verification) {
        this.assertNotClosed();
        try {
            verification.apply();
        }
        catch (MockitoException exception) {
            throw exception;
        }
        catch (Throwable exception) {
            // empty catch block
        }
        MockingProgress mockingProgress = ThreadSafeMockingProgress.mockingProgress();
        mockingProgress.stubbingStarted();
        OngoingStubbing<?> stubbing = mockingProgress.pullOngoingStubbing();
        if (stubbing == null) {
            mockingProgress.reset();
            throw Reporter.missingMethodInvocation();
        }
        return stubbing;
    }

    @Override
    public void verify(MockedStatic.Verification verification, VerificationMode mode) {
        this.assertNotClosed();
        MockingDetails mockingDetails = Mockito.mockingDetails(this.control.getType());
        MockHandler handler = mockingDetails.getMockHandler();
        VerificationStartedNotifier.notifyVerificationStarted(handler.getMockSettings().getVerificationStartedListeners(), mockingDetails);
        MockingProgress mockingProgress = ThreadSafeMockingProgress.mockingProgress();
        VerificationMode actualMode = mockingProgress.maybeVerifyLazily(mode);
        mockingProgress.verificationStarted(new MockAwareVerificationMode(this.control.getType(), actualMode, mockingProgress.verificationListeners()));
        try {
            verification.apply();
        }
        catch (MockitoAssertionError | MockitoException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new MockitoException(StringUtil.join("An unexpected error occurred while verifying a static stub", "", "To correctly verify a stub, invoke a single static method of " + this.control.getType().getName() + " in the provided lambda.", "For example, if a method 'sample' was defined, provide a lambda or anonymous class containing the code", "", "() -> " + this.control.getType().getSimpleName() + ".sample()", "or", this.control.getType().getSimpleName() + "::sample"), t);
        }
    }

    @Override
    public void reset() {
        this.assertNotClosed();
        MockingProgress mockingProgress = ThreadSafeMockingProgress.mockingProgress();
        mockingProgress.validateState();
        mockingProgress.reset();
        mockingProgress.resetOngoingStubbing();
        MockUtil.resetMock(this.control.getType());
    }

    @Override
    public void clearInvocations() {
        this.assertNotClosed();
        MockingProgress mockingProgress = ThreadSafeMockingProgress.mockingProgress();
        mockingProgress.validateState();
        mockingProgress.reset();
        mockingProgress.resetOngoingStubbing();
        MockUtil.getInvocationContainer(this.control.getType()).clearInvocations();
    }

    @Override
    public void verifyNoMoreInteractions() {
        this.assertNotClosed();
        ThreadSafeMockingProgress.mockingProgress().validateState();
        InvocationContainerImpl invocations = MockUtil.getInvocationContainer(this.control.getType());
        VerificationDataImpl data = new VerificationDataImpl(invocations, null);
        VerificationModeFactory.noMoreInteractions().verify(data);
    }

    @Override
    public void verifyNoInteractions() {
        this.assertNotClosed();
        ThreadSafeMockingProgress.mockingProgress().validateState();
        InvocationContainerImpl invocations = MockUtil.getInvocationContainer(this.control.getType());
        VerificationDataImpl data = new VerificationDataImpl(invocations, null);
        VerificationModeFactory.noInteractions().verify(data);
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        this.assertNotClosed();
        this.closed = true;
        this.control.disable();
    }

    @Override
    public void closeOnDemand() {
        if (!this.closed) {
            this.close();
        }
    }

    private void assertNotClosed() {
        if (this.closed) {
            throw new MockitoException(StringUtil.join("The static mock created at", this.location.toString(), "is already resolved and cannot longer be used"));
        }
    }

    public String toString() {
        return "static mock for " + this.control.getType().getName();
    }
}

