/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.mockito.internal;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.shaded.org.mockito.InOrder;
import org.apache.hadoop.shaded.org.mockito.MockedStatic;
import org.apache.hadoop.shaded.org.mockito.MockingDetails;
import org.apache.hadoop.shaded.org.mockito.Mockito;
import org.apache.hadoop.shaded.org.mockito.exceptions.base.MockitoException;
import org.apache.hadoop.shaded.org.mockito.internal.MockitoCore;
import org.apache.hadoop.shaded.org.mockito.internal.exceptions.Reporter;
import org.apache.hadoop.shaded.org.mockito.internal.verification.InOrderContextImpl;
import org.apache.hadoop.shaded.org.mockito.internal.verification.InOrderWrapper;
import org.apache.hadoop.shaded.org.mockito.internal.verification.VerificationModeFactory;
import org.apache.hadoop.shaded.org.mockito.internal.verification.VerificationWrapper;
import org.apache.hadoop.shaded.org.mockito.internal.verification.VerificationWrapperInOrderWrapper;
import org.apache.hadoop.shaded.org.mockito.internal.verification.api.InOrderContext;
import org.apache.hadoop.shaded.org.mockito.internal.verification.api.VerificationInOrderMode;
import org.apache.hadoop.shaded.org.mockito.invocation.Invocation;
import org.apache.hadoop.shaded.org.mockito.verification.VerificationMode;

public class InOrderImpl
implements InOrder,
InOrderContext {
    private final MockitoCore mockitoCore = new MockitoCore();
    private final List<Object> mocksToBeVerifiedInOrder = new ArrayList<Object>();
    private final InOrderContext inOrderContext = new InOrderContextImpl();

    public List<Object> getMocksToBeVerifiedInOrder() {
        return this.mocksToBeVerifiedInOrder;
    }

    public InOrderImpl(List<?> mocksToBeVerifiedInOrder) {
        this.mocksToBeVerifiedInOrder.addAll(mocksToBeVerifiedInOrder);
    }

    @Override
    public <T> T verify(T mock) {
        return this.verify(mock, VerificationModeFactory.times(1));
    }

    @Override
    public <T> T verify(T mock, VerificationMode mode) {
        if (mock == null) {
            throw Reporter.nullPassedToVerify();
        }
        MockingDetails mockingDetails = Mockito.mockingDetails(mock);
        if (!mockingDetails.isMock()) {
            throw Reporter.notAMockPassedToVerify(mock.getClass());
        }
        if (!this.objectIsMockToBeVerified(mock)) {
            throw Reporter.inOrderRequiresFamiliarMock();
        }
        if (mode instanceof VerificationWrapper) {
            return this.mockitoCore.verify(mock, new VerificationWrapperInOrderWrapper((VerificationWrapper)mode, this));
        }
        if (!(mode instanceof VerificationInOrderMode)) {
            throw new MockitoException(mode.getClass().getSimpleName() + " is not implemented to work with InOrder");
        }
        return this.mockitoCore.verify(mock, new InOrderWrapper((VerificationInOrderMode)((Object)mode), this));
    }

    @Override
    public void verify(MockedStatic<?> mockedStatic, MockedStatic.Verification verification, VerificationMode mode) {
        if (mode instanceof VerificationWrapper) {
            mockedStatic.verify(verification, new VerificationWrapperInOrderWrapper((VerificationWrapper)mode, this));
        } else if (mode instanceof VerificationInOrderMode) {
            mockedStatic.verify(verification, new InOrderWrapper((VerificationInOrderMode)((Object)mode), this));
        } else {
            throw new MockitoException(mode.getClass().getSimpleName() + " is not implemented to work with InOrder");
        }
    }

    private boolean objectIsMockToBeVerified(Object mock) {
        for (Object inOrderMock : this.mocksToBeVerifiedInOrder) {
            if (inOrderMock != mock) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isVerified(Invocation i) {
        return this.inOrderContext.isVerified(i);
    }

    @Override
    public void markVerified(Invocation i) {
        this.inOrderContext.markVerified(i);
    }

    @Override
    public void verifyNoMoreInteractions() {
        this.mockitoCore.verifyNoMoreInteractionsInOrder(this.mocksToBeVerifiedInOrder, this);
    }
}

