/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.mockito.hamcrest;

import org.apache.hadoop.shaded.org.hamcrest.Matcher;
import org.apache.hadoop.shaded.org.mockito.internal.hamcrest.HamcrestArgumentMatcher;
import org.apache.hadoop.shaded.org.mockito.internal.hamcrest.MatcherGenericTypeExtractor;
import org.apache.hadoop.shaded.org.mockito.internal.progress.ThreadSafeMockingProgress;
import org.apache.hadoop.shaded.org.mockito.internal.util.Primitives;

public final class MockitoHamcrest {
    public static <T> T argThat(Matcher<T> matcher) {
        MockitoHamcrest.reportMatcher(matcher);
        return (T)Primitives.defaultValue(MatcherGenericTypeExtractor.genericTypeOfMatcher(matcher.getClass()));
    }

    public static char charThat(Matcher<Character> matcher) {
        MockitoHamcrest.reportMatcher(matcher);
        return '\u0000';
    }

    public static boolean booleanThat(Matcher<Boolean> matcher) {
        MockitoHamcrest.reportMatcher(matcher);
        return false;
    }

    public static byte byteThat(Matcher<Byte> matcher) {
        MockitoHamcrest.reportMatcher(matcher);
        return 0;
    }

    public static short shortThat(Matcher<Short> matcher) {
        MockitoHamcrest.reportMatcher(matcher);
        return 0;
    }

    public static int intThat(Matcher<Integer> matcher) {
        MockitoHamcrest.reportMatcher(matcher);
        return 0;
    }

    public static long longThat(Matcher<Long> matcher) {
        MockitoHamcrest.reportMatcher(matcher);
        return 0L;
    }

    public static float floatThat(Matcher<Float> matcher) {
        MockitoHamcrest.reportMatcher(matcher);
        return 0.0f;
    }

    public static double doubleThat(Matcher<Double> matcher) {
        MockitoHamcrest.reportMatcher(matcher);
        return 0.0;
    }

    private static <T> void reportMatcher(Matcher<T> matcher) {
        ThreadSafeMockingProgress.mockingProgress().getArgumentMatcherStorage().reportMatcher(new HamcrestArgumentMatcher<T>(matcher));
    }

    private MockitoHamcrest() {
    }
}

