/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.glassfish.jersey.test.jetty;

import java.net.URI;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hadoop.shaded.javax.ws.rs.core.UriBuilder;
import org.apache.hadoop.shaded.org.eclipse.jetty.server.Connector;
import org.apache.hadoop.shaded.org.eclipse.jetty.server.HttpConnectionFactory;
import org.apache.hadoop.shaded.org.eclipse.jetty.server.Server;
import org.apache.hadoop.shaded.org.eclipse.jetty.server.ServerConnector;
import org.apache.hadoop.shaded.org.glassfish.jersey.client.ClientConfig;
import org.apache.hadoop.shaded.org.glassfish.jersey.jetty.JettyHttpContainerFactory;
import org.apache.hadoop.shaded.org.glassfish.jersey.test.DeploymentContext;
import org.apache.hadoop.shaded.org.glassfish.jersey.test.spi.TestContainer;
import org.apache.hadoop.shaded.org.glassfish.jersey.test.spi.TestContainerException;
import org.apache.hadoop.shaded.org.glassfish.jersey.test.spi.TestContainerFactory;
import org.apache.hadoop.shaded.org.glassfish.jersey.test.spi.TestHelper;

public class JettyTestContainerFactory
implements TestContainerFactory {
    private final Map<String, Object> propertiesMap;

    public TestContainer create(URI baseUri, DeploymentContext context) throws IllegalArgumentException {
        return new JettyTestContainer(baseUri, context, this.propertiesMap);
    }

    public JettyTestContainerFactory() {
        this(null);
    }

    public JettyTestContainerFactory(Map<String, Object> properties) {
        this.propertiesMap = properties;
    }

    private static class JettyTestContainer
    implements TestContainer {
        private static final Logger LOGGER = Logger.getLogger(JettyTestContainer.class.getName());
        private final Map<String, Object> propertiesMap;
        private URI baseUri;
        private final Server server;

        private JettyTestContainer(URI baseUri, DeploymentContext context, Map<String, Object> propertiesMap) {
            URI base = UriBuilder.fromUri((URI)baseUri).path(context.getContextPath()).build(new Object[0]);
            this.propertiesMap = propertiesMap;
            if (!"/".equals(base.getRawPath())) {
                throw new TestContainerException(String.format("Cannot deploy on %s. Jetty HTTP container only supports deployment on root path.", base.getRawPath()));
            }
            this.baseUri = base;
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Creating JettyTestContainer configured at the base URI " + TestHelper.zeroPortToAvailablePort((URI)baseUri));
            }
            this.server = JettyHttpContainerFactory.createServer(this.baseUri, context.getResourceConfig(), false);
        }

        public void configureContainer() {
            if (this.propertiesMap == null || !this.propertiesMap.containsKey("org.apache.hadoop.shaded.jersey.test.jetty.container.header.size")) {
                return;
            }
            for (Connector c : this.server.getConnectors()) {
                c.getConnectionFactory(HttpConnectionFactory.class).getHttpConfiguration().setRequestHeaderSize((Integer)this.propertiesMap.get("org.apache.hadoop.shaded.jersey.test.jetty.container.header.size"));
                c.getConnectionFactory(HttpConnectionFactory.class).getHttpConfiguration().setResponseHeaderSize((Integer)this.propertiesMap.get("org.apache.hadoop.shaded.jersey.test.jetty.container.header.size"));
                c.getConnectionFactory(HttpConnectionFactory.class);
            }
        }

        public ClientConfig getClientConfig() {
            return null;
        }

        public URI getBaseUri() {
            return this.baseUri;
        }

        public void start() {
            if (this.server.isStarted()) {
                LOGGER.log(Level.WARNING, "Ignoring start request - JettyTestContainer is already started.");
            } else {
                LOGGER.log(Level.FINE, "Starting JettyTestContainer...");
                try {
                    this.server.start();
                    if (this.baseUri.getPort() == 0) {
                        int port = 0;
                        for (Connector connector : this.server.getConnectors()) {
                            if (!(connector instanceof ServerConnector)) continue;
                            port = ((ServerConnector)connector).getLocalPort();
                            break;
                        }
                        this.baseUri = UriBuilder.fromUri((URI)this.baseUri).port(port).build(new Object[0]);
                        LOGGER.log(Level.INFO, "Started JettyTestContainer at the base URI " + this.baseUri);
                    }
                }
                catch (Exception e) {
                    throw new TestContainerException((Throwable)e);
                }
            }
        }

        public void stop() {
            if (this.server.isStarted()) {
                LOGGER.log(Level.FINE, "Stopping JettyTestContainer...");
                try {
                    this.server.stop();
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, "Error Stopping JettyTestContainer...", ex);
                }
            } else {
                LOGGER.log(Level.WARNING, "Ignoring stop request - JettyTestContainer is already stopped.");
            }
        }
    }
}

