/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.glassfish.jersey.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.shaded.javax.servlet.DispatcherType;
import org.apache.hadoop.shaded.javax.servlet.Filter;
import org.apache.hadoop.shaded.javax.servlet.ServletContextAttributeListener;
import org.apache.hadoop.shaded.javax.servlet.ServletContextListener;
import org.apache.hadoop.shaded.javax.servlet.ServletRequestAttributeListener;
import org.apache.hadoop.shaded.javax.servlet.ServletRequestListener;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServlet;
import org.apache.hadoop.shaded.javax.servlet.http.HttpSessionActivationListener;
import org.apache.hadoop.shaded.javax.servlet.http.HttpSessionAttributeListener;
import org.apache.hadoop.shaded.javax.servlet.http.HttpSessionListener;
import org.apache.hadoop.shaded.javax.ws.rs.core.Application;
import org.apache.hadoop.shaded.org.glassfish.jersey.servlet.ServletContainer;
import org.apache.hadoop.shaded.org.glassfish.jersey.test.DeploymentContext;

public class ServletDeploymentContext
extends DeploymentContext {
    private final Map<String, String> initParams;
    private final Map<String, String> contextParams;
    private final Class<? extends HttpServlet> servletClass;
    private final HttpServlet servletInstance;
    private final List<FilterDescriptor> filters;
    private final List<Class<? extends EventListener>> listeners;
    private final String servletPath;

    public static Builder builder(Application application) {
        return new Builder(application);
    }

    public static Builder builder(Class<? extends Application> applicationClass) {
        return new Builder(applicationClass);
    }

    public static Builder builder(Map<String, String> initParams) {
        return new Builder().initParams(initParams);
    }

    public static Builder forServlet(HttpServlet servlet) {
        return new Builder().servlet(servlet);
    }

    public static Builder forServlet(Class<? extends HttpServlet> servletClass) {
        return new Builder().servletClass(servletClass);
    }

    public static Builder forPackages(String packages) {
        return new Builder().initParam("org.apache.hadoop.shaded.jersey.config.server.provider.packages", packages);
    }

    public static ServletDeploymentContext newInstance(Application application) {
        return new Builder(application).build();
    }

    public static ServletDeploymentContext newInstance(Class<? extends Application> applicationClass) {
        return new Builder(applicationClass).build();
    }

    public static Builder newInstance(String packages) {
        return new Builder().initParam("org.apache.hadoop.shaded.jersey.config.server.provider.packages", packages);
    }

    protected ServletDeploymentContext(Builder b) {
        super(b);
        this.initParams = b.initParams == null ? Collections.emptyMap() : b.initParams;
        this.contextParams = b.contextParams == null ? Collections.emptyMap() : b.contextParams;
        this.servletClass = b.servletClass;
        this.servletInstance = b.servletInstance;
        this.filters = b.filters;
        this.servletPath = b.servletPath;
        this.listeners = b.listeners == null ? Collections.emptyList() : Collections.unmodifiableList(b.listeners);
    }

    public Map<String, String> getInitParams() {
        return this.initParams;
    }

    public Map<String, String> getContextParams() {
        return this.contextParams;
    }

    public Class<? extends HttpServlet> getServletClass() {
        return this.servletClass;
    }

    public HttpServlet getServletInstance() {
        return this.servletInstance;
    }

    public List<FilterDescriptor> getFilters() {
        return this.filters;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public List<Class<? extends EventListener>> getListeners() {
        return this.listeners;
    }

    public static class FilterDescriptor {
        private final String filterName;
        private final Class<? extends Filter> filterClass;
        private final Map<String, String> initParams;
        private final Set<DispatcherType> dispatcherTypes;

        private FilterDescriptor(String filterName, Class<? extends Filter> filterClass, Map<String, String> initParams, Set<DispatcherType> dispatcherTypes) {
            this.filterName = filterName;
            this.filterClass = filterClass;
            this.initParams = initParams;
            this.dispatcherTypes = dispatcherTypes;
        }

        public Class<? extends Filter> getFilterClass() {
            return this.filterClass;
        }

        public String getFilterName() {
            return this.filterName;
        }

        public Map<String, String> getInitParams() {
            return this.initParams;
        }

        public Set<DispatcherType> getDispatcherTypes() {
            return this.dispatcherTypes;
        }
    }

    public static class Builder
    extends DeploymentContext.Builder {
        private static final EnumSet<DispatcherType> DEFAULT_DISPATCHER_TYPES = EnumSet.of(DispatcherType.REQUEST);
        private Map<String, String> initParams;
        private Map<String, String> contextParams;
        private Class<? extends HttpServlet> servletClass = ServletContainer.class;
        private HttpServlet servletInstance;
        private List<FilterDescriptor> filters;
        private List<Class<? extends EventListener>> listeners;
        private String servletPath = "";

        protected Builder() {
        }

        public Builder(String name, String value) {
            this.initParam(name, value);
        }

        protected Builder(Application app) {
            super(app);
        }

        protected Builder(Class<? extends Application> appClass) {
            super(appClass);
        }

        public Builder initParam(String name, String value) {
            if (this.initParams == null) {
                this.initParams = new HashMap<String, String>();
            }
            this.initParams.put(name, value);
            return this;
        }

        public Builder initParams(Map<String, String> initParams) {
            if (this.initParams == null) {
                this.initParams = new HashMap<String, String>();
            }
            this.initParams.putAll(initParams);
            return this;
        }

        public Builder contextParam(String name, String value) {
            if (this.contextParams == null) {
                this.contextParams = new HashMap<String, String>();
            }
            this.contextParams.put(name, value);
            return this;
        }

        public Builder contextParams(Map<String, String> contextParams) {
            if (this.contextParams == null) {
                this.contextParams = new HashMap<String, String>();
            }
            this.contextParams.putAll(contextParams);
            return this;
        }

        public Builder servletClass(Class<? extends HttpServlet> servletClass) {
            if (servletClass == null) {
                throw new NullPointerException("The servlet class must not be null");
            }
            this.filters = null;
            this.servletInstance = null;
            this.servletClass = servletClass;
            return this;
        }

        public Builder servlet(HttpServlet servlet) {
            if (this.servletClass == null) {
                throw new NullPointerException("The servlet class must not be null");
            }
            this.filters = null;
            this.servletClass = null;
            this.servletInstance = servlet;
            return this;
        }

        public Builder filterClass(Class<? extends Filter> filterClass) {
            return this.filterClass(filterClass, DEFAULT_DISPATCHER_TYPES);
        }

        public Builder filterClass(Class<? extends Filter> filterClass, Set<DispatcherType> dispatcherTypes) {
            if (filterClass == null) {
                throw new NullPointerException("The filter class must not be null.");
            }
            this.servletClass = null;
            this.servletInstance = null;
            return this.addFilter(filterClass, "jerseyfilter", Collections.emptyMap(), dispatcherTypes);
        }

        public Builder addFilter(Class<? extends Filter> filterClass, String filterName) {
            return this.addFilter(filterClass, filterName, Collections.emptyMap());
        }

        public Builder addFilter(Class<? extends Filter> filterClass, String filterName, Map<String, String> initParams) {
            return this.addFilter(filterClass, filterName, initParams, DEFAULT_DISPATCHER_TYPES);
        }

        public Builder addFilter(Class<? extends Filter> filterClass, String filterName, Set<DispatcherType> dispatcherTypes) {
            return this.addFilter(filterClass, filterName, Collections.emptyMap(), dispatcherTypes);
        }

        public Builder addFilter(Class<? extends Filter> filterClass, String filterName, Map<String, String> initParams, Set<DispatcherType> dispatcherTypes) {
            if (this.filters == null) {
                this.filters = new ArrayList<FilterDescriptor>();
            }
            LinkedList<String> nulls = new LinkedList<String>();
            LinkedList<String> empties = new LinkedList<String>();
            if (filterClass == null) {
                nulls.add("filter class");
            }
            if (filterName == null) {
                nulls.add("filter name");
            } else if (filterName.isEmpty()) {
                empties.add("filter name");
            }
            if (initParams == null) {
                nulls.add("init parameters");
            }
            if (dispatcherTypes == null) {
                nulls.add("dispatcher types");
            } else if (dispatcherTypes.isEmpty()) {
                empties.add("dispatcher types");
            }
            if (!nulls.isEmpty()) {
                throw new NullPointerException(String.format("The %s must not be null.", nulls.toString()));
            }
            if (!empties.isEmpty()) {
                throw new IllegalArgumentException(String.format("The %s must not be empty.", empties.toString()));
            }
            this.filters.add(new FilterDescriptor(filterName, filterClass, initParams, dispatcherTypes));
            return this;
        }

        @Override
        public Builder contextPath(String contextPath) {
            super.contextPath(contextPath);
            return this;
        }

        public Builder servletPath(String servletPath) {
            if (servletPath == null) {
                throw new NullPointerException("The servlet path must not be null.");
            }
            this.servletPath = servletPath;
            return this;
        }

        public Builder addListener(Class<? extends EventListener> listenerClass) {
            if (listenerClass == null) {
                throw new NullPointerException("The servlet context listener class must not be null");
            }
            if (!(ServletContextListener.class.isAssignableFrom(listenerClass) || ServletContextAttributeListener.class.isAssignableFrom(listenerClass) || ServletRequestListener.class.isAssignableFrom(listenerClass) || ServletRequestAttributeListener.class.isAssignableFrom(listenerClass) || HttpSessionListener.class.isAssignableFrom(listenerClass) || HttpSessionActivationListener.class.isAssignableFrom(listenerClass) || HttpSessionAttributeListener.class.isAssignableFrom(listenerClass))) {
                throw new IllegalArgumentException("Unsupported event listener type.");
            }
            if (this.listeners == null) {
                this.listeners = new ArrayList<Class<? extends EventListener>>();
            }
            this.listeners.add(listenerClass);
            return this;
        }

        @Override
        public ServletDeploymentContext build() {
            ServletDeploymentContext wd = new ServletDeploymentContext(this);
            this.reset();
            return wd;
        }

        @Override
        protected void reset() {
            super.reset();
            this.initParams = null;
            this.contextParams = null;
            this.servletInstance = null;
            this.servletClass = ServletContainer.class;
            this.filters = null;
            this.listeners = null;
            this.servletPath = "";
        }
    }
}

