/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.glassfish.jersey.server.wadl.internal.generators;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParserFactory;
import org.apache.hadoop.shaded.com.sun.research.ws.wadl.Application;
import org.apache.hadoop.shaded.com.sun.research.ws.wadl.Grammars;
import org.apache.hadoop.shaded.com.sun.research.ws.wadl.Method;
import org.apache.hadoop.shaded.com.sun.research.ws.wadl.Param;
import org.apache.hadoop.shaded.com.sun.research.ws.wadl.Representation;
import org.apache.hadoop.shaded.com.sun.research.ws.wadl.Request;
import org.apache.hadoop.shaded.com.sun.research.ws.wadl.Resource;
import org.apache.hadoop.shaded.com.sun.research.ws.wadl.Resources;
import org.apache.hadoop.shaded.com.sun.research.ws.wadl.Response;
import org.apache.hadoop.shaded.javax.inject.Provider;
import org.apache.hadoop.shaded.javax.ws.rs.core.Context;
import org.apache.hadoop.shaded.javax.ws.rs.core.MediaType;
import org.apache.hadoop.shaded.org.glassfish.jersey.server.model.Parameter;
import org.apache.hadoop.shaded.org.glassfish.jersey.server.model.ResourceMethod;
import org.apache.hadoop.shaded.org.glassfish.jersey.server.wadl.WadlGenerator;
import org.apache.hadoop.shaded.org.glassfish.jersey.server.wadl.internal.ApplicationDescription;
import org.apache.hadoop.shaded.org.glassfish.jersey.server.wadl.internal.WadlUtils;

public class WadlGeneratorGrammarsSupport
implements WadlGenerator {
    private static final Logger LOG = Logger.getLogger(WadlGeneratorGrammarsSupport.class.getName());
    private WadlGenerator _delegate;
    private File _grammarsFile;
    private InputStream _grammarsStream;
    private Grammars _grammars;
    private Boolean overrideGrammars = false;
    @Context
    private Provider<SAXParserFactory> saxFactoryProvider;

    public WadlGeneratorGrammarsSupport() {
    }

    public WadlGeneratorGrammarsSupport(WadlGenerator delegate, Grammars grammars) {
        this._delegate = delegate;
        this._grammars = grammars;
    }

    @Override
    public void setWadlGeneratorDelegate(WadlGenerator delegate) {
        this._delegate = delegate;
    }

    public void setOverrideGrammars(Boolean overrideGrammars) {
        this.overrideGrammars = overrideGrammars;
    }

    @Override
    public String getRequiredJaxbContextPath() {
        return this._delegate.getRequiredJaxbContextPath();
    }

    public void setGrammarsFile(File grammarsFile) {
        if (this._grammarsStream != null) {
            throw new IllegalStateException("The grammarsStream property is already set, therefore you cannot set the grammarsFile property. Only one of both can be set at a time.");
        }
        this._grammarsFile = grammarsFile;
    }

    public void setGrammarsStream(InputStream grammarsStream) {
        if (this._grammarsFile != null) {
            throw new IllegalStateException("The grammarsFile property is already set, therefore you cannot set the grammarsStream property. Only one of both can be set at a time.");
        }
        this._grammarsStream = grammarsStream;
    }

    @Override
    public void init() throws Exception {
        if (this._grammarsFile == null && this._grammarsStream == null) {
            throw new IllegalStateException("Neither the grammarsFile nor the grammarsStream is set, one of both is required.");
        }
        this._delegate.init();
        this._grammars = WadlUtils.unmarshall(this._grammarsFile != null ? Files.newInputStream(this._grammarsFile.toPath(), new OpenOption[0]) : this._grammarsStream, this.saxFactoryProvider.get(), Grammars.class);
    }

    @Override
    public Application createApplication() {
        Application result = this._delegate.createApplication();
        if (result.getGrammars() != null && !this.overrideGrammars.booleanValue()) {
            LOG.info("The wadl application created by the delegate (" + this._delegate + ") already contains a grammars element, we're adding elements of the provided grammars file.");
            if (!this._grammars.getAny().isEmpty()) {
                result.getGrammars().getAny().addAll(this._grammars.getAny());
            }
            if (!this._grammars.getDoc().isEmpty()) {
                result.getGrammars().getDoc().addAll(this._grammars.getDoc());
            }
            if (!this._grammars.getInclude().isEmpty()) {
                result.getGrammars().getInclude().addAll(this._grammars.getInclude());
            }
        } else {
            result.setGrammars(this._grammars);
        }
        return result;
    }

    @Override
    public Method createMethod(org.apache.hadoop.shaded.org.glassfish.jersey.server.model.Resource ar, ResourceMethod arm) {
        return this._delegate.createMethod(ar, arm);
    }

    @Override
    public Request createRequest(org.apache.hadoop.shaded.org.glassfish.jersey.server.model.Resource ar, ResourceMethod arm) {
        return this._delegate.createRequest(ar, arm);
    }

    @Override
    public Param createParam(org.apache.hadoop.shaded.org.glassfish.jersey.server.model.Resource ar, ResourceMethod am, Parameter p) {
        return this._delegate.createParam(ar, am, p);
    }

    @Override
    public Representation createRequestRepresentation(org.apache.hadoop.shaded.org.glassfish.jersey.server.model.Resource ar, ResourceMethod arm, MediaType mt) {
        return this._delegate.createRequestRepresentation(ar, arm, mt);
    }

    @Override
    public Resource createResource(org.apache.hadoop.shaded.org.glassfish.jersey.server.model.Resource ar, String path) {
        return this._delegate.createResource(ar, path);
    }

    @Override
    public Resources createResources() {
        return this._delegate.createResources();
    }

    @Override
    public List<Response> createResponses(org.apache.hadoop.shaded.org.glassfish.jersey.server.model.Resource ar, ResourceMethod arm) {
        return this._delegate.createResponses(ar, arm);
    }

    @Override
    public WadlGenerator.ExternalGrammarDefinition createExternalGrammar() {
        if (this.overrideGrammars.booleanValue()) {
            return new WadlGenerator.ExternalGrammarDefinition();
        }
        return this._delegate.createExternalGrammar();
    }

    @Override
    public void attachTypes(ApplicationDescription egd) {
        this._delegate.attachTypes(egd);
    }
}

