/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.glassfish.jersey.server.wadl.internal.generators;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import javax.xml.parsers.SAXParserFactory;
import org.apache.hadoop.shaded.com.sun.research.ws.wadl.Application;
import org.apache.hadoop.shaded.com.sun.research.ws.wadl.Method;
import org.apache.hadoop.shaded.com.sun.research.ws.wadl.Param;
import org.apache.hadoop.shaded.com.sun.research.ws.wadl.Representation;
import org.apache.hadoop.shaded.com.sun.research.ws.wadl.Request;
import org.apache.hadoop.shaded.com.sun.research.ws.wadl.Resource;
import org.apache.hadoop.shaded.com.sun.research.ws.wadl.Resources;
import org.apache.hadoop.shaded.com.sun.research.ws.wadl.Response;
import org.apache.hadoop.shaded.javax.inject.Provider;
import org.apache.hadoop.shaded.javax.ws.rs.core.Context;
import org.apache.hadoop.shaded.javax.ws.rs.core.MediaType;
import org.apache.hadoop.shaded.org.glassfish.jersey.server.model.Parameter;
import org.apache.hadoop.shaded.org.glassfish.jersey.server.model.ResourceMethod;
import org.apache.hadoop.shaded.org.glassfish.jersey.server.wadl.WadlGenerator;
import org.apache.hadoop.shaded.org.glassfish.jersey.server.wadl.internal.ApplicationDescription;
import org.apache.hadoop.shaded.org.glassfish.jersey.server.wadl.internal.WadlUtils;
import org.apache.hadoop.shaded.org.glassfish.jersey.server.wadl.internal.generators.ApplicationDocs;

public class WadlGeneratorApplicationDoc
implements WadlGenerator {
    private WadlGenerator _delegate;
    private File _applicationDocsFile;
    private InputStream _applicationDocsStream;
    private ApplicationDocs _applicationDocs;
    @Context
    private Provider<SAXParserFactory> saxFactoryProvider;

    @Override
    public void setWadlGeneratorDelegate(WadlGenerator delegate) {
        this._delegate = delegate;
    }

    @Override
    public String getRequiredJaxbContextPath() {
        return this._delegate.getRequiredJaxbContextPath();
    }

    public void setApplicationDocsFile(File applicationDocsFile) {
        if (this._applicationDocsStream != null) {
            throw new IllegalStateException("The applicationDocsStream property is already set, therefore you cannot set the applicationDocsFile property. Only one of both can be set at a time.");
        }
        this._applicationDocsFile = applicationDocsFile;
    }

    public void setApplicationDocsStream(InputStream applicationDocsStream) {
        if (this._applicationDocsFile != null) {
            throw new IllegalStateException("The applicationDocsFile property is already set, therefore you cannot set the applicationDocsStream property. Only one of both can be set at a time.");
        }
        this._applicationDocsStream = applicationDocsStream;
    }

    @Override
    public void init() throws Exception {
        if (this._applicationDocsFile == null && this._applicationDocsStream == null) {
            throw new IllegalStateException("Neither the applicationDocsFile nor the applicationDocsStream is set, one of both is required.");
        }
        this._delegate.init();
        InputStream inputStream = this._applicationDocsFile != null ? Files.newInputStream(this._applicationDocsFile.toPath(), new OpenOption[0]) : this._applicationDocsStream;
        this._applicationDocs = WadlUtils.unmarshall(inputStream, this.saxFactoryProvider.get(), ApplicationDocs.class);
    }

    @Override
    public Application createApplication() {
        Application result = this._delegate.createApplication();
        if (this._applicationDocs != null && this._applicationDocs.getDocs() != null && !this._applicationDocs.getDocs().isEmpty()) {
            result.getDoc().addAll(this._applicationDocs.getDocs());
        }
        return result;
    }

    @Override
    public Method createMethod(org.apache.hadoop.shaded.org.glassfish.jersey.server.model.Resource r, ResourceMethod m) {
        return this._delegate.createMethod(r, m);
    }

    @Override
    public Representation createRequestRepresentation(org.apache.hadoop.shaded.org.glassfish.jersey.server.model.Resource r, ResourceMethod m, MediaType mediaType) {
        return this._delegate.createRequestRepresentation(r, m, mediaType);
    }

    @Override
    public Request createRequest(org.apache.hadoop.shaded.org.glassfish.jersey.server.model.Resource r, ResourceMethod m) {
        return this._delegate.createRequest(r, m);
    }

    @Override
    public Param createParam(org.apache.hadoop.shaded.org.glassfish.jersey.server.model.Resource r, ResourceMethod m, Parameter p) {
        return this._delegate.createParam(r, m, p);
    }

    @Override
    public Resource createResource(org.apache.hadoop.shaded.org.glassfish.jersey.server.model.Resource r, String path) {
        return this._delegate.createResource(r, path);
    }

    @Override
    public List<Response> createResponses(org.apache.hadoop.shaded.org.glassfish.jersey.server.model.Resource r, ResourceMethod m) {
        return this._delegate.createResponses(r, m);
    }

    @Override
    public Resources createResources() {
        return this._delegate.createResources();
    }

    @Override
    public WadlGenerator.ExternalGrammarDefinition createExternalGrammar() {
        return this._delegate.createExternalGrammar();
    }

    @Override
    public void attachTypes(ApplicationDescription egd) {
        this._delegate.attachTypes(egd);
    }
}

