/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.glassfish.jersey.server.internal.inject;

import java.util.function.Function;
import org.apache.hadoop.shaded.javax.inject.Provider;
import org.apache.hadoop.shaded.javax.inject.Singleton;
import org.apache.hadoop.shaded.org.glassfish.jersey.internal.inject.ExtractorException;
import org.apache.hadoop.shaded.org.glassfish.jersey.model.Parameter;
import org.apache.hadoop.shaded.org.glassfish.jersey.server.ContainerRequest;
import org.apache.hadoop.shaded.org.glassfish.jersey.server.ParamException;
import org.apache.hadoop.shaded.org.glassfish.jersey.server.internal.inject.AbstractValueParamProvider;
import org.apache.hadoop.shaded.org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractor;
import org.apache.hadoop.shaded.org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.apache.hadoop.shaded.org.glassfish.jersey.server.model.Parameter;

@Singleton
final class HeaderParamValueParamProvider
extends AbstractValueParamProvider {
    public HeaderParamValueParamProvider(Provider<MultivaluedParameterExtractorProvider> mpep) {
        super(mpep, Parameter.Source.HEADER);
    }

    @Override
    public Function<ContainerRequest, ?> createValueProvider(Parameter parameter) {
        String parameterName = parameter.getSourceName();
        if (parameterName == null || parameterName.length() == 0) {
            return null;
        }
        MultivaluedParameterExtractor<?> e = this.get(parameter);
        if (e == null) {
            return null;
        }
        return new HeaderParamValueProvider(e);
    }

    private static final class HeaderParamValueProvider
    implements Function<ContainerRequest, Object> {
        private final MultivaluedParameterExtractor<?> extractor;

        HeaderParamValueProvider(MultivaluedParameterExtractor<?> extractor) {
            this.extractor = extractor;
        }

        @Override
        public Object apply(ContainerRequest containerRequest) {
            try {
                return this.extractor.extract(containerRequest.getHeaders());
            }
            catch (ExtractorException e) {
                throw new ParamException.HeaderParamException(e.getCause(), this.extractor.getName(), this.extractor.getDefaultValueString());
            }
        }
    }
}

