/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.glassfish.jersey.message.internal;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.apache.hadoop.shaded.javax.inject.Singleton;
import org.apache.hadoop.shaded.javax.ws.rs.Consumes;
import org.apache.hadoop.shaded.javax.ws.rs.Produces;
import org.apache.hadoop.shaded.javax.ws.rs.core.MediaType;
import org.apache.hadoop.shaded.javax.ws.rs.core.MultivaluedMap;
import org.apache.hadoop.shaded.org.glassfish.jersey.message.MessageUtils;
import org.apache.hadoop.shaded.org.glassfish.jersey.message.internal.AbstractMessageReaderWriterProvider;
import org.apache.hadoop.shaded.org.glassfish.jersey.message.internal.EntityInputStream;
import org.apache.hadoop.shaded.org.glassfish.jersey.message.internal.ReaderWriter;

@Produces(value={"text/plain", "*/*"})
@Consumes(value={"text/plain", "*/*"})
@Singleton
public final class ReaderProvider
extends AbstractMessageReaderWriterProvider<Reader> {
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Reader.class == type;
    }

    public Reader readFrom(Class<Reader> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream inputStream) throws IOException {
        EntityInputStream entityStream = EntityInputStream.create(inputStream);
        if (entityStream.isEmpty()) {
            return new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(new byte[0]), MessageUtils.getCharset(mediaType)));
        }
        return new BufferedReader(new InputStreamReader((InputStream)entityStream, ReaderWriter.getCharset(mediaType)));
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Reader.class.isAssignableFrom(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(Reader t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        try {
            OutputStreamWriter out = new OutputStreamWriter(entityStream, ReaderWriter.getCharset(mediaType));
            ReaderWriter.writeTo(t, out);
            out.flush();
        }
        finally {
            t.close();
        }
    }
}

