/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.glassfish.jersey.logging;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.shaded.javax.websocket.Priority;
import org.apache.hadoop.shaded.javax.ws.rs.ConstrainedTo;
import org.apache.hadoop.shaded.javax.ws.rs.RuntimeType;
import org.apache.hadoop.shaded.javax.ws.rs.container.ContainerRequestContext;
import org.apache.hadoop.shaded.javax.ws.rs.container.ContainerRequestFilter;
import org.apache.hadoop.shaded.javax.ws.rs.container.ContainerResponseContext;
import org.apache.hadoop.shaded.javax.ws.rs.container.ContainerResponseFilter;
import org.apache.hadoop.shaded.javax.ws.rs.container.PreMatching;
import org.apache.hadoop.shaded.javax.ws.rs.core.MultivaluedMap;
import org.apache.hadoop.shaded.org.glassfish.jersey.logging.LoggingFeature;
import org.apache.hadoop.shaded.org.glassfish.jersey.logging.LoggingInterceptor;
import org.apache.hadoop.shaded.org.glassfish.jersey.message.MessageUtils;

@ConstrainedTo(value=RuntimeType.SERVER)
@PreMatching
@Priority(value=-2147483648)
final class ServerLoggingFilter
extends LoggingInterceptor
implements ContainerRequestFilter,
ContainerResponseFilter {
    public ServerLoggingFilter(LoggingFeature.LoggingFeatureBuilder builder) {
        super(builder);
    }

    public void filter(ContainerRequestContext context) throws IOException {
        if (!this.logger.isLoggable(this.level)) {
            return;
        }
        long id = this._id.incrementAndGet();
        context.setProperty(LOGGING_ID_PROPERTY, (Object)id);
        StringBuilder b = new StringBuilder();
        this.printRequestLine(b, "Server has received a request", id, context.getMethod(), context.getUriInfo().getRequestUri());
        this.printPrefixedHeaders(b, id, "> ", (MultivaluedMap<String, String>)context.getHeaders());
        if (ServerLoggingFilter.printEntity(this.verbosity, context.getMediaType()) && context.hasEntity()) {
            context.setEntityStream(this.logInboundEntity(b, context.getEntityStream(), MessageUtils.getCharset(context.getMediaType())));
        }
        this.log(b);
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        if (!this.logger.isLoggable(this.level)) {
            return;
        }
        Object requestId = requestContext.getProperty(LOGGING_ID_PROPERTY);
        long id = requestId != null ? ((Long)requestId).longValue() : this._id.incrementAndGet();
        StringBuilder b = new StringBuilder();
        this.printResponseLine(b, "Server responded with a response", id, responseContext.getStatus());
        this.printPrefixedHeaders(b, id, "< ", (MultivaluedMap<String, String>)responseContext.getStringHeaders());
        if (ServerLoggingFilter.printEntity(this.verbosity, responseContext.getMediaType()) && responseContext.hasEntity()) {
            LoggingInterceptor.LoggingStream stream = new LoggingInterceptor.LoggingStream(b, responseContext.getEntityStream());
            responseContext.setEntityStream((OutputStream)stream);
            requestContext.setProperty(ENTITY_LOGGER_PROPERTY, (Object)stream);
        } else {
            this.log(b);
        }
    }
}

