/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.glassfish.jersey.jettison.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.hadoop.shaded.org.codehaus.jettison.badgerfish.BadgerFishXMLStreamReader;
import org.apache.hadoop.shaded.org.codehaus.jettison.badgerfish.BadgerFishXMLStreamWriter;
import org.apache.hadoop.shaded.org.codehaus.jettison.json.JSONObject;
import org.apache.hadoop.shaded.org.codehaus.jettison.json.JSONTokener;
import org.apache.hadoop.shaded.org.codehaus.jettison.mapped.Configuration;
import org.apache.hadoop.shaded.org.codehaus.jettison.mapped.MappedNamespaceConvention;
import org.apache.hadoop.shaded.org.codehaus.jettison.mapped.MappedXMLStreamReader;
import org.apache.hadoop.shaded.org.codehaus.jettison.mapped.MappedXMLStreamWriter;
import org.apache.hadoop.shaded.org.glassfish.jersey.jettison.JettisonConfig;
import org.apache.hadoop.shaded.org.glassfish.jersey.message.internal.ReaderWriter;

public class Stax2JettisonFactory {
    private Stax2JettisonFactory() {
    }

    public static XMLStreamWriter createWriter(Writer writer, JettisonConfig config) throws IOException {
        switch (config.getNotation()) {
            case BADGERFISH: {
                return new BadgerFishXMLStreamWriter(writer);
            }
            case MAPPED_JETTISON: {
                Configuration jmConfig = null == config.getXml2JsonNs() ? new Configuration() : new Configuration(config.getXml2JsonNs());
                MappedXMLStreamWriter result = new MappedXMLStreamWriter(new MappedNamespaceConvention(jmConfig), writer);
                for (String array : config.getArrayElements()) {
                    result.serializeAsArray(array);
                }
                return result;
            }
        }
        return null;
    }

    public static XMLStreamReader createReader(Reader reader, JettisonConfig config) throws XMLStreamException {
        Reader nonEmptyReader = Stax2JettisonFactory.ensureNonEmptyReader(reader);
        switch (config.getNotation()) {
            case MAPPED_JETTISON: {
                try {
                    Configuration jmConfig = null == config.getXml2JsonNs() ? new Configuration() : new Configuration(config.getXml2JsonNs());
                    return new MappedXMLStreamReader(new JSONObject(new JSONTokener(ReaderWriter.readFromAsString(nonEmptyReader))), new MappedNamespaceConvention(jmConfig));
                }
                catch (Exception ex) {
                    throw new XMLStreamException(ex);
                }
            }
            case BADGERFISH: {
                try {
                    return new BadgerFishXMLStreamReader(new JSONObject(new JSONTokener(ReaderWriter.readFromAsString(nonEmptyReader))));
                }
                catch (Exception ex) {
                    throw new XMLStreamException(ex);
                }
            }
        }
        throw new IllegalArgumentException("Unknown JSON config");
    }

    private static Reader ensureNonEmptyReader(Reader reader) throws XMLStreamException {
        try {
            Reader mr = reader.markSupported() ? reader : new BufferedReader(reader);
            mr.mark(1);
            if (mr.read() == -1) {
                throw new XMLStreamException("JSON expression can not be empty!");
            }
            mr.reset();
            return mr;
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }
}

