/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.glassfish.jersey.jaxb.internal;

import java.io.InputStream;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.sax.SAXSource;
import org.apache.hadoop.shaded.javax.inject.Inject;
import org.apache.hadoop.shaded.javax.inject.Provider;
import org.apache.hadoop.shaded.javax.inject.Singleton;
import org.apache.hadoop.shaded.javax.ws.rs.Consumes;
import org.apache.hadoop.shaded.javax.ws.rs.Produces;
import org.apache.hadoop.shaded.javax.ws.rs.core.Configuration;
import org.apache.hadoop.shaded.javax.ws.rs.core.Context;
import org.apache.hadoop.shaded.javax.ws.rs.core.MediaType;
import org.apache.hadoop.shaded.javax.ws.rs.ext.Providers;
import org.apache.hadoop.shaded.org.glassfish.jersey.jaxb.internal.AbstractRootElementJaxbProvider;

public abstract class XmlRootElementJaxbProvider
extends AbstractRootElementJaxbProvider {
    private final Provider<SAXParserFactory> spf;

    XmlRootElementJaxbProvider(Provider<SAXParserFactory> spf, Providers ps, Configuration config) {
        super(ps, config);
        this.spf = spf;
    }

    XmlRootElementJaxbProvider(Provider<SAXParserFactory> spf, Providers ps, MediaType mt, Configuration config) {
        super(ps, mt, config);
        this.spf = spf;
    }

    @Override
    protected Object readFrom(Class<Object> type, MediaType mediaType, Unmarshaller u, InputStream entityStream) throws JAXBException {
        SAXSource s = XmlRootElementJaxbProvider.getSAXSource(this.spf.get(), entityStream);
        if (type.isAnnotationPresent(XmlRootElement.class)) {
            return u.unmarshal(s);
        }
        return u.unmarshal(s, type).getValue();
    }

    @Produces(value={"*/*"})
    @Consumes(value={"*/*"})
    @Singleton
    public static final class General
    extends XmlRootElementJaxbProvider {
        @Inject
        public General(@Context Provider<SAXParserFactory> spf, @Context Providers ps, @Context Configuration config) {
            super(spf, ps, config);
        }

        @Override
        protected boolean isSupported(MediaType m) {
            return m.getSubtype().endsWith("+xml");
        }
    }

    @Produces(value={"text/xml"})
    @Consumes(value={"text/xml"})
    @Singleton
    public static final class Text
    extends XmlRootElementJaxbProvider {
        @Inject
        public Text(@Context Provider<SAXParserFactory> spf, @Context Providers ps, @Context Configuration config) {
            super(spf, ps, MediaType.TEXT_XML_TYPE, config);
        }
    }

    @Produces(value={"application/xml"})
    @Consumes(value={"application/xml"})
    @Singleton
    public static final class App
    extends XmlRootElementJaxbProvider {
        @Inject
        public App(@Context Provider<SAXParserFactory> spf, @Context Providers ps, @Context Configuration config) {
            super(spf, ps, MediaType.APPLICATION_XML_TYPE, config);
        }
    }
}

