/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.glassfish.jersey.client.filter;

import org.apache.hadoop.shaded.javax.ws.rs.core.Feature;
import org.apache.hadoop.shaded.javax.ws.rs.core.FeatureContext;
import org.apache.hadoop.shaded.org.glassfish.jersey.client.filter.EncodingFilter;
import org.apache.hadoop.shaded.org.glassfish.jersey.internal.inject.Providers;
import org.apache.hadoop.shaded.org.glassfish.jersey.spi.ContentEncoder;

public class EncodingFeature
implements Feature {
    private final String useEncoding;
    private final Class<?>[] encodingProviders;

    public EncodingFeature(Class<?> ... encodingProviders) {
        this((String)null, encodingProviders);
    }

    public EncodingFeature(String useEncoding, Class<?> ... encoders) {
        this.useEncoding = useEncoding;
        Providers.ensureContract(ContentEncoder.class, encoders);
        this.encodingProviders = encoders;
    }

    public boolean configure(FeatureContext context) {
        boolean enable;
        if (this.useEncoding != null && !context.getConfiguration().getProperties().containsKey("org.apache.hadoop.shaded.jersey.config.client.useEncoding")) {
            context.property("org.apache.hadoop.shaded.jersey.config.client.useEncoding", (Object)this.useEncoding);
        }
        for (Class<?> provider : this.encodingProviders) {
            context.register(provider);
        }
        boolean bl = enable = this.useEncoding != null || this.encodingProviders.length > 0;
        if (enable) {
            context.register(EncodingFilter.class);
        }
        return enable;
    }
}

