/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.glassfish.jersey.client;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.apache.hadoop.shaded.javax.inject.Inject;
import org.apache.hadoop.shaded.javax.inject.Provider;
import org.apache.hadoop.shaded.javax.ws.rs.ConstrainedTo;
import org.apache.hadoop.shaded.javax.ws.rs.RuntimeType;
import org.apache.hadoop.shaded.javax.ws.rs.WebApplicationException;
import org.apache.hadoop.shaded.javax.ws.rs.core.Context;
import org.apache.hadoop.shaded.javax.ws.rs.core.MediaType;
import org.apache.hadoop.shaded.javax.ws.rs.core.MultivaluedMap;
import org.apache.hadoop.shaded.javax.ws.rs.ext.MessageBodyReader;
import org.apache.hadoop.shaded.org.glassfish.jersey.client.ChunkedInput;
import org.apache.hadoop.shaded.org.glassfish.jersey.internal.PropertiesDelegate;
import org.apache.hadoop.shaded.org.glassfish.jersey.internal.util.ReflectionHelper;
import org.apache.hadoop.shaded.org.glassfish.jersey.message.MessageBodyWorkers;
import org.apache.hadoop.shaded.org.glassfish.jersey.message.internal.ReaderInterceptorExecutor;

@ConstrainedTo(value=RuntimeType.CLIENT)
class ChunkedInputReader
implements MessageBodyReader<ChunkedInput> {
    private final Provider<MessageBodyWorkers> messageBodyWorkers;
    private final Provider<PropertiesDelegate> propertiesDelegateProvider;

    @Inject
    public ChunkedInputReader(@Context Provider<MessageBodyWorkers> messageBodyWorkers, @Context Provider<PropertiesDelegate> propertiesDelegateProvider) {
        this.messageBodyWorkers = messageBodyWorkers;
        this.propertiesDelegateProvider = propertiesDelegateProvider;
    }

    public boolean isReadable(Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return aClass.equals(ChunkedInput.class);
    }

    public ChunkedInput readFrom(Class<ChunkedInput> chunkedInputClass, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> headers, InputStream inputStream) throws IOException, WebApplicationException {
        Type chunkType = ReflectionHelper.getTypeArgument(type, 0);
        return new ChunkedInput(chunkType, ReaderInterceptorExecutor.closeableInputStream(inputStream), annotations, mediaType, headers, this.messageBodyWorkers.get(), this.propertiesDelegateProvider.get());
    }
}

