/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.glassfish.jersey;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.shaded.javax.ws.rs.RuntimeType;
import org.apache.hadoop.shaded.org.glassfish.jersey.internal.AbstractServiceFinderConfigurator;
import org.apache.hadoop.shaded.org.glassfish.jersey.internal.BootstrapBag;
import org.apache.hadoop.shaded.org.glassfish.jersey.internal.ServiceFinder;
import org.apache.hadoop.shaded.org.glassfish.jersey.internal.spi.AutoDiscoverable;
import org.apache.hadoop.shaded.org.glassfish.jersey.internal.util.PropertiesHelper;

public abstract class AbstractFeatureConfigurator<T>
extends AbstractServiceFinderConfigurator<T> {
    protected AbstractFeatureConfigurator(Class contract, RuntimeType runtimeType) {
        super(contract, runtimeType);
    }

    protected List<Class<T>> loadImplementations(Map<String, Object> applicationProperties, ClassLoader loader) {
        if (PropertiesHelper.isMetaInfServicesEnabled(applicationProperties, this.getRuntimeType())) {
            return Stream.of(ServiceFinder.find(this.getContract(), loader, true).toClassArray()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    protected void registerFeatures(Collection<Class<T>> features, BootstrapBag bootstrapBag) {
        ArrayList autoDiscoverables = new ArrayList();
        features.forEach(feature -> autoDiscoverables.add(AbstractFeatureConfigurator.registerClass(feature)));
        bootstrapBag.getAutoDiscoverables().addAll(autoDiscoverables);
    }

    private static <T> AutoDiscoverable registerClass(Class<T> classToRegister) {
        return context -> {
            if (!context.getConfiguration().isRegistered(classToRegister)) {
                context.register(classToRegister, 2000);
            }
        };
    }
}

