/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.endpoints;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.hadoop.shaded.javax.websocket.CloseReason;
import org.apache.hadoop.shaded.javax.websocket.Endpoint;
import org.apache.hadoop.shaded.javax.websocket.MessageHandler;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.BufferUtil;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.log.Log;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.log.Logger;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.api.Session;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.api.extensions.Frame;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.events.EventDriver;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.message.MessageInputStream;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.message.MessageReader;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.JsrPongMessage;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.JsrSession;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.MessageHandlerWrapper;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.MessageType;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.endpoints.AbstractJsrEventDriver;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.endpoints.EndpointInstance;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.messages.BinaryPartialMessage;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.messages.BinaryWholeMessage;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.messages.TextPartialMessage;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.messages.TextWholeMessage;

public class JsrEndpointEventDriver
extends AbstractJsrEventDriver {
    private static final Logger LOG = Log.getLogger(JsrEndpointEventDriver.class);
    private final Endpoint endpoint;
    private Map<String, String> pathParameters;

    public JsrEndpointEventDriver(WebSocketPolicy policy, EndpointInstance endpointInstance) {
        super(policy, endpointInstance);
        this.endpoint = (Endpoint)endpointInstance.getEndpoint();
    }

    @Override
    public void init(JsrSession jsrsession) {
        jsrsession.setPathParameters(this.pathParameters);
    }

    public void onBinaryFrame(ByteBuffer buffer, boolean fin) throws IOException {
        if (this.activeMessage == null) {
            MessageHandlerWrapper wrapper = this.jsrsession.getMessageHandlerWrapper(MessageType.BINARY);
            if (wrapper == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No BINARY MessageHandler declared", new Object[0]);
                }
                return;
            }
            if (wrapper.wantsPartialMessages()) {
                this.activeMessage = new BinaryPartialMessage(wrapper);
            } else if (wrapper.wantsStreams()) {
                MessageHandler.Whole handler = (MessageHandler.Whole)wrapper.getHandler();
                MessageInputStream inputStream = new MessageInputStream((Session)this.session);
                this.activeMessage = inputStream;
                this.dispatch(() -> {
                    try {
                        handler.onMessage(inputStream);
                    }
                    catch (Throwable t) {
                        this.session.close(t);
                        return;
                    }
                    inputStream.handlerComplete();
                });
            } else {
                this.activeMessage = new BinaryWholeMessage((EventDriver)this, wrapper);
            }
        }
        this.activeMessage.appendFrame(buffer, fin);
        if (fin) {
            this.activeMessage.messageComplete();
            this.activeMessage = null;
        }
    }

    public void onBinaryMessage(byte[] data) {
    }

    @Override
    protected void onClose(CloseReason closereason) {
        this.endpoint.onClose(this.jsrsession, closereason);
    }

    public void onConnect() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onConnect({}, {})", this.jsrsession, this.config);
        }
        this.endpoint.onOpen(this.jsrsession, this.config);
    }

    public void onError(Throwable cause) {
        try {
            this.endpoint.onError(this.jsrsession, cause);
        }
        catch (Throwable t) {
            LOG.warn("Unable to report to onError due to exception", t);
        }
    }

    @Override
    public void onFrame(Frame frame) {
    }

    public void onInputStream(InputStream stream) {
    }

    public void onReader(Reader reader) {
    }

    public void onTextFrame(ByteBuffer buffer, boolean fin) throws IOException {
        if (this.activeMessage == null) {
            MessageHandlerWrapper wrapper = this.jsrsession.getMessageHandlerWrapper(MessageType.TEXT);
            if (wrapper == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No TEXT MessageHandler declared", new Object[0]);
                }
                return;
            }
            if (wrapper.wantsPartialMessages()) {
                this.activeMessage = new TextPartialMessage(wrapper);
            } else if (wrapper.wantsStreams()) {
                MessageHandler.Whole handler = (MessageHandler.Whole)wrapper.getHandler();
                MessageReader reader = new MessageReader((Session)this.session);
                this.activeMessage = reader;
                this.dispatch(() -> {
                    try {
                        handler.onMessage(reader);
                    }
                    catch (Throwable t) {
                        this.session.close(t);
                        return;
                    }
                    reader.handlerComplete();
                });
            } else {
                this.activeMessage = new TextWholeMessage((EventDriver)this, wrapper);
            }
        }
        this.activeMessage.appendFrame(buffer, fin);
        if (fin) {
            this.activeMessage.messageComplete();
            this.activeMessage = null;
        }
    }

    public void onTextMessage(String message) {
    }

    public void onPing(ByteBuffer buffer) {
        this.onPongMessage(buffer);
    }

    public void onPong(ByteBuffer buffer) {
        this.onPongMessage(buffer);
    }

    private void onPongMessage(ByteBuffer buffer) {
        MessageHandlerWrapper wrapper = this.jsrsession.getMessageHandlerWrapper(MessageType.PONG);
        if (wrapper == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No PONG MessageHandler declared", new Object[0]);
            }
            return;
        }
        ByteBuffer pongBuf = null;
        if (BufferUtil.isEmpty(buffer)) {
            pongBuf = BufferUtil.EMPTY_BUFFER;
        } else {
            pongBuf = ByteBuffer.allocate(buffer.remaining());
            BufferUtil.put(buffer, pongBuf);
            BufferUtil.flipToFlush(pongBuf, 0);
        }
        MessageHandler.Whole pongHandler = (MessageHandler.Whole)wrapper.getHandler();
        pongHandler.onMessage(new JsrPongMessage(pongBuf));
    }

    @Override
    public void setPathParameters(Map<String, String> pathParameters) {
        this.pathParameters = pathParameters;
    }

    public String toString() {
        return String.format("%s[%s]", JsrEndpointEventDriver.class.getSimpleName(), this.endpoint.getClass().getName());
    }
}

