/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.endpoints;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.hadoop.shaded.javax.websocket.CloseReason;
import org.apache.hadoop.shaded.javax.websocket.DecodeException;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.BufferUtil;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.log.Log;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.log.Logger;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.api.Session;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.api.extensions.Frame;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.events.EventDriver;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.message.MessageInputStream;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.message.MessageReader;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.message.SimpleBinaryMessage;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.message.SimpleTextMessage;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.JsrSession;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.annotations.JsrEvents;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.endpoints.AbstractJsrEventDriver;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.endpoints.EndpointInstance;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.messages.BinaryPartialOnMessage;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.messages.TextPartialOnMessage;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.metadata.EndpointMetadata;

public class JsrAnnotatedEventDriver
extends AbstractJsrEventDriver {
    private static final Logger LOG = Log.getLogger(JsrAnnotatedEventDriver.class);
    private final JsrEvents<?, ?> events;

    public JsrAnnotatedEventDriver(WebSocketPolicy policy, EndpointInstance endpointInstance, JsrEvents<?, ?> events) {
        super(policy, endpointInstance);
        this.events = events;
        EndpointMetadata metadata = endpointInstance.getMetadata();
        if (metadata.maxTextMessageSize() >= 1L) {
            policy.setMaxTextMessageSize((int)metadata.maxTextMessageSize());
        }
        if (metadata.maxBinaryMessageSize() >= 1L) {
            policy.setMaxBinaryMessageSize((int)metadata.maxBinaryMessageSize());
        }
    }

    @Override
    public void init(JsrSession jsrsession) {
        this.events.init(jsrsession);
    }

    public void onBinaryFrame(ByteBuffer buffer, boolean fin) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onBinaryFrame({}, {})", BufferUtil.toDetailString(buffer), fin);
            LOG.debug("events.onBinary={}", this.events.hasBinary());
            LOG.debug("events.onBinaryStream={}", this.events.hasBinaryStream());
        }
        boolean handled = false;
        if (this.events.hasBinary()) {
            handled = true;
            if (this.activeMessage == null) {
                if (this.events.isBinaryPartialSupported()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Partial Binary Message: fin={}", fin);
                    }
                    this.activeMessage = new BinaryPartialOnMessage(this);
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Whole Binary Message", new Object[0]);
                    }
                    this.activeMessage = new SimpleBinaryMessage((EventDriver)this);
                }
            }
        }
        if (this.events.hasBinaryStream()) {
            handled = true;
            if (this.activeMessage == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Binary Message InputStream", new Object[0]);
                }
                MessageInputStream stream = new MessageInputStream((Session)this.session);
                this.activeMessage = stream;
                this.dispatch(() -> {
                    try {
                        this.events.callBinaryStream(this.jsrsession.getAsyncRemote(), this.websocket, (InputStream)stream);
                    }
                    catch (Throwable e) {
                        this.session.close(e);
                    }
                    stream.handlerComplete();
                });
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("handled = {}", handled);
        }
        if (handled && this.activeMessage != null) {
            this.appendMessage(buffer, fin);
        }
    }

    public void onBinaryMessage(byte[] data) {
        if (data == null) {
            return;
        }
        ByteBuffer buf = ByteBuffer.wrap(data);
        if (LOG.isDebugEnabled()) {
            LOG.debug("onBinaryMessage({})", BufferUtil.toDetailString(buf));
        }
        try {
            this.events.callBinary(this.jsrsession.getAsyncRemote(), this.websocket, buf, true);
        }
        catch (Throwable e) {
            this.onFatalError(e);
        }
    }

    @Override
    protected void onClose(CloseReason closereason) {
        this.events.callClose(this.websocket, closereason);
    }

    public void onConnect() {
        this.events.callOpen(this.websocket, this.config);
    }

    public void onError(Throwable cause) {
        try {
            this.events.callError(this.websocket, cause);
        }
        catch (Throwable e) {
            LOG.warn("Unable to call onError with cause", cause);
            LOG.warn("Call to onError resulted in exception", e);
        }
    }

    private void onFatalError(Throwable t) {
        this.onError(t);
    }

    @Override
    public void onFrame(Frame frame) {
    }

    public void onInputStream(InputStream stream) throws IOException {
        try {
            this.events.callBinaryStream(this.jsrsession.getAsyncRemote(), this.websocket, stream);
        }
        catch (DecodeException e) {
            throw new RuntimeException("Unable decode input stream", e);
        }
    }

    public void onPartialBinaryMessage(ByteBuffer buffer, boolean fin) {
        try {
            this.events.callBinary(this.jsrsession.getAsyncRemote(), this.websocket, buffer, fin);
        }
        catch (DecodeException e) {
            throw new RuntimeException("Unable decode partial binary message", e);
        }
    }

    public void onPartialTextMessage(String message, boolean fin) {
        try {
            this.events.callText(this.jsrsession.getAsyncRemote(), this.websocket, message, fin);
        }
        catch (DecodeException e) {
            throw new RuntimeException("Unable decode partial text message", e);
        }
    }

    public void onPing(ByteBuffer buffer) {
        this.events.callPong(this.jsrsession.getAsyncRemote(), this.websocket, buffer);
    }

    public void onPong(ByteBuffer buffer) {
        this.events.callPong(this.jsrsession.getAsyncRemote(), this.websocket, buffer);
    }

    public void onReader(Reader reader) throws IOException {
        try {
            this.events.callTextStream(this.jsrsession.getAsyncRemote(), this.websocket, reader);
        }
        catch (DecodeException e) {
            throw new RuntimeException("Unable decode reader", e);
        }
    }

    public void onTextFrame(ByteBuffer buffer, boolean fin) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onTextFrame({}, {})", BufferUtil.toDetailString(buffer), fin);
            LOG.debug("events.hasText={}", this.events.hasText());
            LOG.debug("events.hasTextStream={}", this.events.hasTextStream());
        }
        boolean handled = false;
        if (this.events.hasText()) {
            handled = true;
            if (this.activeMessage == null) {
                if (this.events.isTextPartialSupported()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Partial Text Message: fin={}", fin);
                    }
                    this.activeMessage = new TextPartialOnMessage(this);
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Whole Text Message", new Object[0]);
                    }
                    this.activeMessage = new SimpleTextMessage((EventDriver)this);
                }
            }
        }
        if (this.events.hasTextStream()) {
            handled = true;
            if (this.activeMessage == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Text Message Writer", new Object[0]);
                }
                MessageReader reader = new MessageReader((Session)this.session);
                this.activeMessage = reader;
                this.dispatch(() -> {
                    try {
                        this.events.callTextStream(this.jsrsession.getAsyncRemote(), this.websocket, (Reader)reader);
                    }
                    catch (Throwable e) {
                        this.session.close(e);
                        return;
                    }
                    reader.handlerComplete();
                });
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("handled = {}", handled);
        }
        if (handled && this.activeMessage != null) {
            this.appendMessage(buffer, fin);
        }
    }

    public void onTextMessage(String message) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onText({})", message);
        }
        try {
            this.events.callText(this.jsrsession.getAsyncRemote(), this.websocket, message, true);
        }
        catch (Throwable e) {
            this.onFatalError(e);
        }
    }

    @Override
    public void setPathParameters(Map<String, String> pathParameters) {
        this.events.setPathParameters(pathParameters);
    }

    public String toString() {
        return String.format("%s[websocket=%s]", ((Object)((Object)this)).getClass().getSimpleName(), this.websocket);
    }
}

