/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import org.apache.hadoop.shaded.javax.websocket.EncodeException;
import org.apache.hadoop.shaded.javax.websocket.Encoder;
import org.apache.hadoop.shaded.javax.websocket.RemoteEndpoint;
import org.apache.hadoop.shaded.javax.websocket.SendHandler;
import org.apache.hadoop.shaded.javax.websocket.SendResult;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.BufferUtil;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.log.Log;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.log.Logger;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.api.WriteCallback;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.WebSocketSession;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.frames.BinaryFrame;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.frames.TextFrame;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.message.MessageOutputStream;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.message.MessageWriter;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.util.TextUtil;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.AbstractJsrRemote;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.JsrSession;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.messages.SendHandlerWriteCallback;

public class JsrAsyncRemote
extends AbstractJsrRemote
implements RemoteEndpoint.Async {
    static final Logger LOG = Log.getLogger(JsrAsyncRemote.class);

    protected JsrAsyncRemote(JsrSession session) {
        super(session);
    }

    @Override
    public long getSendTimeout() {
        return 0L;
    }

    @Override
    public Future<Void> sendBinary(ByteBuffer data) {
        this.assertMessageNotNull(data);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendBinary({})", BufferUtil.toDetailString(data));
        }
        return this.jettyRemote.sendBytesByFuture(data);
    }

    @Override
    public void sendBinary(ByteBuffer data, SendHandler handler) {
        this.assertMessageNotNull(data);
        this.assertSendHandlerNotNull(handler);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendBinary({},{})", BufferUtil.toDetailString(data), handler);
        }
        WebSocketFrame frame = new BinaryFrame().setPayload(data).setFin(true);
        this.jettyRemote.uncheckedSendFrame(frame, (WriteCallback)new SendHandlerWriteCallback(handler));
    }

    @Override
    public Future<Void> sendObject(Object data) {
        return this.sendObjectViaFuture(data);
    }

    @Override
    public void sendObject(Object data, SendHandler handler) {
        Encoder encoder;
        this.assertMessageNotNull(data);
        this.assertSendHandlerNotNull(handler);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendObject({},{})", data, handler);
        }
        if ((encoder = this.encoders.getEncoderFor(data.getClass())) == null) {
            throw new IllegalArgumentException("No encoder for type: " + data.getClass());
        }
        if (encoder instanceof Encoder.Text) {
            Encoder.Text etxt = (Encoder.Text)encoder;
            try {
                String msg = etxt.encode(data);
                this.sendText(msg, handler);
                return;
            }
            catch (EncodeException e) {
                handler.onResult(new SendResult(e));
            }
        } else if (encoder instanceof Encoder.TextStream) {
            Encoder.TextStream etxt = (Encoder.TextStream)encoder;
            SendHandlerWriteCallback callback = new SendHandlerWriteCallback(handler);
            try (MessageWriter writer = new MessageWriter((WebSocketSession)this.session);){
                writer.setCallback((WriteCallback)callback);
                etxt.encode(data, (Writer)writer);
                return;
            }
            catch (IOException | EncodeException e) {
                handler.onResult(new SendResult(e));
            }
        } else if (encoder instanceof Encoder.Binary) {
            Encoder.Binary ebin = (Encoder.Binary)encoder;
            try {
                ByteBuffer buf = ebin.encode(data);
                this.sendBinary(buf, handler);
                return;
            }
            catch (EncodeException e) {
                handler.onResult(new SendResult(e));
            }
        } else if (encoder instanceof Encoder.BinaryStream) {
            Encoder.BinaryStream ebin = (Encoder.BinaryStream)encoder;
            SendHandlerWriteCallback callback = new SendHandlerWriteCallback(handler);
            try (MessageOutputStream out = new MessageOutputStream((WebSocketSession)this.session);){
                out.setCallback((WriteCallback)callback);
                ebin.encode(data, (OutputStream)out);
                return;
            }
            catch (IOException | EncodeException e) {
                handler.onResult(new SendResult(e));
            }
        }
        throw new IllegalArgumentException("Unknown encoder type: " + encoder);
    }

    @Override
    public Future<Void> sendText(String text) {
        this.assertMessageNotNull(text);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendText({})", TextUtil.hint((String)text));
        }
        return this.jettyRemote.sendStringByFuture(text);
    }

    @Override
    public void sendText(String text, SendHandler handler) {
        this.assertMessageNotNull(text);
        this.assertSendHandlerNotNull(handler);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendText({},{})", TextUtil.hint((String)text), handler);
        }
        WebSocketFrame frame = new TextFrame().setPayload(text).setFin(true);
        this.jettyRemote.uncheckedSendFrame(frame, (WriteCallback)new SendHandlerWriteCallback(handler));
    }

    @Override
    public void setSendTimeout(long timeoutmillis) {
    }
}

