/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import org.apache.hadoop.shaded.javax.websocket.EncodeException;
import org.apache.hadoop.shaded.javax.websocket.Encoder;
import org.apache.hadoop.shaded.javax.websocket.RemoteEndpoint;
import org.apache.hadoop.shaded.javax.websocket.SendHandler;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.BufferUtil;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.log.Log;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.log.Logger;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.api.BatchMode;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.api.WriteCallback;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.WebSocketRemoteEndpoint;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.WebSocketSession;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.io.FutureWriteCallback;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.message.MessageOutputStream;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.message.MessageWriter;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.EncoderFactory;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.JsrSession;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.encoders.EncodeFailedFuture;

public abstract class AbstractJsrRemote
implements RemoteEndpoint {
    private static final Logger LOG = Log.getLogger(AbstractJsrRemote.class);
    protected final JsrSession session;
    protected final WebSocketRemoteEndpoint jettyRemote;
    protected final EncoderFactory encoders;

    protected AbstractJsrRemote(JsrSession session) {
        this.session = session;
        if (!(session.getRemote() instanceof WebSocketRemoteEndpoint)) {
            StringBuilder err = new StringBuilder();
            err.append("Unexpected implementation [");
            if (session.getRemote() == null) {
                err.append("<null>");
            } else {
                err.append(session.getRemote().getClass().getName());
            }
            err.append("].  Expected an instanceof [");
            err.append(WebSocketRemoteEndpoint.class.getName());
            err.append("]");
            throw new IllegalStateException(err.toString());
        }
        this.jettyRemote = (WebSocketRemoteEndpoint)session.getRemote();
        this.encoders = session.getEncoderFactory();
    }

    protected void assertMessageNotNull(Object data) {
        if (data == null) {
            throw new IllegalArgumentException("message cannot be null");
        }
    }

    protected void assertSendHandlerNotNull(SendHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("SendHandler cannot be null");
        }
    }

    @Override
    public void flushBatch() throws IOException {
        this.jettyRemote.flush();
    }

    @Override
    public boolean getBatchingAllowed() {
        return this.jettyRemote.getBatchMode() == BatchMode.ON;
    }

    @Override
    public void setBatchingAllowed(boolean allowed) throws IOException {
        if (this.jettyRemote.getBatchMode() == BatchMode.ON && !allowed) {
            this.jettyRemote.flush();
        }
        this.jettyRemote.setBatchMode(allowed ? BatchMode.ON : BatchMode.OFF);
    }

    public Future<Void> sendObjectViaFuture(Object data) {
        Encoder encoder;
        this.assertMessageNotNull(data);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendObject({})", data);
        }
        if ((encoder = this.encoders.getEncoderFor(data.getClass())) == null) {
            throw new IllegalArgumentException("No encoder for type: " + data.getClass());
        }
        if (encoder instanceof Encoder.Text) {
            Encoder.Text text = (Encoder.Text)encoder;
            try {
                String msg = text.encode(data);
                return this.jettyRemote.sendStringByFuture(msg);
            }
            catch (EncodeException e) {
                return new EncodeFailedFuture(data, text, Encoder.Text.class, e);
            }
        }
        if (encoder instanceof Encoder.TextStream) {
            FutureWriteCallback futureWriteCallback;
            Encoder.TextStream etxt = (Encoder.TextStream)encoder;
            FutureWriteCallback callback = new FutureWriteCallback();
            MessageWriter writer = new MessageWriter((WebSocketSession)this.session);
            try {
                writer.setCallback((WriteCallback)callback);
                etxt.encode(data, (Writer)writer);
                futureWriteCallback = callback;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | EncodeException e) {
                    return new EncodeFailedFuture(data, etxt, Encoder.Text.class, e);
                }
            }
            writer.close();
            return futureWriteCallback;
        }
        if (encoder instanceof Encoder.Binary) {
            Encoder.Binary ebin = (Encoder.Binary)encoder;
            try {
                ByteBuffer buf = ebin.encode(data);
                return this.jettyRemote.sendBytesByFuture(buf);
            }
            catch (EncodeException e) {
                return new EncodeFailedFuture(data, ebin, Encoder.Binary.class, e);
            }
        }
        if (encoder instanceof Encoder.BinaryStream) {
            FutureWriteCallback futureWriteCallback;
            Encoder.BinaryStream ebin = (Encoder.BinaryStream)encoder;
            FutureWriteCallback callback = new FutureWriteCallback();
            MessageOutputStream out = new MessageOutputStream((WebSocketSession)this.session);
            try {
                out.setCallback((WriteCallback)callback);
                ebin.encode(data, (OutputStream)out);
                futureWriteCallback = callback;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
                catch (IOException | EncodeException e) {
                    return new EncodeFailedFuture(data, ebin, Encoder.Binary.class, e);
                }
            }
            out.close();
            return futureWriteCallback;
        }
        throw new IllegalArgumentException("Unknown encoder type: " + encoder);
    }

    @Override
    public void sendPing(ByteBuffer data) throws IOException, IllegalArgumentException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendPing({})", BufferUtil.toDetailString(data));
        }
        this.jettyRemote.sendPing(data);
    }

    @Override
    public void sendPong(ByteBuffer data) throws IOException, IllegalArgumentException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendPong({})", BufferUtil.toDetailString(data));
        }
        this.jettyRemote.sendPong(data);
    }
}

