/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.eclipse.jetty.plus.webapp;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import org.apache.hadoop.shaded.org.eclipse.jetty.plus.jndi.Transaction;
import org.apache.hadoop.shaded.org.eclipse.jetty.plus.webapp.PlusDecorator;
import org.apache.hadoop.shaded.org.eclipse.jetty.plus.webapp.PlusDescriptorProcessor;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.log.Log;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.log.Logger;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.thread.ThreadClassLoaderScope;
import org.apache.hadoop.shaded.org.eclipse.jetty.webapp.AbstractConfiguration;
import org.apache.hadoop.shaded.org.eclipse.jetty.webapp.DescriptorProcessor;
import org.apache.hadoop.shaded.org.eclipse.jetty.webapp.WebAppContext;

public class PlusConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = Log.getLogger(PlusConfiguration.class);
    private Integer _key;

    public void preConfigure(WebAppContext context) throws Exception {
        context.getObjectFactory().addDecorator(new PlusDecorator(context));
    }

    public void cloneConfigure(WebAppContext template, WebAppContext context) throws Exception {
        context.getObjectFactory().addDecorator(new PlusDecorator(context));
    }

    public void configure(WebAppContext context) throws Exception {
        this.bindUserTransaction(context);
        context.getMetaData().addDescriptorProcessor((DescriptorProcessor)new PlusDescriptorProcessor());
    }

    public void postConfigure(WebAppContext context) throws Exception {
        this.lockCompEnv(context);
    }

    public void deconfigure(WebAppContext context) throws Exception {
        this.unlockCompEnv(context);
        this._key = null;
        context.setAttribute("org.apache.hadoop.shaded.org.eclipse.jetty.injectionCollection", null);
        context.setAttribute("org.apache.hadoop.shaded.org.eclipse.jetty.lifecyleCallbackCollection", null);
    }

    public void bindUserTransaction(WebAppContext context) throws Exception {
        try {
            Transaction.bindToENC();
        }
        catch (NameNotFoundException e) {
            LOG.debug("No Transaction manager found - if your webapp requires one, please configure one.", new Object[0]);
        }
    }

    protected void lockCompEnv(WebAppContext wac) throws Exception {
        try (ThreadClassLoaderScope scope = new ThreadClassLoaderScope(wac.getClassLoader());){
            this._key = (int)((long)((Object)((Object)this)).hashCode() ^ System.nanoTime());
            InitialContext context = new InitialContext();
            Context compCtx = (Context)context.lookup("java:comp");
            compCtx.addToEnvironment("org.apache.hadoop.shaded.org.eclipse.jetty.jndi.lock", this._key);
        }
    }

    protected void unlockCompEnv(WebAppContext wac) throws Exception {
        if (this._key != null) {
            try (ThreadClassLoaderScope scope = new ThreadClassLoaderScope(wac.getClassLoader());){
                InitialContext context = new InitialContext();
                Context compCtx = (Context)context.lookup("java:comp");
                compCtx.addToEnvironment("org.apache.hadoop.shaded.org.eclipse.jetty.jndi.unlock", this._key);
            }
        }
    }
}

