/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.eclipse.jetty.plus.jndi;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.transaction.UserTransaction;
import org.apache.hadoop.shaded.org.eclipse.jetty.jndi.NamingUtil;
import org.apache.hadoop.shaded.org.eclipse.jetty.plus.jndi.NamingEntry;
import org.apache.hadoop.shaded.org.eclipse.jetty.plus.jndi.NamingEntryUtil;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.log.Log;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.log.Logger;

public class Transaction
extends NamingEntry {
    private static final Logger LOG = Log.getLogger(Transaction.class);
    public static final String USER_TRANSACTION = "UserTransaction";

    public static void bindToENC() throws NamingException {
        Transaction txEntry = (Transaction)NamingEntryUtil.lookupNamingEntry(null, USER_TRANSACTION);
        if (txEntry == null) {
            throw new NameNotFoundException("UserTransaction not found");
        }
        txEntry.bindToComp();
    }

    public Transaction(UserTransaction userTransaction) throws NamingException {
        super(USER_TRANSACTION);
        this.save(userTransaction);
    }

    @Override
    public void bindToENC(String localName) throws NamingException {
        InitialContext ic = new InitialContext();
        Context env = (Context)ic.lookup("java:comp/env");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Binding java:comp/env" + this.getJndiName() + " to " + this._objectNameString, new Object[0]);
        }
        NamingUtil.bind(env, localName, new LinkRef(this._objectNameString));
    }

    private void bindToComp() throws NamingException {
        InitialContext ic = new InitialContext();
        Context env = (Context)ic.lookup("java:comp");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Binding java:comp/" + this.getJndiName() + " to " + this._objectNameString, new Object[0]);
        }
        NamingUtil.bind(env, this.getJndiName(), new LinkRef(this._objectNameString));
    }

    @Override
    public void unbindENC() {
        try {
            InitialContext ic = new InitialContext();
            Context env = (Context)ic.lookup("java:comp");
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unbinding java:comp/" + this.getJndiName(), new Object[0]);
            }
            env.unbind(this.getJndiName());
        }
        catch (NamingException e) {
            LOG.warn(e);
        }
    }
}

