/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.eclipse.jetty.annotations;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.shaded.org.eclipse.jetty.annotations.AnnotationParser;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.log.Log;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.log.Logger;

public class ClassInheritanceHandler
extends AnnotationParser.AbstractHandler {
    private static final Logger LOG = Log.getLogger(ClassInheritanceHandler.class);
    Map<String, Set<String>> _inheritanceMap;

    public ClassInheritanceHandler(Map<String, Set<String>> map) {
        this._inheritanceMap = map;
    }

    @Override
    public void handle(AnnotationParser.ClassInfo classInfo) {
        try {
            if ("java.lang.Object".equals(classInfo.getClassName())) {
                return;
            }
            for (int i = 0; classInfo.getInterfaces() != null && i < classInfo.getInterfaces().length; ++i) {
                this.addToInheritanceMap(classInfo.getInterfaces()[i], classInfo.getClassName());
            }
            if (!"java.lang.Object".equals(classInfo.getSuperName())) {
                this.addToInheritanceMap(classInfo.getSuperName(), classInfo.getClassName());
            }
        }
        catch (Exception e) {
            LOG.warn(e);
        }
    }

    private void addToInheritanceMap(String interfaceOrSuperClassName, String implementingOrExtendingClassName) {
        Set<String> tmp;
        Set<String> implementingClasses = this._inheritanceMap.get(interfaceOrSuperClassName);
        if (implementingClasses == null && (tmp = this._inheritanceMap.putIfAbsent(interfaceOrSuperClassName, implementingClasses = ConcurrentHashMap.newKeySet())) != null) {
            implementingClasses = tmp;
        }
        implementingClasses.add(implementingOrExtendingClassName);
    }
}

