/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.zookeeper.server.admin;

import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class CommandResponse {
    public static final String KEY_COMMAND = "command";
    public static final String KEY_ERROR = "error";
    private final String command;
    private final String error;
    private final Map<String, Object> data;
    private final Map<String, String> headers;
    private int statusCode;
    private InputStream inputStream;

    public CommandResponse(String command) {
        this(command, null, 200);
    }

    public CommandResponse(String command, String error, int statusCode) {
        this(command, error, statusCode, null);
    }

    public CommandResponse(String command, String error, int statusCode, InputStream inputStream) {
        this.command = command;
        this.error = error;
        this.data = new LinkedHashMap<String, Object>();
        this.headers = new HashMap<String, String>();
        this.statusCode = statusCode;
        this.inputStream = inputStream;
    }

    public String getCommand() {
        return this.command;
    }

    public String getError() {
        return this.error;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public Object put(String key, Object value) {
        return this.data.put(key, value);
    }

    public void putAll(Map<? extends String, ?> m) {
        this.data.putAll(m);
    }

    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>(this.data);
        m.put(KEY_COMMAND, this.command);
        m.put(KEY_ERROR, this.error);
        m.putAll(this.data);
        return m;
    }
}

