/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.zookeeper.server;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import org.apache.hadoop.shaded.org.apache.jute.BinaryOutputArchive;
import org.apache.hadoop.shaded.org.apache.jute.Record;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.RequestRecord;

public class SimpleRequestRecord
implements RequestRecord {
    private final Record record;
    private volatile byte[] bytes;

    public SimpleRequestRecord(Record record) {
        this.record = record;
    }

    @Override
    public <T extends Record> T readRecord(Supplier<T> constructor) {
        return (T)this.record;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public byte[] readBytes() {
        if (this.bytes != null) {
            return this.bytes;
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            BinaryOutputArchive boa = BinaryOutputArchive.getArchive(baos);
            this.record.serialize(boa, "request");
            byte[] byArray = this.bytes = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public int limit() {
        byte[] bytes = this.readBytes();
        return ByteBuffer.wrap(bytes).limit();
    }
}

