/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.net.bytebuddy.build;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.apache.hadoop.shaded.net.bytebuddy.asm.MemberAttributeExtension;
import org.apache.hadoop.shaded.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import org.apache.hadoop.shaded.net.bytebuddy.build.Plugin;
import org.apache.hadoop.shaded.net.bytebuddy.description.method.MethodDescription;
import org.apache.hadoop.shaded.net.bytebuddy.description.type.TypeDescription;
import org.apache.hadoop.shaded.net.bytebuddy.dynamic.ClassFileLocator;
import org.apache.hadoop.shaded.net.bytebuddy.dynamic.DynamicType;
import org.apache.hadoop.shaded.net.bytebuddy.implementation.attribute.AnnotationValueFilter;
import org.apache.hadoop.shaded.net.bytebuddy.implementation.attribute.MethodAttributeAppender;
import org.apache.hadoop.shaded.net.bytebuddy.jar.asm.AnnotationVisitor;
import org.apache.hadoop.shaded.net.bytebuddy.jar.asm.MethodVisitor;
import org.apache.hadoop.shaded.net.bytebuddy.matcher.ElementMatchers;
import org.apache.hadoop.shaded.net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HashCodeAndEqualsPlugin.Enhance
public class SafeVarargsPlugin
extends Plugin.ForElementMatcher {
    public SafeVarargsPlugin() {
        super(ElementMatchers.declaresMethod(ElementMatchers.isAnnotatedWith(Enhance.class)));
    }

    @Override
    public DynamicType.Builder<?> apply(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassFileLocator classFileLocator) {
        return builder.visit(new MemberAttributeExtension.ForMethod().attribute(SafeVarargsAppender.INSTANCE).on(ElementMatchers.isAnnotatedWith(Enhance.class)));
    }

    @Override
    public void close() {
    }

    @Override
    public boolean equals(@MaybeNull Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        return this.getClass() == object.getClass();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum SafeVarargsAppender implements MethodAttributeAppender,
    MethodAttributeAppender.Factory
    {
        INSTANCE;


        @Override
        public MethodAttributeAppender make(TypeDescription typeDescription) {
            return this;
        }

        @Override
        public void apply(MethodVisitor methodVisitor, MethodDescription methodDescription, AnnotationValueFilter annotationValueFilter) {
            if (!methodDescription.isVarArgs()) {
                throw new IllegalStateException(methodDescription + " does not have variable arguments");
            }
            if (!(methodDescription.isConstructor() || methodDescription.isStatic() || methodDescription.isFinal())) {
                throw new IllegalStateException(methodDescription + " is neither a constructor or final and cannot declare safe varargs");
            }
            AnnotationVisitor visitor = methodVisitor.visitAnnotation("Ljava/lang/SafeVarargs;", true);
            if (visitor != null) {
                visitor.visitEnd();
            }
        }
    }

    @Documented
    @Target(value={ElementType.CONSTRUCTOR, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Enhance {
    }
}

