/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.net.bytebuddy.asm;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.shaded.net.bytebuddy.asm.AsmVisitorWrapper;
import org.apache.hadoop.shaded.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import org.apache.hadoop.shaded.net.bytebuddy.description.annotation.AnnotationDescription;
import org.apache.hadoop.shaded.net.bytebuddy.description.field.FieldDescription;
import org.apache.hadoop.shaded.net.bytebuddy.description.field.FieldList;
import org.apache.hadoop.shaded.net.bytebuddy.description.method.MethodDescription;
import org.apache.hadoop.shaded.net.bytebuddy.description.method.MethodList;
import org.apache.hadoop.shaded.net.bytebuddy.description.method.ParameterDescription;
import org.apache.hadoop.shaded.net.bytebuddy.description.type.TypeDescription;
import org.apache.hadoop.shaded.net.bytebuddy.implementation.Implementation;
import org.apache.hadoop.shaded.net.bytebuddy.jar.asm.AnnotationVisitor;
import org.apache.hadoop.shaded.net.bytebuddy.jar.asm.ClassVisitor;
import org.apache.hadoop.shaded.net.bytebuddy.jar.asm.FieldVisitor;
import org.apache.hadoop.shaded.net.bytebuddy.jar.asm.MethodVisitor;
import org.apache.hadoop.shaded.net.bytebuddy.matcher.ElementMatcher;
import org.apache.hadoop.shaded.net.bytebuddy.matcher.ElementMatchers;
import org.apache.hadoop.shaded.net.bytebuddy.pool.TypePool;
import org.apache.hadoop.shaded.net.bytebuddy.utility.CompoundList;
import org.apache.hadoop.shaded.net.bytebuddy.utility.OpenedClassReader;
import org.apache.hadoop.shaded.net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HashCodeAndEqualsPlugin.Enhance
public class AnnotationRemoval
extends AsmVisitorWrapper.AbstractBase {
    private static final int METHOD_NONE = -4;
    private static final int METHOD_ALL = -3;
    private static final int METHOD_ONLY = -2;
    private static final int METHOD_PARAMETERS = -1;
    private final boolean type;
    private final ElementMatcher<? super FieldDescription.InDefinedShape> fieldMatcher;
    private final ElementMatcher<? super MethodDescription> methodMatcher;
    private final ElementMatcher<? super AnnotationDescription> annotationMatcher;
    private final int parameters;

    protected AnnotationRemoval(boolean type, ElementMatcher<? super FieldDescription.InDefinedShape> fieldMatcher, ElementMatcher<? super MethodDescription> methodMatcher, ElementMatcher<? super AnnotationDescription> annotationMatcher, int parameters) {
        this.type = type;
        this.fieldMatcher = fieldMatcher;
        this.methodMatcher = methodMatcher;
        this.annotationMatcher = annotationMatcher;
        this.parameters = parameters;
    }

    public static AnnotationRemoval strip(ElementMatcher<? super AnnotationDescription> matcher) {
        return new AnnotationRemoval(true, ElementMatchers.any(), ElementMatchers.any(), matcher, -3);
    }

    public AsmVisitorWrapper onType() {
        return new AnnotationRemoval(true, ElementMatchers.none(), ElementMatchers.none(), this.annotationMatcher, -4);
    }

    public AsmVisitorWrapper onFields(ElementMatcher<? super FieldDescription> matcher) {
        return new AnnotationRemoval(false, matcher, ElementMatchers.none(), this.annotationMatcher, -4);
    }

    public AsmVisitorWrapper onMethods(ElementMatcher<? super MethodDescription> matcher) {
        return this.onInvokables(ElementMatchers.isMethod().and(matcher));
    }

    public AsmVisitorWrapper onMethodsAndParameters(ElementMatcher<? super MethodDescription> matcher) {
        return this.onInvokablesAndParameters(ElementMatchers.isMethod().and(matcher));
    }

    public AsmVisitorWrapper onMethodParameters(ElementMatcher<? super MethodDescription> matcher) {
        return this.onInvokableParameters(ElementMatchers.isMethod().and(matcher));
    }

    public AsmVisitorWrapper onMethodParameter(ElementMatcher<? super MethodDescription> matcher, int parameter) {
        return this.onInvokableParameter(ElementMatchers.isMethod().and(matcher), parameter);
    }

    public AsmVisitorWrapper onConstructors(ElementMatcher<? super MethodDescription> matcher) {
        return this.onInvokables(ElementMatchers.isConstructor().and(matcher));
    }

    public AsmVisitorWrapper onConstructorsAndParameters(ElementMatcher<? super MethodDescription> matcher) {
        return this.onInvokablesAndParameters(ElementMatchers.isConstructor().and(matcher));
    }

    public AsmVisitorWrapper onConstructorParameters(ElementMatcher<? super MethodDescription> matcher) {
        return this.onInvokableParameters(ElementMatchers.isConstructor().and(matcher));
    }

    public AsmVisitorWrapper onConstructorParameter(ElementMatcher<? super MethodDescription> matcher, int parameter) {
        return this.onInvokableParameter(ElementMatchers.isConstructor().and(matcher), parameter);
    }

    public AsmVisitorWrapper onInvokables(ElementMatcher<? super MethodDescription> matcher) {
        return new AnnotationRemoval(false, ElementMatchers.none(), matcher, this.annotationMatcher, -2);
    }

    public AsmVisitorWrapper onInvokablesAndParameters(ElementMatcher<? super MethodDescription> matcher) {
        return new AnnotationRemoval(false, ElementMatchers.none(), matcher, this.annotationMatcher, -3);
    }

    public AsmVisitorWrapper onInvokableParameters(ElementMatcher<? super MethodDescription> matcher) {
        return new AnnotationRemoval(false, ElementMatchers.none(), matcher, this.annotationMatcher, -1);
    }

    public AsmVisitorWrapper onInvokableParameter(ElementMatcher<? super MethodDescription> matcher, int parameter) {
        if (parameter < 0) {
            throw new IllegalArgumentException("Parameter index cannot be negative: " + parameter);
        }
        return new AnnotationRemoval(false, ElementMatchers.none(), matcher, this.annotationMatcher, parameter);
    }

    @Override
    public ClassVisitor wrap(TypeDescription instrumentedType, ClassVisitor classVisitor, Implementation.Context implementationContext, TypePool typePool, FieldList<FieldDescription.InDefinedShape> fields, MethodList<?> methods, int writerFlags, int readerFlags) {
        HashMap<String, Object> mappedAnnotations = new HashMap<String, Object>();
        if (this.type) {
            for (Object annotation : instrumentedType.getDeclaredAnnotations()) {
                mappedAnnotations.put(annotation.getAnnotationType().getDescriptor(), annotation);
            }
        }
        HashMap<String, FieldDescription.InDefinedShape> mappedFields = new HashMap<String, FieldDescription.InDefinedShape>();
        for (FieldDescription.InDefinedShape fieldDescription : fields) {
            mappedFields.put(fieldDescription.getInternalName() + fieldDescription.getDescriptor(), fieldDescription);
        }
        HashMap<String, MethodDescription> mappedMethods = new HashMap<String, MethodDescription>();
        for (MethodDescription methodDescription : CompoundList.of(methods, new MethodDescription.Latent.TypeInitializer(instrumentedType))) {
            mappedMethods.put(methodDescription.getInternalName() + methodDescription.getDescriptor(), methodDescription);
        }
        return new AnnotationRemovingClassVisitor(classVisitor, this.fieldMatcher, this.methodMatcher, this.annotationMatcher, this.parameters, mappedFields, mappedMethods, mappedAnnotations);
    }

    public boolean equals(@MaybeNull Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (this.type != ((AnnotationRemoval)object).type) {
            return false;
        }
        if (this.parameters != ((AnnotationRemoval)object).parameters) {
            return false;
        }
        if (!this.fieldMatcher.equals(((AnnotationRemoval)object).fieldMatcher)) {
            return false;
        }
        if (!this.methodMatcher.equals(((AnnotationRemoval)object).methodMatcher)) {
            return false;
        }
        return this.annotationMatcher.equals(((AnnotationRemoval)object).annotationMatcher);
    }

    public int hashCode() {
        return ((((this.getClass().hashCode() * 31 + this.type) * 31 + this.fieldMatcher.hashCode()) * 31 + this.methodMatcher.hashCode()) * 31 + this.annotationMatcher.hashCode()) * 31 + this.parameters;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AnnotationRemovingMethodVisitor
    extends MethodVisitor {
        private final ElementMatcher<? super AnnotationDescription> annotationMatcher;
        private final Map<Integer, Map<String, AnnotationDescription>> parameterAnnotations;
        private final Map<String, AnnotationDescription> annotations;

        private AnnotationRemovingMethodVisitor(MethodVisitor methodVisitor, ElementMatcher<? super AnnotationDescription> annotationMatcher, Map<Integer, Map<String, AnnotationDescription>> parameterAnnotations, Map<String, AnnotationDescription> annotations) {
            super(OpenedClassReader.ASM_API, methodVisitor);
            this.annotationMatcher = annotationMatcher;
            this.parameterAnnotations = parameterAnnotations;
            this.annotations = annotations;
        }

        @Override
        @MaybeNull
        public AnnotationVisitor visitParameterAnnotation(int parameter, String descriptor, boolean visible) {
            Map<String, AnnotationDescription> annotations = this.parameterAnnotations.get(parameter);
            if (annotations != null) {
                AnnotationDescription annotation = annotations.get(descriptor);
                return annotation != null && this.annotationMatcher.matches(annotation) ? null : super.visitParameterAnnotation(parameter, descriptor, visible);
            }
            return super.visitParameterAnnotation(parameter, descriptor, visible);
        }

        @Override
        @MaybeNull
        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            AnnotationDescription annotation = this.annotations.get(descriptor);
            return annotation != null && this.annotationMatcher.matches(annotation) ? null : super.visitAnnotation(descriptor, visible);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AnnotationRemovingFieldVisitor
    extends FieldVisitor {
        private final ElementMatcher<? super AnnotationDescription> annotationMatcher;
        private final Map<String, AnnotationDescription> annotations;

        private AnnotationRemovingFieldVisitor(FieldVisitor fieldVisitor, ElementMatcher<? super AnnotationDescription> annotationMatcher, Map<String, AnnotationDescription> annotations) {
            super(OpenedClassReader.ASM_API, fieldVisitor);
            this.annotationMatcher = annotationMatcher;
            this.annotations = annotations;
        }

        @Override
        @MaybeNull
        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            AnnotationDescription annotation = this.annotations.get(descriptor);
            return annotation != null && this.annotationMatcher.matches(annotation) ? null : super.visitAnnotation(descriptor, visible);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AnnotationRemovingClassVisitor
    extends ClassVisitor {
        private final ElementMatcher<? super FieldDescription.InDefinedShape> fieldMatcher;
        private final ElementMatcher<? super MethodDescription> methodMatcher;
        private final ElementMatcher<? super AnnotationDescription> annotationMatcher;
        private final int parameters;
        private final Map<String, FieldDescription.InDefinedShape> fields;
        private final Map<String, MethodDescription> methods;
        private final Map<String, AnnotationDescription> annotations;

        private AnnotationRemovingClassVisitor(ClassVisitor classVisitor, ElementMatcher<? super FieldDescription.InDefinedShape> fieldMatcher, ElementMatcher<? super MethodDescription> methodMatcher, ElementMatcher<? super AnnotationDescription> annotationMatcher, int parameters, Map<String, FieldDescription.InDefinedShape> fields, Map<String, MethodDescription> methods, Map<String, AnnotationDescription> annotations) {
            super(OpenedClassReader.ASM_API, classVisitor);
            this.fieldMatcher = fieldMatcher;
            this.methodMatcher = methodMatcher;
            this.annotationMatcher = annotationMatcher;
            this.parameters = parameters;
            this.fields = fields;
            this.methods = methods;
            this.annotations = annotations;
        }

        @Override
        @MaybeNull
        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            AnnotationDescription annotation = this.annotations.get(descriptor);
            return annotation != null && this.annotationMatcher.matches(annotation) ? null : super.visitAnnotation(descriptor, visible);
        }

        @Override
        @MaybeNull
        public FieldVisitor visitField(int modifiers, String internalName, String descriptor, String signature, Object value) {
            FieldVisitor fieldVisitor = super.visitField(modifiers, internalName, descriptor, signature, value);
            if (fieldVisitor == null) {
                return null;
            }
            FieldDescription.InDefinedShape fieldDescription = this.fields.get(internalName + descriptor);
            if (fieldDescription != null && this.fieldMatcher.matches(fieldDescription)) {
                HashMap<String, AnnotationDescription> mappedAnnotations = new HashMap<String, AnnotationDescription>();
                for (AnnotationDescription annotation : fieldDescription.getDeclaredAnnotations()) {
                    mappedAnnotations.put(annotation.getAnnotationType().getDescriptor(), annotation);
                }
                return new AnnotationRemovingFieldVisitor(fieldVisitor, this.annotationMatcher, mappedAnnotations);
            }
            return fieldVisitor;
        }

        @Override
        @MaybeNull
        public MethodVisitor visitMethod(int modifiers, String internalName, String descriptor, String signature, String[] exception) {
            MethodVisitor methodVisitor = super.visitMethod(modifiers, internalName, descriptor, signature, exception);
            if (methodVisitor == null) {
                return null;
            }
            MethodDescription methodDescription = this.methods.get(internalName + descriptor);
            if (methodDescription != null && this.methodMatcher.matches(methodDescription)) {
                HashMap mappedParameterAnnotations = new HashMap();
                if (this.parameters >= 0 || this.parameters == -1 || this.parameters == -3) {
                    for (ParameterDescription parameter : methodDescription.getParameters()) {
                        HashMap<String, AnnotationDescription> mappedAnnotations = new HashMap<String, AnnotationDescription>();
                        if (parameter.getIndex() == this.parameters || this.parameters < 0) {
                            for (AnnotationDescription annotation : parameter.getDeclaredAnnotations()) {
                                mappedAnnotations.put(annotation.getAnnotationType().getDescriptor(), annotation);
                            }
                        }
                        mappedParameterAnnotations.put(parameter.getIndex(), mappedAnnotations);
                    }
                }
                HashMap<String, AnnotationDescription> mappedAnnotations = new HashMap<String, AnnotationDescription>();
                if (this.parameters == -2 || this.parameters == -3) {
                    for (AnnotationDescription annotation : methodDescription.getDeclaredAnnotations()) {
                        mappedAnnotations.put(annotation.getAnnotationType().getDescriptor(), annotation);
                    }
                }
                return new AnnotationRemovingMethodVisitor(methodVisitor, this.annotationMatcher, mappedParameterAnnotations, mappedAnnotations);
            }
            return methodVisitor;
        }
    }
}

