/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.microsoft.sqlserver.jdbc;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.logging.Logger;
import javax.xml.bind.DatatypeConverter;
import org.apache.hadoop.shaded.com.microsoft.sqlserver.jdbc.AuthenticationJNI;
import org.apache.hadoop.shaded.com.microsoft.sqlserver.jdbc.CertificateDetails;
import org.apache.hadoop.shaded.com.microsoft.sqlserver.jdbc.DLLException;
import org.apache.hadoop.shaded.com.microsoft.sqlserver.jdbc.SQLServerColumnEncryptionKeyStoreProvider;
import org.apache.hadoop.shaded.com.microsoft.sqlserver.jdbc.SQLServerException;

public final class SQLServerColumnEncryptionCertificateStoreProvider
extends SQLServerColumnEncryptionKeyStoreProvider {
    private static final Logger windowsCertificateStoreLogger = Logger.getLogger("org.apache.hadoop.shaded.com.microsoft.sqlserver.jdbc.SQLServerColumnEncryptionCertificateStoreProvider");
    static boolean isWindows = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).startsWith("windows");
    String name = "MSSQL_CERTIFICATE_STORE";
    static final String localMachineDirectory = "LocalMachine";
    static final String currentUserDirectory = "CurrentUser";
    static final String myCertificateStore = "My";
    private Path keyStoreDirectoryPath = null;

    public SQLServerColumnEncryptionCertificateStoreProvider() {
        windowsCertificateStoreLogger.entering(SQLServerColumnEncryptionCertificateStoreProvider.class.getName(), "SQLServerColumnEncryptionCertificateStoreProvider");
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public byte[] encryptColumnEncryptionKey(String masterKeyPath, String encryptionAlgorithm, byte[] plainTextColumnEncryptionKey) throws SQLServerException {
        throw new SQLServerException(null, SQLServerException.getErrString("R_InvalidWindowsCertificateStoreEncryption"), null, 0, false);
    }

    private byte[] decryptColumnEncryptionKeyWindows(String masterKeyPath, String encryptionAlgorithm, byte[] encryptedColumnEncryptionKey) throws SQLServerException {
        try {
            return AuthenticationJNI.DecryptColumnEncryptionKey(masterKeyPath, encryptionAlgorithm, encryptedColumnEncryptionKey);
        }
        catch (DLLException e) {
            DLLException.buildException(e.GetErrCode(), e.GetParam1(), e.GetParam2(), e.GetParam3());
            return null;
        }
    }

    private CertificateDetails getCertificateDetails(String masterKeyPath) throws SQLServerException {
        String storeLocation = null;
        String[] certParts = masterKeyPath.split("/");
        if (certParts.length > 3) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_AECertpathBad"));
            Object[] msgArgs = new Object[]{masterKeyPath};
            throw new SQLServerException(form.format(msgArgs), null);
        }
        if (certParts.length > 2) {
            if (certParts[0].equalsIgnoreCase(localMachineDirectory)) {
                storeLocation = localMachineDirectory;
            } else if (certParts[0].equalsIgnoreCase(currentUserDirectory)) {
                storeLocation = currentUserDirectory;
            } else {
                MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_AECertLocBad"));
                Object[] msgArgs = new Object[]{certParts[0], masterKeyPath};
                throw new SQLServerException(form.format(msgArgs), null);
            }
        }
        if (certParts.length > 1 && !certParts[certParts.length - 2].equalsIgnoreCase(myCertificateStore)) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_AECertStoreBad"));
            Object[] msgArgs = new Object[]{certParts[certParts.length - 2], masterKeyPath};
            throw new SQLServerException(form.format(msgArgs), null);
        }
        String thumbprint = certParts[certParts.length - 1];
        if (null == thumbprint || 0 == thumbprint.length()) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_AECertHashEmpty"));
            Object[] msgArgs = new Object[]{masterKeyPath};
            throw new SQLServerException(form.format(msgArgs), null);
        }
        return this.getCertificateByThumbprint(storeLocation, thumbprint, masterKeyPath);
    }

    private String getThumbPrint(X509Certificate cert) throws NoSuchAlgorithmException, CertificateEncodingException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] der = cert.getEncoded();
        md.update(der);
        byte[] digest = md.digest();
        return DatatypeConverter.printHexBinary(digest);
    }

    private CertificateDetails getCertificateByThumbprint(String storeLocation, String thumbprint, String masterKeyPath) throws SQLServerException {
        if (null == this.keyStoreDirectoryPath) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_AEKeyPathEmptyOrReserved"));
            Object[] msgArgs = new Object[]{this.keyStoreDirectoryPath};
            throw new SQLServerException(form.format(msgArgs), null);
        }
        Path keyStoreFullPath = this.keyStoreDirectoryPath.resolve(storeLocation);
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance("PKCS12");
        }
        catch (KeyStoreException e) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_CertificateError"));
            Object[] msgArgs = new Object[]{masterKeyPath, this.name};
            throw new SQLServerException((Object)this, form.format(msgArgs), null, 0, false);
        }
        File keyStoreDirectory = keyStoreFullPath.toFile();
        File[] listOfFiles = keyStoreDirectory.listFiles();
        if (null == listOfFiles || 0 == listOfFiles.length) {
            throw new SQLServerException(SQLServerException.getErrString("R_KeyStoreNotFound"), null);
        }
        for (File f : listOfFiles) {
            if (f.isDirectory()) continue;
            char[] password = "".toCharArray();
            try {
                FileInputStream fis = new FileInputStream(f);
                keyStore.load(fis, password);
            }
            catch (IOException | NoSuchAlgorithmException | CertificateException e) {
                continue;
            }
            try {
                Enumeration<String> enumeration = keyStore.aliases();
                while (enumeration.hasMoreElements()) {
                    String alias = enumeration.nextElement();
                    X509Certificate publicCertificate = (X509Certificate)keyStore.getCertificate(alias);
                    if (!thumbprint.matches(this.getThumbPrint(publicCertificate))) continue;
                    Key keyPrivate = null;
                    try {
                        keyPrivate = keyStore.getKey(alias, "".toCharArray());
                        if (null == keyPrivate) {
                            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_UnrecoverableKeyAE"));
                            Object[] msgArgs = new Object[]{masterKeyPath};
                            throw new SQLServerException((Object)this, form.format(msgArgs), null, 0, false);
                        }
                    }
                    catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                        MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_UnrecoverableKeyAE"));
                        Object[] msgArgs = new Object[]{masterKeyPath};
                        throw new SQLServerException((Object)this, form.format(msgArgs), null, 0, false);
                    }
                    return new CertificateDetails(publicCertificate, keyPrivate);
                }
            }
            catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_CertificateError"));
                Object[] msgArgs = new Object[]{masterKeyPath, this.name};
                throw new SQLServerException(form.format(msgArgs), e);
            }
        }
        throw new SQLServerException(SQLServerException.getErrString("R_KeyStoreNotFound"), null);
    }

    @Override
    public byte[] decryptColumnEncryptionKey(String masterKeyPath, String encryptionAlgorithm, byte[] encryptedColumnEncryptionKey) throws SQLServerException {
        windowsCertificateStoreLogger.entering(SQLServerColumnEncryptionCertificateStoreProvider.class.getName(), "decryptColumnEncryptionKey", "Decrypting Column Encryption Key.");
        if (!isWindows) {
            throw new SQLServerException(SQLServerException.getErrString("R_notSupported"), null);
        }
        byte[] plainCek = this.decryptColumnEncryptionKeyWindows(masterKeyPath, encryptionAlgorithm, encryptedColumnEncryptionKey);
        windowsCertificateStoreLogger.exiting(SQLServerColumnEncryptionCertificateStoreProvider.class.getName(), "decryptColumnEncryptionKey", "Finished decrypting Column Encryption Key.");
        return plainCek;
    }
}

