/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.sink;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.metrics2.MetricsException;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.impl.ConfigBuilder;
import org.apache.hadoop.metrics2.impl.MetricsSystemImpl;
import org.apache.hadoop.metrics2.impl.TestMetricsConfig;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.metrics2.sink.RollingFileSystemSink;
import org.apache.hadoop.shaded.org.apache.commons.configuration2.SubsetConfiguration;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.TestName;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.RegisterExtension;

public class RollingFileSystemSinkTestBase {
    protected static final String SINK_PRINCIPAL_KEY = "rfssink.principal";
    protected static final String SINK_KEYTAB_FILE_KEY = "rfssink.keytab";
    protected static final File ROOT_TEST_DIR = GenericTestUtils.getTestDir("RollingFileSystemSinkTest");
    protected static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMddHH");
    protected static File methodDir;
    @RegisterExtension
    private TestName methodName = new TestName();

    @BeforeAll
    public static void setup() {
        DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
        FileUtil.fullyDelete((File)ROOT_TEST_DIR);
    }

    @AfterAll
    public static void deleteBaseDir() throws IOException {
        FileUtil.fullyDelete((File)ROOT_TEST_DIR);
    }

    @BeforeEach
    public void createMethodDir() throws IOException {
        methodDir = new File(ROOT_TEST_DIR, this.methodName.getMethodName());
        Assertions.assertTrue((boolean)methodDir.mkdirs(), (String)("Test directory already exists: " + methodDir));
    }

    protected MetricsSystem initMetricsSystem(String path, boolean ignoreErrors, boolean allowAppend) {
        return this.initMetricsSystem(path, ignoreErrors, allowAppend, false);
    }

    protected MetricsSystem initMetricsSystem(String path, boolean ignoreErrors, boolean allowAppend, boolean useSecureParams) {
        String prefix = this.methodName.getMethodName().toLowerCase();
        ConfigBuilder builder = new ConfigBuilder().add("*.period", 10000).add(prefix + ".sink.mysink0.class", MockSink.class.getName()).add(prefix + ".sink.mysink0.basepath", path).add(prefix + ".sink.mysink0.source", "testsrc").add(prefix + ".sink.mysink0.context", "test1").add(prefix + ".sink.mysink0.ignore-error", ignoreErrors).add(prefix + ".sink.mysink0.allow-append", allowAppend).add(prefix + ".sink.mysink0.roll-offset-interval-millis", 0).add(prefix + ".sink.mysink0.roll-interval", "1h").add("*.queue.capacity", 2);
        if (useSecureParams) {
            builder.add(prefix + ".sink.mysink0.keytab-key", SINK_KEYTAB_FILE_KEY).add(prefix + ".sink.mysink0.principal-key", SINK_PRINCIPAL_KEY);
        }
        builder.save(TestMetricsConfig.getTestFilename((String)("hadoop-metrics2-" + prefix)));
        MetricsSystemImpl ms = new MetricsSystemImpl(prefix);
        ms.start();
        return ms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doWriteTest(MetricsSystem ms, String path, int count) throws IOException, URISyntaxException {
        String then = DATE_FORMAT.format(new Date()) + "00";
        MyMetrics1 mm1 = new MyMetrics1().registerWith(ms);
        new MyMetrics2().registerWith(ms);
        mm1.testMetric1.incr();
        mm1.testMetric2.incr(2L);
        ms.publishMetricsNow();
        try {
            ms.stop();
        }
        finally {
            ms.shutdown();
        }
        return this.readLogFile(path, then, count);
    }

    protected String readLogFile(String path, String then, int count) throws IOException, URISyntaxException {
        String now = DATE_FORMAT.format(new Date()) + "00";
        String logFile = RollingFileSystemSinkTestBase.getLogFilename();
        FileSystem fs = FileSystem.get((URI)new URI(path), (Configuration)new Configuration());
        StringBuilder metrics = new StringBuilder();
        boolean found = false;
        for (FileStatus status : fs.listStatus(new Path(path))) {
            Path logDir = status.getPath();
            if (!now.equals(logDir.getName()) && !then.equals(logDir.getName())) continue;
            this.readLogData(fs, this.findMostRecentLogFile(fs, new Path(logDir, logFile)), metrics);
            this.assertFileCount(fs, logDir, count);
            found = true;
        }
        Assertions.assertTrue((boolean)found, (String)"No valid log directories found");
        return metrics.toString();
    }

    protected void readLogData(FileSystem fs, Path logFile, StringBuilder metrics) throws IOException {
        FSDataInputStream fsin = fs.open(logFile);
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)fsin, StandardCharsets.UTF_8));
        String line = null;
        while ((line = in.readLine()) != null) {
            metrics.append(line).append("\n");
        }
    }

    protected Path findMostRecentLogFile(FileSystem fs, Path initial) throws IOException {
        Path logFile = null;
        Path nextLogFile = initial;
        int id = 1;
        do {
            logFile = nextLogFile;
            nextLogFile = new Path(initial.toString() + "." + id);
            ++id;
        } while (fs.exists(nextLogFile));
        return logFile;
    }

    protected static String getLogFilename() throws UnknownHostException {
        return "testsrc-" + InetAddress.getLocalHost().getHostName() + ".log";
    }

    protected void assertMetricsContents(String contents) {
        Pattern expectedContentPattern = Pattern.compile("^\\d+\\s+test1.testRecord1:\\s+Context=test1,\\s+(testTag1=testTagValue1,\\s+testTag2=testTagValue2|testTag2=testTagValue2,\\s+testTag1=testTagValue1),\\s+Hostname=.*,\\s+(testMetric1=1,\\s+testMetric2=2|testMetric2=2,\\s+testMetric1=1)[\\n\\r]*^\\d+\\s+test1.testRecord2:\\s+Context=test1,\\s+testTag22=testTagValue22,\\s+Hostname=.*$[\\n\\r]*", 8);
        Assertions.assertTrue((boolean)expectedContentPattern.matcher(contents).matches(), (String)("Sink did not produce the expected output. Actual output was: " + contents));
    }

    protected void assertExtraContents(String contents) {
        Pattern expectedContentPattern = Pattern.compile("Extra stuff[\\n\\r]*^\\d+\\s+test1.testRecord1:\\s+Context=test1,\\s+(testTag1=testTagValue1,\\s+testTag2=testTagValue2|testTag2=testTagValue2,\\s+testTag1=testTagValue1),\\s+Hostname=.*,\\s+(testMetric1=1,\\s+testMetric2=2|testMetric2=2,\\s+testMetric1=1)[\\n\\r]*^\\d+\\s+test1.testRecord2:\\s+Context=test1,\\s+testTag22=testTagValue22,\\s+Hostname=.*$[\\n\\r]*", 8);
        Assertions.assertTrue((boolean)expectedContentPattern.matcher(contents).matches(), (String)("Sink did not produce the expected output. Actual output was: " + contents));
    }

    protected String doAppendTest(String path, boolean ignoreErrors, boolean allowAppend, int count) throws IOException, InterruptedException, URISyntaxException {
        this.preCreateLogFile(path);
        return this.doWriteTest(this.initMetricsSystem(path, ignoreErrors, allowAppend), path, count);
    }

    protected void preCreateLogFile(String path) throws IOException, InterruptedException, URISyntaxException {
        this.preCreateLogFile(path, 1);
    }

    protected void preCreateLogFile(String path, int numFiles) throws IOException, InterruptedException, URISyntaxException {
        Calendar now = this.getNowNotTopOfHour();
        FileSystem fs = FileSystem.get((URI)new URI(path), (Configuration)new Configuration());
        Path dir = new Path(path, DATE_FORMAT.format(now.getTime()) + "00");
        fs.mkdirs(dir);
        Path file = new Path(dir, RollingFileSystemSinkTestBase.getLogFilename());
        try (FSDataOutputStream out = fs.create(file);){
            out.write("Extra stuff\n".getBytes());
            out.flush();
        }
        if (numFiles > 1) {
            for (int count = 1; count < numFiles; ++count) {
                file = new Path(dir, RollingFileSystemSinkTestBase.getLogFilename() + "." + count);
                try (FSDataOutputStream out = fs.create(file);){
                    out.write("Extra stuff\n".getBytes());
                    out.flush();
                    continue;
                }
            }
        }
    }

    public Calendar getNowNotTopOfHour() throws InterruptedException {
        Calendar now = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        if (now.get(12) == 59 && now.get(13) > 40) {
            Thread.sleep((long)(61 - now.get(13)) * 1000L);
            now.setTime(new Date());
        }
        return now;
    }

    public void assertFileCount(FileSystem fs, Path dir, int expected) throws IOException {
        RemoteIterator i = fs.listFiles(dir, true);
        int count = 0;
        while (i.hasNext()) {
            i.next();
            ++count;
        }
        Assertions.assertTrue((expected >= count ? 1 : 0) != 0, (String)("The sink created additional unexpected log files. " + count + " files were created"));
        Assertions.assertTrue((expected <= count ? 1 : 0) != 0, (String)("The sink created too few log files. " + count + " files were created"));
    }

    public static class MockSink
    extends RollingFileSystemSink {
        public static volatile boolean errored = false;
        public static volatile boolean initialized = false;

        public void init(SubsetConfiguration conf) {
            try {
                super.init(conf);
            }
            catch (MetricsException ex) {
                errored = true;
                throw new MetricsException((Throwable)ex);
            }
            initialized = true;
        }

        public void putMetrics(MetricsRecord record) {
            try {
                super.putMetrics(record);
            }
            catch (MetricsException ex) {
                errored = true;
                throw new MetricsException((Throwable)ex);
            }
        }

        public void close() {
            try {
                super.close();
            }
            catch (MetricsException ex) {
                errored = true;
                throw new MetricsException((Throwable)ex);
            }
        }

        public void flush() {
            try {
                super.flush();
            }
            catch (MetricsException ex) {
                errored = true;
                throw new MetricsException((Throwable)ex);
            }
        }
    }

    @Metrics(name="testRecord1", context="test1")
    protected class MyMetrics1 {
        @Metric(value={"testMetric1", "An integer gauge"}, always=true)
        MutableGaugeInt testMetric1;
        @Metric(value={"testMetric2", "A long gauge"}, always=true)
        MutableGaugeLong testMetric2;

        protected MyMetrics1() {
        }

        @Metric(value={"testTag1", ""}, type=Metric.Type.TAG)
        String testTag1() {
            return "testTagValue1";
        }

        @Metric(value={"testTag2", ""}, type=Metric.Type.TAG)
        String gettestTag2() {
            return "testTagValue2";
        }

        public MyMetrics1 registerWith(MetricsSystem ms) {
            return (MyMetrics1)ms.register(RollingFileSystemSinkTestBase.this.methodName.getMethodName() + "-m1", null, (Object)this);
        }
    }

    @Metrics(name="testRecord2", context="test1")
    protected class MyMetrics2 {
        protected MyMetrics2() {
        }

        @Metric(value={"testTag22", ""}, type=Metric.Type.TAG)
        String testTag1() {
            return "testTagValue22";
        }

        public MyMetrics2 registerWith(MetricsSystem ms) {
            return (MyMetrics2)ms.register(RollingFileSystemSinkTestBase.this.methodName.getMethodName() + "-m2", null, (Object)this);
        }
    }
}

