/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.ipc.RetriableException;
import org.apache.hadoop.mapred.JobACLsManager;
import org.apache.hadoop.mapreduce.jobhistory.JobSummary;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.hs.CompletedJob;
import org.apache.hadoop.mapreduce.v2.hs.UnparsedJob;
import org.apache.hadoop.mapreduce.v2.jobhistory.FileNameIndexUtils;
import org.apache.hadoop.mapreduce.v2.jobhistory.JobHistoryUtils;
import org.apache.hadoop.mapreduce.v2.jobhistory.JobIndexInfo;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hadoop.util.ShutdownThreadsHelper;
import org.apache.hadoop.util.concurrent.HadoopThreadPoolExecutor;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class HistoryFileManager
extends AbstractService {
    private static final Logger LOG = LoggerFactory.getLogger(HistoryFileManager.class);
    private static final Logger SUMMARY_LOG = LoggerFactory.getLogger(JobSummary.class);
    private static String DONE_BEFORE_SERIAL_TAIL = JobHistoryUtils.doneSubdirsBeforeSerialTail();
    private SerialNumberIndex serialNumberIndex = null;
    protected JobListCache jobListCache = null;
    private final Set<Path> existingDoneSubdirs = Collections.synchronizedSet(new HashSet());
    private ConcurrentMap<String, UserLogDir> userDirModificationTimeMap = new ConcurrentHashMap<String, UserLogDir>();
    private JobACLsManager aclsMgr;
    @VisibleForTesting
    Configuration conf;
    private String serialNumberFormat;
    private Path doneDirPrefixPath = null;
    private FileContext doneDirFc;
    private Path intermediateDoneDirPath = null;
    private FileContext intermediateDoneDirFc;
    @VisibleForTesting
    protected ThreadPoolExecutor moveToDoneExecutor = null;
    private long maxHistoryAge = 0L;
    private int maxTasksForLoadedJob = -1;

    public HistoryFileManager() {
        super(HistoryFileManager.class.getName());
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.conf = conf;
        int serialNumberLowDigits = 3;
        this.serialNumberFormat = "%0" + (6 + serialNumberLowDigits) + "d";
        long maxFSWaitTime = conf.getLong("mapreduce.jobhistory.maximum-start-wait-time-millis", -1L);
        this.createHistoryDirs((Clock)SystemClock.getInstance(), 10000L, maxFSWaitTime);
        this.maxTasksForLoadedJob = conf.getInt("mapreduce.jobhistory.loadedjob.tasks.max", -1);
        this.aclsMgr = new JobACLsManager(conf);
        this.maxHistoryAge = conf.getLong("mapreduce.jobhistory.max-age-ms", 604800000L);
        this.jobListCache = this.createJobListCache();
        this.serialNumberIndex = new SerialNumberIndex(conf.getInt("mapreduce.jobhistory.datestring.cache.size", 200000));
        int numMoveThreads = conf.getInt("mapreduce.jobhistory.move.thread-count", 3);
        this.moveToDoneExecutor = this.createMoveToDoneThreadPool(numMoveThreads);
        super.serviceInit(conf);
    }

    protected ThreadPoolExecutor createMoveToDoneThreadPool(int numMoveThreads) {
        ThreadFactory tf = new ThreadFactoryBuilder().setNameFormat("MoveIntermediateToDone Thread #%d").build();
        return new HadoopThreadPoolExecutor(numMoveThreads, numMoveThreads, 1L, TimeUnit.HOURS, new LinkedBlockingQueue(), tf);
    }

    @VisibleForTesting
    void createHistoryDirs(Clock clock, long intervalCheckMillis, long timeOutMillis) throws IOException {
        long start = clock.getTime();
        boolean done = false;
        int counter = 0;
        while (!(done || timeOutMillis != -1L && clock.getTime() - start >= timeOutMillis || (done = this.tryCreatingHistoryDirs(counter++ % 3 == 0)))) {
            try {
                Thread.sleep(intervalCheckMillis);
            }
            catch (InterruptedException ex) {
                throw new YarnRuntimeException((Throwable)ex);
            }
        }
        if (!done) {
            throw new YarnRuntimeException("Timed out '" + timeOutMillis + "ms' waiting for FileSystem to become available");
        }
    }

    private boolean isNameNodeStillNotStarted(Exception ex) {
        String nameNodeNotStartedMsg = NameNode.composeNotStartedMessage(HdfsServerConstants.NamenodeRole.NAMENODE);
        return ex.toString().contains("SafeModeException") || ex instanceof RetriableException && ex.getMessage().contains(nameNodeNotStartedMsg);
    }

    @VisibleForTesting
    boolean tryCreatingHistoryDirs(boolean logWait) throws IOException {
        boolean succeeded = true;
        String doneDirPrefix = JobHistoryUtils.getConfiguredHistoryServerDoneDirPrefix((Configuration)this.conf);
        try {
            this.doneDirPrefixPath = FileContext.getFileContext((Configuration)this.conf).makeQualified(new Path(doneDirPrefix));
            this.doneDirFc = FileContext.getFileContext((URI)this.doneDirPrefixPath.toUri(), (Configuration)this.conf);
            this.doneDirFc.setUMask(JobHistoryUtils.HISTORY_DONE_DIR_UMASK);
            this.mkdir(this.doneDirFc, this.doneDirPrefixPath, new FsPermission(JobHistoryUtils.HISTORY_DONE_DIR_PERMISSION));
        }
        catch (ConnectException ex) {
            if (logWait) {
                LOG.info("Waiting for FileSystem at " + this.doneDirPrefixPath.toUri().getAuthority() + "to be available");
            }
            succeeded = false;
        }
        catch (IOException e) {
            if (this.isNameNodeStillNotStarted(e)) {
                succeeded = false;
                if (logWait) {
                    LOG.info("Waiting for FileSystem at " + this.doneDirPrefixPath.toUri().getAuthority() + "to be out of safe mode");
                }
            }
            throw new YarnRuntimeException("Error creating done directory: [" + this.doneDirPrefixPath + "]", (Throwable)e);
        }
        if (succeeded) {
            String intermediateDoneDirPrefix = JobHistoryUtils.getConfiguredHistoryIntermediateDoneDirPrefix((Configuration)this.conf);
            try {
                this.intermediateDoneDirPath = FileContext.getFileContext((Configuration)this.conf).makeQualified(new Path(intermediateDoneDirPrefix));
                this.intermediateDoneDirFc = FileContext.getFileContext((URI)this.intermediateDoneDirPath.toUri(), (Configuration)this.conf);
                this.mkdir(this.intermediateDoneDirFc, this.intermediateDoneDirPath, new FsPermission(JobHistoryUtils.HISTORY_INTERMEDIATE_DONE_DIR_PERMISSIONS.toShort()));
            }
            catch (ConnectException ex) {
                succeeded = false;
                if (logWait) {
                    LOG.info("Waiting for FileSystem at " + this.intermediateDoneDirPath.toUri().getAuthority() + "to be available");
                }
            }
            catch (IOException e) {
                if (this.isNameNodeStillNotStarted(e)) {
                    succeeded = false;
                    if (logWait) {
                        LOG.info("Waiting for FileSystem at " + this.intermediateDoneDirPath.toUri().getAuthority() + "to be out of safe mode");
                    }
                }
                throw new YarnRuntimeException("Error creating intermediate done directory: [" + this.intermediateDoneDirPath + "]", (Throwable)e);
            }
        }
        return succeeded;
    }

    public void serviceStop() throws Exception {
        ShutdownThreadsHelper.shutdownExecutorService((ExecutorService)this.moveToDoneExecutor);
        super.serviceStop();
    }

    protected JobListCache createJobListCache() {
        return new JobListCache(this.conf.getInt("mapreduce.jobhistory.joblist.cache.size", 20000), this.maxHistoryAge);
    }

    private void mkdir(FileContext fc, Path path, FsPermission fsp) throws IOException {
        if (!fc.util().exists(path)) {
            try {
                fc.mkdir(path, fsp, true);
                FileStatus fsStatus = fc.getFileStatus(path);
                LOG.info("Perms after creating " + fsStatus.getPermission().toShort() + ", Expected: " + fsp.toShort());
                if (fsStatus.getPermission().toShort() != fsp.toShort()) {
                    LOG.info("Explicitly setting permissions to : " + fsp.toShort() + ", " + fsp);
                    fc.setPermission(path, fsp);
                }
            }
            catch (FileAlreadyExistsException e) {
                LOG.info("Directory: [" + path + "] already exists.");
            }
        }
    }

    protected HistoryFileInfo createHistoryFileInfo(Path historyFile, Path confFile, Path summaryFile, JobIndexInfo jobIndexInfo, boolean isInDone) {
        return new HistoryFileInfo(historyFile, confFile, summaryFile, jobIndexInfo, isInDone);
    }

    void initExisting() throws IOException {
        LOG.info("Initializing Existing Jobs...");
        List<FileStatus> timestampedDirList = this.findTimestampedDirectories();
        Collections.sort(timestampedDirList);
        LOG.info("Found " + timestampedDirList.size() + " directories to load");
        for (FileStatus fs : timestampedDirList) {
            this.addDirectoryToSerialNumberIndex(fs.getPath());
        }
        double maxCacheSize = this.jobListCache.maxSize;
        int prevCacheSize = this.jobListCache.size();
        for (int i = timestampedDirList.size() - 1; i >= 0 && !this.jobListCache.isFull(); --i) {
            FileStatus fs = timestampedDirList.get(i);
            this.addDirectoryToJobListCache(fs.getPath());
            int currCacheSize = this.jobListCache.size();
            if ((double)(currCacheSize - prevCacheSize) / maxCacheSize >= 0.05) {
                LOG.info((double)currCacheSize * 100.0 / maxCacheSize + "% of cache is loaded.");
            }
            prevCacheSize = currCacheSize;
        }
        double loadedPercent = maxCacheSize == 0.0 ? 100.0 : (double)prevCacheSize * 100.0 / maxCacheSize;
        LOG.info("Existing job initialization finished. " + loadedPercent + "% of cache is occupied.");
    }

    private void removeDirectoryFromSerialNumberIndex(Path serialDirPath) {
        String serialPart = serialDirPath.getName();
        String timeStampPart = JobHistoryUtils.getTimestampPartFromPath((String)serialDirPath.toString());
        if (timeStampPart == null) {
            LOG.warn("Could not find timestamp portion from path: " + serialDirPath.toString() + ". Continuing with next");
            return;
        }
        if (serialPart == null) {
            LOG.warn("Could not find serial portion from path: " + serialDirPath.toString() + ". Continuing with next");
            return;
        }
        this.serialNumberIndex.remove(serialPart, timeStampPart);
    }

    private void addDirectoryToSerialNumberIndex(Path serialDirPath) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding " + serialDirPath + " to serial index");
        }
        String serialPart = serialDirPath.getName();
        String timestampPart = JobHistoryUtils.getTimestampPartFromPath((String)serialDirPath.toString());
        if (timestampPart == null) {
            LOG.warn("Could not find timestamp portion from path: " + serialDirPath + ". Continuing with next");
            return;
        }
        if (serialPart == null) {
            LOG.warn("Could not find serial portion from path: " + serialDirPath.toString() + ". Continuing with next");
        } else {
            this.serialNumberIndex.add(serialPart, timestampPart);
        }
    }

    private void addDirectoryToJobListCache(Path path) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding " + path + " to job list cache.");
        }
        List<FileStatus> historyFileList = this.scanDirectoryForHistoryFiles(path, this.doneDirFc);
        for (FileStatus fs : historyFileList) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding in history for " + fs.getPath());
            }
            JobIndexInfo jobIndexInfo = FileNameIndexUtils.getIndexInfo((String)fs.getPath().getName());
            String confFileName = JobHistoryUtils.getIntermediateConfFileName((JobId)jobIndexInfo.getJobId());
            String summaryFileName = JobHistoryUtils.getIntermediateSummaryFileName((JobId)jobIndexInfo.getJobId());
            HistoryFileInfo fileInfo = this.createHistoryFileInfo(fs.getPath(), new Path(fs.getPath().getParent(), confFileName), new Path(fs.getPath().getParent(), summaryFileName), jobIndexInfo, true);
            this.jobListCache.addIfAbsent(fileInfo);
        }
    }

    @VisibleForTesting
    protected static List<FileStatus> scanDirectory(Path path, FileContext fc, PathFilter pathFilter) throws IOException {
        path = fc.makeQualified(path);
        ArrayList<FileStatus> jhStatusList = new ArrayList<FileStatus>();
        try {
            RemoteIterator fileStatusIter = fc.listStatus(path);
            while (fileStatusIter.hasNext()) {
                FileStatus fileStatus = (FileStatus)fileStatusIter.next();
                Path filePath = fileStatus.getPath();
                if (!fileStatus.isFile() || !pathFilter.accept(filePath)) continue;
                jhStatusList.add(fileStatus);
            }
        }
        catch (FileNotFoundException fe) {
            LOG.error("Error while scanning directory " + path, (Throwable)fe);
        }
        return jhStatusList;
    }

    protected List<FileStatus> scanDirectoryForHistoryFiles(Path path, FileContext fc) throws IOException {
        return HistoryFileManager.scanDirectory(path, fc, JobHistoryUtils.getHistoryFileFilter());
    }

    protected List<FileStatus> findTimestampedDirectories() throws IOException {
        List fsList = JobHistoryUtils.localGlobber((FileContext)this.doneDirFc, (Path)this.doneDirPrefixPath, (String)DONE_BEFORE_SERIAL_TAIL);
        return fsList;
    }

    void scanIntermediateDirectory() throws IOException {
        if (UserGroupInformation.isSecurityEnabled()) {
            UserGroupInformation.getLoginUser().checkTGTAndReloginFromKeytab();
        }
        List userDirList = JobHistoryUtils.localGlobber((FileContext)this.intermediateDoneDirFc, (Path)this.intermediateDoneDirPath, (String)"");
        LOG.debug("Scanning intermediate dirs");
        for (FileStatus userDir : userDirList) {
            UserLogDir old;
            String name = userDir.getPath().getName();
            UserLogDir dir = (UserLogDir)this.userDirModificationTimeMap.get(name);
            if (dir == null && (old = this.userDirModificationTimeMap.putIfAbsent(name, dir = new UserLogDir())) != null) {
                dir = old;
            }
            dir.scanIfNeeded(userDir);
        }
    }

    private void scanIntermediateDirectory(Path absPath) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scanning intermediate dir " + absPath);
        }
        List<FileStatus> fileStatusList = this.scanDirectoryForHistoryFiles(absPath, this.intermediateDoneDirFc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found " + fileStatusList.size() + " files");
        }
        for (FileStatus fs : fileStatusList) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("scanning file: " + fs.getPath());
            }
            JobIndexInfo jobIndexInfo = FileNameIndexUtils.getIndexInfo((String)fs.getPath().getName());
            String confFileName = JobHistoryUtils.getIntermediateConfFileName((JobId)jobIndexInfo.getJobId());
            String summaryFileName = JobHistoryUtils.getIntermediateSummaryFileName((JobId)jobIndexInfo.getJobId());
            HistoryFileInfo fileInfo = this.createHistoryFileInfo(fs.getPath(), new Path(fs.getPath().getParent(), confFileName), new Path(fs.getPath().getParent(), summaryFileName), jobIndexInfo, false);
            HistoryFileInfo old = this.jobListCache.addIfAbsent(fileInfo);
            if (old == null || old.didMoveFail()) {
                final HistoryFileInfo found = old == null ? fileInfo : old;
                long cutoff = System.currentTimeMillis() - this.maxHistoryAge;
                if (found.getJobIndexInfo().getFinishTime() <= cutoff) {
                    try {
                        found.delete();
                    }
                    catch (IOException e) {
                        LOG.warn("Error cleaning up a HistoryFile that is out of date.", (Throwable)e);
                    }
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Scheduling move to done of " + found);
                }
                this.moveToDoneExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            found.moveToDone();
                        }
                        catch (IOException e) {
                            LOG.info("Failed to process fileInfo for job: " + found.getJobId(), (Throwable)e);
                        }
                    }
                });
                continue;
            }
            if (old.isMovePending()) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Duplicate: deleting");
            }
            fileInfo.delete();
        }
    }

    private HistoryFileInfo getJobFileInfo(List<FileStatus> fileStatusList, JobId jobId) throws IOException {
        for (FileStatus fs : fileStatusList) {
            JobIndexInfo jobIndexInfo = FileNameIndexUtils.getIndexInfo((String)fs.getPath().getName());
            if (!jobIndexInfo.getJobId().equals((Object)jobId)) continue;
            String confFileName = JobHistoryUtils.getIntermediateConfFileName((JobId)jobIndexInfo.getJobId());
            String summaryFileName = JobHistoryUtils.getIntermediateSummaryFileName((JobId)jobIndexInfo.getJobId());
            HistoryFileInfo fileInfo = this.createHistoryFileInfo(fs.getPath(), new Path(fs.getPath().getParent(), confFileName), new Path(fs.getPath().getParent(), summaryFileName), jobIndexInfo, true);
            return fileInfo;
        }
        return null;
    }

    private HistoryFileInfo scanOldDirsForJob(JobId jobId) throws IOException {
        String boxedSerialNumber = JobHistoryUtils.serialNumberDirectoryComponent((JobId)jobId, (String)this.serialNumberFormat);
        Set<String> dateStringSet = this.serialNumberIndex.get(boxedSerialNumber);
        if (dateStringSet == null) {
            return null;
        }
        for (String timestampPart : dateStringSet) {
            Path logDir = this.canonicalHistoryLogPath(jobId, timestampPart);
            List<FileStatus> fileStatusList = this.scanDirectoryForHistoryFiles(logDir, this.doneDirFc);
            HistoryFileInfo fileInfo = this.getJobFileInfo(fileStatusList, jobId);
            if (fileInfo == null) continue;
            return fileInfo;
        }
        return null;
    }

    public Collection<HistoryFileInfo> getAllFileInfo() throws IOException {
        this.scanIntermediateDirectory();
        return this.jobListCache.values();
    }

    public HistoryFileInfo getFileInfo(JobId jobId) throws IOException {
        HistoryFileInfo fileInfo = this.jobListCache.get(jobId);
        if (fileInfo != null) {
            return fileInfo;
        }
        this.scanIntermediateDirectory();
        fileInfo = this.jobListCache.get(jobId);
        if (fileInfo != null) {
            return fileInfo;
        }
        fileInfo = this.scanOldDirsForJob(jobId);
        if (fileInfo != null) {
            return fileInfo;
        }
        return null;
    }

    private void moveToDoneNow(Path src, Path target) throws IOException {
        LOG.info("Moving " + src.toString() + " to " + target.toString());
        try {
            this.intermediateDoneDirFc.rename(src, target, new Options.Rename[]{Options.Rename.NONE});
        }
        catch (FileNotFoundException e) {
            if (this.doneDirFc.util().exists(target)) {
                LOG.info("Source file " + src.toString() + " not found, but target file " + target.toString() + " already exists. Move already happened.");
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getJobSummary(FileContext fc, Path path) throws IOException {
        Path qPath = fc.makeQualified(path);
        String jobSummaryString = null;
        try (FSDataInputStream in = null;){
            in = fc.open(qPath);
            jobSummaryString = in.readUTF();
        }
        return jobSummaryString;
    }

    private void makeDoneSubdir(Path path) throws IOException {
        try {
            this.doneDirFc.getFileStatus(path);
            this.existingDoneSubdirs.add(path);
        }
        catch (FileNotFoundException fnfE) {
            try {
                FsPermission fsp = new FsPermission(JobHistoryUtils.HISTORY_DONE_DIR_PERMISSION);
                this.doneDirFc.mkdir(path, fsp, true);
                FileStatus fsStatus = this.doneDirFc.getFileStatus(path);
                LOG.info("Perms after creating " + fsStatus.getPermission().toShort() + ", Expected: " + fsp.toShort());
                if (fsStatus.getPermission().toShort() != fsp.toShort()) {
                    LOG.info("Explicitly setting permissions to : " + fsp.toShort() + ", " + fsp);
                    this.doneDirFc.setPermission(path, fsp);
                }
                this.existingDoneSubdirs.add(path);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
        }
    }

    private Path canonicalHistoryLogPath(JobId id, String timestampComponent) {
        return new Path(this.doneDirPrefixPath, JobHistoryUtils.historyLogSubdirectory((JobId)id, (String)timestampComponent, (String)this.serialNumberFormat));
    }

    private Path canonicalHistoryLogPath(JobId id, long millisecondTime) {
        String timestampComponent = JobHistoryUtils.timestampDirectoryComponent((long)millisecondTime);
        return new Path(this.doneDirPrefixPath, JobHistoryUtils.historyLogSubdirectory((JobId)id, (String)timestampComponent, (String)this.serialNumberFormat));
    }

    private long getEffectiveTimestamp(long finishTime, FileStatus fileStatus) {
        if (finishTime == 0L) {
            return fileStatus.getModificationTime();
        }
        return finishTime;
    }

    private void deleteJobFromDone(HistoryFileInfo fileInfo) throws IOException {
        this.jobListCache.delete(fileInfo);
        fileInfo.delete();
    }

    List<FileStatus> getHistoryDirsForCleaning(long cutoff) throws IOException {
        return JobHistoryUtils.getHistoryDirsForCleaning((FileContext)this.doneDirFc, (Path)this.doneDirPrefixPath, (long)cutoff);
    }

    void clean() throws IOException {
        long cutoff = System.currentTimeMillis() - this.maxHistoryAge;
        boolean halted = false;
        List<FileStatus> serialDirList = this.getHistoryDirsForCleaning(cutoff);
        Collections.sort(serialDirList);
        for (FileStatus serialDir : serialDirList) {
            List<FileStatus> historyFileList = this.scanDirectoryForHistoryFiles(serialDir.getPath(), this.doneDirFc);
            for (FileStatus historyFile : historyFileList) {
                JobIndexInfo jobIndexInfo = FileNameIndexUtils.getIndexInfo((String)historyFile.getPath().getName());
                long effectiveTimestamp = this.getEffectiveTimestamp(jobIndexInfo.getFinishTime(), historyFile);
                if (effectiveTimestamp <= cutoff) {
                    HistoryFileInfo fileInfo = this.jobListCache.get(jobIndexInfo.getJobId());
                    if (fileInfo == null) {
                        String confFileName = JobHistoryUtils.getIntermediateConfFileName((JobId)jobIndexInfo.getJobId());
                        fileInfo = this.createHistoryFileInfo(historyFile.getPath(), new Path(historyFile.getPath().getParent(), confFileName), null, jobIndexInfo, true);
                    }
                    this.deleteJobFromDone(fileInfo);
                    continue;
                }
                halted = true;
                break;
            }
            if (halted) break;
            this.deleteDir(serialDir);
            this.removeDirectoryFromSerialNumberIndex(serialDir.getPath());
            this.existingDoneSubdirs.remove(serialDir.getPath());
        }
    }

    protected boolean deleteDir(FileStatus serialDir) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        return this.doneDirFc.delete(this.doneDirFc.makeQualified(serialDir.getPath()), true);
    }

    @VisibleForTesting
    void setMaxHistoryAge(long newValue) {
        this.maxHistoryAge = newValue;
    }

    private static class SerialNumberIndex {
        private SortedMap<String, Set<String>> cache = new TreeMap<String, Set<String>>();
        private int maxSize;

        public SerialNumberIndex(int maxSize) {
            this.maxSize = maxSize;
        }

        public synchronized void add(String serialPart, String timestampPart) {
            if (!this.cache.containsKey(serialPart)) {
                this.cache.put(serialPart, new HashSet());
                if (this.cache.size() > this.maxSize) {
                    String key = this.cache.firstKey();
                    LOG.error("Dropping " + key + " from the SerialNumberIndex. We will no longer be able to see jobs that are in that serial index for " + this.cache.get(key));
                    this.cache.remove(key);
                }
            }
            Set datePartSet = (Set)this.cache.get(serialPart);
            datePartSet.add(timestampPart);
        }

        public synchronized void remove(String serialPart, String timeStampPart) {
            if (this.cache.containsKey(serialPart)) {
                Set set = (Set)this.cache.get(serialPart);
                set.remove(timeStampPart);
                if (set.isEmpty()) {
                    this.cache.remove(serialPart);
                }
            }
        }

        public synchronized Set<String> get(String serialPart) {
            Set found = (Set)this.cache.get(serialPart);
            if (found != null) {
                return new HashSet<String>(found);
            }
            return null;
        }
    }

    static class JobListCache {
        private JobIdHistoryFileInfoMap cache;
        private int maxSize;
        private long maxAge;

        public JobListCache(int maxSize, long maxAge) {
            this.maxSize = maxSize;
            this.maxAge = maxAge;
            this.cache = new JobIdHistoryFileInfoMap();
        }

        public HistoryFileInfo addIfAbsent(HistoryFileInfo fileInfo) {
            JobId jobId = fileInfo.getJobId();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding " + jobId + " to job list cache with " + fileInfo.getJobIndexInfo());
            }
            HistoryFileInfo old = this.cache.putIfAbsent(jobId, fileInfo);
            if (this.cache.size() > this.maxSize) {
                Iterator<JobId> keys = this.cache.navigableKeySet().iterator();
                long cutoff = System.currentTimeMillis() - this.maxAge;
                JobId firstInIntermediateKey = null;
                int inIntermediateCount = 0;
                JobId firstMoveFailedKey = null;
                int moveFailedCount = 0;
                while (this.cache.size() > this.maxSize && keys.hasNext()) {
                    JobId key = keys.next();
                    HistoryFileInfo firstValue = this.cache.get(key);
                    if (firstValue == null) continue;
                    if (firstValue.isMovePending()) {
                        if (firstValue.didMoveFail() && firstValue.jobIndexInfo.getFinishTime() <= cutoff) {
                            this.cache.remove(key);
                            try {
                                firstValue.delete();
                            }
                            catch (IOException e) {
                                LOG.error("Error while trying to delete history files that could not be moved to done.", (Throwable)e);
                            }
                            continue;
                        }
                        if (firstValue.didMoveFail()) {
                            if (moveFailedCount == 0) {
                                firstMoveFailedKey = key;
                            }
                            ++moveFailedCount;
                            continue;
                        }
                        if (inIntermediateCount == 0) {
                            firstInIntermediateKey = key;
                        }
                        ++inIntermediateCount;
                        continue;
                    }
                    this.cache.remove(key);
                }
                if (inIntermediateCount > 0) {
                    LOG.warn("Waiting to remove IN_INTERMEDIATE state histories (e.g. " + firstInIntermediateKey + ") from JobListCache because it is not in done yet. Total count is " + inIntermediateCount + ".");
                }
                if (moveFailedCount > 0) {
                    LOG.warn("Waiting to remove MOVE_FAILED state histories (e.g. " + firstMoveFailedKey + ") from JobListCache because it is not in done yet. Total count is " + moveFailedCount + ".");
                }
            }
            return old;
        }

        public void delete(HistoryFileInfo fileInfo) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Removing from cache " + fileInfo);
            }
            this.cache.remove(fileInfo.getJobId());
        }

        public Collection<HistoryFileInfo> values() {
            return new ArrayList<HistoryFileInfo>(this.cache.values());
        }

        public HistoryFileInfo get(JobId jobId) {
            return this.cache.get(jobId);
        }

        public boolean isFull() {
            return this.cache.size() >= this.maxSize;
        }

        public int size() {
            return this.cache.size();
        }
    }

    public class HistoryFileInfo {
        private Path historyFile;
        private Path confFile;
        private Path summaryFile;
        private JobIndexInfo jobIndexInfo;
        private volatile HistoryInfoState state;

        @VisibleForTesting
        protected HistoryFileInfo(Path historyFile, Path confFile, Path summaryFile, JobIndexInfo jobIndexInfo, boolean isInDone) {
            this.historyFile = historyFile;
            this.confFile = confFile;
            this.summaryFile = summaryFile;
            this.jobIndexInfo = jobIndexInfo;
            this.state = isInDone ? HistoryInfoState.IN_DONE : HistoryInfoState.IN_INTERMEDIATE;
        }

        @VisibleForTesting
        boolean isMovePending() {
            return this.state == HistoryInfoState.IN_INTERMEDIATE || this.state == HistoryInfoState.MOVE_FAILED;
        }

        @VisibleForTesting
        boolean didMoveFail() {
            return this.state == HistoryInfoState.MOVE_FAILED;
        }

        public boolean isDeleted() {
            return this.state == HistoryInfoState.DELETED;
        }

        public String toString() {
            return "HistoryFileInfo jobID " + this.getJobId() + " historyFile = " + this.historyFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @VisibleForTesting
        synchronized void moveToDone() throws IOException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("moveToDone: " + this.historyFile);
            }
            if (!this.isMovePending()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Move no longer pending");
                }
                return;
            }
            try {
                Path toPath;
                long completeTime = this.jobIndexInfo.getFinishTime();
                if (completeTime == 0L) {
                    completeTime = System.currentTimeMillis();
                }
                JobId jobId = this.jobIndexInfo.getJobId();
                if (this.historyFile == null) {
                    LOG.info("No file for job-history with " + jobId + " found in cache!");
                }
                if (this.confFile == null) {
                    LOG.info("No file for jobConf with " + jobId + " found in cache!");
                }
                if (this.summaryFile == null || !HistoryFileManager.this.intermediateDoneDirFc.util().exists(this.summaryFile)) {
                    LOG.info("No summary file for job: " + jobId);
                } else {
                    String jobSummaryString = HistoryFileManager.this.getJobSummary(HistoryFileManager.this.intermediateDoneDirFc, this.summaryFile);
                    SUMMARY_LOG.info(jobSummaryString);
                    LOG.info("Deleting JobSummary file: [" + this.summaryFile + "]");
                    HistoryFileManager.this.intermediateDoneDirFc.delete(this.summaryFile, false);
                    this.summaryFile = null;
                }
                Path targetDir = HistoryFileManager.this.canonicalHistoryLogPath(jobId, completeTime);
                HistoryFileManager.this.addDirectoryToSerialNumberIndex(targetDir);
                HistoryFileManager.this.makeDoneSubdir(targetDir);
                if (this.historyFile != null && !(toPath = HistoryFileManager.this.doneDirFc.makeQualified(new Path(targetDir, this.historyFile.getName()))).equals((Object)this.historyFile)) {
                    HistoryFileManager.this.moveToDoneNow(this.historyFile, toPath);
                    this.historyFile = toPath;
                }
                if (this.confFile != null && !(toPath = HistoryFileManager.this.doneDirFc.makeQualified(new Path(targetDir, this.confFile.getName()))).equals((Object)this.confFile)) {
                    HistoryFileManager.this.moveToDoneNow(this.confFile, toPath);
                    this.confFile = toPath;
                }
                this.state = HistoryInfoState.IN_DONE;
            }
            catch (Throwable t) {
                LOG.error("Error while trying to move a job to done", t);
                this.state = HistoryInfoState.MOVE_FAILED;
            }
            finally {
                this.notifyAll();
            }
        }

        public synchronized Job loadJob() throws IOException {
            if (this.isOversized()) {
                return new UnparsedJob(HistoryFileManager.this.maxTasksForLoadedJob, this.jobIndexInfo, this);
            }
            return new CompletedJob(HistoryFileManager.this.conf, this.jobIndexInfo.getJobId(), this.historyFile, false, this.jobIndexInfo.getUser(), this, HistoryFileManager.this.aclsMgr);
        }

        public synchronized Path getHistoryFile() {
            return this.historyFile;
        }

        protected synchronized void delete() throws IOException {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("deleting " + this.historyFile + " and " + this.confFile);
                }
                this.state = HistoryInfoState.DELETED;
                HistoryFileManager.this.doneDirFc.delete(HistoryFileManager.this.doneDirFc.makeQualified(this.historyFile), false);
                HistoryFileManager.this.doneDirFc.delete(HistoryFileManager.this.doneDirFc.makeQualified(this.confFile), false);
            }
            finally {
                this.notifyAll();
            }
        }

        public JobIndexInfo getJobIndexInfo() {
            return this.jobIndexInfo;
        }

        public JobId getJobId() {
            return this.jobIndexInfo.getJobId();
        }

        public synchronized Path getConfFile() {
            return this.confFile;
        }

        public synchronized Configuration loadConfFile() throws IOException {
            FileContext fc = FileContext.getFileContext((URI)this.confFile.toUri(), (Configuration)HistoryFileManager.this.conf);
            Configuration jobConf = new Configuration(false);
            jobConf.addResource((InputStream)fc.open(this.confFile), this.confFile.toString(), true);
            return jobConf;
        }

        private boolean isOversized() {
            int totalTasks = this.jobIndexInfo.getNumReduces() + this.jobIndexInfo.getNumMaps();
            return HistoryFileManager.this.maxTasksForLoadedJob > 0 && totalTasks > HistoryFileManager.this.maxTasksForLoadedJob;
        }

        public synchronized void waitUntilMoved() {
            while (this.isMovePending() && !this.didMoveFail()) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    LOG.warn("Waiting has been interrupted");
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private class UserLogDir {
        long modTime = 0L;
        private long scanTime = 0L;

        private UserLogDir() {
        }

        public synchronized void scanIfNeeded(FileStatus fs) {
            long newModTime = fs.getModificationTime();
            boolean alwaysScan = HistoryFileManager.this.conf.getBoolean("mapreduce.jobhistory.always-scan-user-dir", false);
            if (alwaysScan || this.modTime != newModTime || this.scanTime / 1000L == this.modTime / 1000L || this.scanTime / 1000L + 1L == this.modTime / 1000L) {
                this.scanTime = System.currentTimeMillis();
                Path p = fs.getPath();
                try {
                    HistoryFileManager.this.scanIntermediateDirectory(p);
                    this.modTime = newModTime;
                }
                catch (IOException e) {
                    LOG.error("Error while trying to scan the directory " + p, (Throwable)e);
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Scan not needed of " + fs.getPath());
                }
                this.scanTime = System.currentTimeMillis();
            }
        }
    }

    static class JobIdHistoryFileInfoMap {
        private ConcurrentSkipListMap<JobId, HistoryFileInfo> cache = new ConcurrentSkipListMap();
        private AtomicInteger mapSize = new AtomicInteger();

        JobIdHistoryFileInfoMap() {
        }

        public HistoryFileInfo putIfAbsent(JobId key, HistoryFileInfo value) {
            HistoryFileInfo ret = this.cache.putIfAbsent(key, value);
            if (ret == null) {
                this.mapSize.incrementAndGet();
            }
            return ret;
        }

        public HistoryFileInfo remove(JobId key) {
            HistoryFileInfo ret = this.cache.remove(key);
            if (ret != null) {
                this.mapSize.decrementAndGet();
            }
            return ret;
        }

        public int size() {
            return this.mapSize.get();
        }

        public HistoryFileInfo get(JobId key) {
            return this.cache.get(key);
        }

        public NavigableSet<JobId> navigableKeySet() {
            return this.cache.navigableKeySet();
        }

        public Collection<HistoryFileInfo> values() {
            return this.cache.values();
        }
    }

    private static enum HistoryInfoState {
        IN_INTERMEDIATE,
        IN_DONE,
        DELETED,
        MOVE_FAILED;

    }
}

