/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRClientCluster;
import org.apache.hadoop.mapred.MiniMRClientClusterFactory;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;

public abstract class ClusterMapReduceTestCase {
    private static File testRootDir;
    private static File dfsFolder;
    private MiniDFSCluster dfsCluster = null;
    private MiniMRClientCluster mrCluster = null;

    protected static void setupClassBase(Class<?> testClass) throws Exception {
        testRootDir = GenericTestUtils.setupTestRootDir(testClass);
        dfsFolder = new File(testRootDir, "dfs");
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.startCluster(true, null);
    }

    protected synchronized void startCluster(boolean reformatDFS, Properties props) throws Exception {
        if (this.dfsCluster == null) {
            JobConf conf = new JobConf();
            if (props != null) {
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    conf.set((String)entry.getKey(), (String)entry.getValue());
                }
            }
            this.dfsCluster = new MiniDFSCluster.Builder((Configuration)conf, dfsFolder).numDataNodes(2).format(reformatDFS).racks(null).build();
            this.mrCluster = MiniMRClientClusterFactory.create(this.getClass(), 2, (Configuration)conf);
        }
    }

    protected void stopCluster() throws Exception {
        if (this.mrCluster != null) {
            this.mrCluster.stop();
            this.mrCluster = null;
        }
        if (this.dfsCluster != null) {
            this.dfsCluster.shutdown();
            this.dfsCluster = null;
        }
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.stopCluster();
    }

    protected FileSystem getFileSystem() throws IOException {
        return this.dfsCluster.getFileSystem();
    }

    protected Path getTestRootDir() {
        return new Path(testRootDir.getPath());
    }

    protected Path getInputDir() {
        return new Path("target/input");
    }

    protected Path getOutputDir() {
        return new Path("target/output");
    }

    protected JobConf createJobConf() throws IOException {
        return new JobConf(this.mrCluster.getConfig());
    }
}

