/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.ImageVisitor;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.TextWriterImageVisitor;
import org.apache.hadoop.hdfs.util.XMLUtils;

public class XmlImageVisitor
extends TextWriterImageVisitor {
    private final Deque<ImageVisitor.ImageElement> tagQ = new ArrayDeque<ImageVisitor.ImageElement>();

    public XmlImageVisitor(String filename) throws IOException {
        super(filename, false);
    }

    public XmlImageVisitor(String filename, boolean printToScreen) throws IOException {
        super(filename, printToScreen);
    }

    @Override
    void finish() throws IOException {
        super.finish();
    }

    @Override
    void finishAbnormally() throws IOException {
        this.write("\n<!-- Error processing image file.  Exiting -->\n");
        super.finishAbnormally();
    }

    @Override
    void leaveEnclosingElement() throws IOException {
        if (this.tagQ.isEmpty()) {
            throw new IOException("Tried to exit non-existent enclosing element in FSImage file");
        }
        ImageVisitor.ImageElement element = this.tagQ.pop();
        this.write("</" + element.toString() + ">\n");
    }

    @Override
    void start() throws IOException {
        this.write("<?xml version=\"1.0\" ?>\n");
    }

    @Override
    void visit(ImageVisitor.ImageElement element, String value) throws IOException {
        this.writeTag(element.toString(), value);
    }

    @Override
    void visitEnclosingElement(ImageVisitor.ImageElement element) throws IOException {
        this.write("<" + element.toString() + ">\n");
        this.tagQ.push(element);
    }

    @Override
    void visitEnclosingElement(ImageVisitor.ImageElement element, ImageVisitor.ImageElement key, String value) throws IOException {
        this.write("<" + element.toString() + " " + key + "=\"" + value + "\">\n");
        this.tagQ.push(element);
    }

    private void writeTag(String tag, String value) throws IOException {
        this.write("<" + tag + ">" + XMLUtils.mangleXmlString(value, true) + "</" + tag + ">\n");
    }
}

