/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.XAttrHelper;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.apache.hadoop.hdfs.server.namenode.FSImageFormatPBINode;
import org.apache.hadoop.hdfs.server.namenode.FSImageFormatProtobuf;
import org.apache.hadoop.hdfs.server.namenode.FSImageUtil;
import org.apache.hadoop.hdfs.server.namenode.FsImageProto;
import org.apache.hadoop.hdfs.server.namenode.SerialNumberManager;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.FSImageLoader;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.IgnoreSnapshotException;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.shaded.org.apache.commons.text.StringEscapeUtils;
import org.apache.hadoop.shaded.org.fusesource.leveldbjni.JniDBFactory;
import org.apache.hadoop.shaded.org.iq80.leveldb.DB;
import org.apache.hadoop.shaded.org.iq80.leveldb.Options;
import org.apache.hadoop.shaded.org.iq80.leveldb.WriteBatch;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.hadoop.util.LimitInputStream;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class PBImageTextWriter
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(PBImageTextWriter.class);
    static final String DEFAULT_DELIMITER = "\t";
    static final String CRLF = "\r\n";
    private SerialNumberManager.StringTable stringTable;
    private final PrintStream out;
    private MetadataMap metadataMap = null;
    private String delimiter;
    private File filename;
    private int numThreads;
    private String parallelOutputFile;
    private final XAttr ecXAttr = XAttrHelper.buildXAttr((String)"system.hdfs.erasurecoding.policy");

    PBImageTextWriter(PrintStream out, String delimiter, String tempPath, int numThreads, String parallelOutputFile) throws IOException {
        this.out = out;
        this.delimiter = delimiter;
        this.metadataMap = tempPath.isEmpty() ? new InMemoryMetadataDB() : new LevelDBMetadataMap(tempPath);
        this.numThreads = numThreads;
        this.parallelOutputFile = parallelOutputFile;
    }

    PBImageTextWriter(PrintStream out, String delimiter, String tempPath) throws IOException {
        this(out, delimiter, tempPath, 1, "-");
    }

    protected PrintStream serialOutStream() {
        return this.out;
    }

    @Override
    public void close() throws IOException {
        this.out.flush();
        IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{this.metadataMap});
    }

    void append(StringBuffer buffer, int field) {
        buffer.append(this.delimiter);
        buffer.append(field);
    }

    void append(StringBuffer buffer, long field) {
        buffer.append(this.delimiter);
        buffer.append(field);
    }

    void append(StringBuffer buffer, String field) {
        buffer.append(this.delimiter);
        String escapedField = StringEscapeUtils.escapeCsv((String)field);
        if (escapedField.contains(CRLF)) {
            escapedField = escapedField.replace(CRLF, "%x0D%x0A");
        } else if (escapedField.contains("\n")) {
            escapedField = escapedField.replace("\n", "%x0A");
        }
        buffer.append(escapedField);
    }

    protected abstract String getEntry(String var1, FsImageProto.INodeSection.INode var2);

    protected abstract String getHeader();

    protected abstract void afterOutput() throws IOException;

    public void visit(String filePath) throws IOException {
        this.filename = new File(filePath);
        RandomAccessFile file = new RandomAccessFile(filePath, "r");
        Configuration conf = new Configuration();
        if (!FSImageUtil.checkFileFormat(file)) {
            throw new IOException("Unrecognized FSImage");
        }
        FsImageProto.FileSummary summary = FSImageUtil.loadSummary(file);
        try (FileInputStream fin = new FileInputStream(file.getFD());){
            ArrayList sections = Lists.newArrayList(summary.getSectionsList());
            Collections.sort(sections, new Comparator<FsImageProto.FileSummary.Section>(){

                @Override
                public int compare(FsImageProto.FileSummary.Section s1, FsImageProto.FileSummary.Section s2) {
                    FSImageFormatProtobuf.SectionName n1 = FSImageFormatProtobuf.SectionName.fromString(s1.getName());
                    FSImageFormatProtobuf.SectionName n2 = FSImageFormatProtobuf.SectionName.fromString(s2.getName());
                    if (n1 == null) {
                        return n2 == null ? 0 : -1;
                    }
                    if (n2 == null) {
                        return -1;
                    }
                    return n1.ordinal() - n2.ordinal();
                }
            });
            ImmutableList<Long> refIdList = null;
            for (FsImageProto.FileSummary.Section section : sections) {
                fin.getChannel().position(section.getOffset());
                InputStream is = FSImageUtil.wrapInputStreamForCompression(conf, summary.getCodec(), new BufferedInputStream((InputStream)new LimitInputStream((InputStream)fin, section.getLength())));
                FSImageFormatProtobuf.SectionName sectionName = FSImageFormatProtobuf.SectionName.fromString(section.getName());
                if (sectionName == null) {
                    throw new IOException("Unrecognized section " + section.getName());
                }
                switch (sectionName) {
                    case STRING_TABLE: {
                        LOG.info("Loading string table");
                        this.stringTable = FSImageLoader.loadStringTable(is);
                        break;
                    }
                    case INODE_REFERENCE: {
                        LOG.info("Loading inode references");
                        refIdList = FSImageLoader.loadINodeReferenceSection(is);
                        break;
                    }
                }
            }
            this.loadDirectories(fin, sections, summary, conf);
            this.loadINodeDirSection(fin, sections, summary, conf, (List<Long>)refIdList);
            this.metadataMap.sync();
            this.output(conf, summary, fin, sections);
        }
    }

    void putDirChildToMetadataMap(long parentId, long childId) throws IOException {
        this.metadataMap.putDirChild(parentId, childId);
    }

    String getNodeName(long id) throws IOException {
        return this.metadataMap.getName(id);
    }

    long getParentId(long id) throws IOException {
        return this.metadataMap.getParentId(id);
    }

    private void output(Configuration conf, FsImageProto.FileSummary summary, FileInputStream fin, ArrayList<FsImageProto.FileSummary.Section> sections) throws IOException {
        ArrayList<FsImageProto.FileSummary.Section> allINodeSubSections = this.getINodeSubSections(sections);
        if (this.numThreads > 1 && !this.parallelOutputFile.equals("-") && allINodeSubSections.size() > 1) {
            this.outputInParallel(conf, summary, allINodeSubSections);
        } else {
            LOG.info("Serial output due to threads num: {}, parallel output file: {}, subSections: {}.", new Object[]{this.numThreads, this.parallelOutputFile, allINodeSubSections.size()});
            this.outputInSerial(conf, summary, fin, sections);
        }
    }

    private void outputInSerial(Configuration conf, FsImageProto.FileSummary summary, FileInputStream fin, ArrayList<FsImageProto.FileSummary.Section> sections) throws IOException {
        long startTime = Time.monotonicNow();
        this.serialOutStream().println(this.getHeader());
        for (FsImageProto.FileSummary.Section section : sections) {
            if (FSImageFormatProtobuf.SectionName.fromString(section.getName()) != FSImageFormatProtobuf.SectionName.INODE) continue;
            fin.getChannel().position(section.getOffset());
            InputStream is = FSImageUtil.wrapInputStreamForCompression(conf, summary.getCodec(), new BufferedInputStream((InputStream)new LimitInputStream((InputStream)fin, section.getLength())));
            FsImageProto.INodeSection s = FsImageProto.INodeSection.parseDelimitedFrom(is);
            LOG.info("Found {} INodes in the INode section", (Object)s.getNumInodes());
            int count = this.outputINodes(is, this.serialOutStream());
            LOG.info("Outputted {} INodes.", (Object)count);
        }
        this.afterOutput();
        long timeTaken = Time.monotonicNow() - startTime;
        LOG.debug("Time to output inodes: {} ms", (Object)timeTaken);
    }

    private void outputInParallel(Configuration conf, FsImageProto.FileSummary summary, ArrayList<FsImageProto.FileSummary.Section> subSections) throws IOException {
        int nThreads = Integer.min(this.numThreads, subSections.size());
        LOG.info("Outputting in parallel with {} sub-sections using {} threads", (Object)subSections.size(), (Object)nThreads);
        CopyOnWriteArrayList exceptions = new CopyOnWriteArrayList();
        CountDownLatch latch = new CountDownLatch(subSections.size());
        ExecutorService executorService = Executors.newFixedThreadPool(nThreads);
        AtomicLong expectedINodes = new AtomicLong(0L);
        AtomicLong totalParsed = new AtomicLong(0L);
        String codec = summary.getCodec();
        String[] paths = new String[subSections.size()];
        int i = 0;
        while (i < subSections.size()) {
            paths[i] = this.parallelOutputFile + ".tmp." + i;
            int index = i++;
            executorService.submit(() -> {
                LOG.info("Output iNodes of section-{}", (Object)index);
                InputStream is = null;
                try (PrintStream outStream = new PrintStream(paths[index], "UTF-8");){
                    long startTime = Time.monotonicNow();
                    is = this.getInputStreamForSection((FsImageProto.FileSummary.Section)subSections.get(index), codec, conf);
                    if (index == 0) {
                        FsImageProto.INodeSection s = FsImageProto.INodeSection.parseDelimitedFrom(is);
                        expectedINodes.set(s.getNumInodes());
                    }
                    totalParsed.addAndGet(this.outputINodes(is, outStream));
                    long timeTaken = Time.monotonicNow() - startTime;
                    LOG.info("Time to output iNodes of section-{}: {} ms", (Object)index, (Object)timeTaken);
                }
                catch (Exception e) {
                    exceptions.add(new IOException(e));
                }
                finally {
                    latch.countDown();
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException ioe) {
                        LOG.warn("Failed to close the input stream, ignoring", (Throwable)ioe);
                    }
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            LOG.error("Interrupted waiting for countdown latch", (Throwable)e);
            throw new IOException(e);
        }
        executorService.shutdown();
        if (exceptions.size() != 0) {
            LOG.error("Failed to output INode sub-sections, {} exception(s) occurred.", (Object)exceptions.size());
            throw (IOException)exceptions.get(0);
        }
        if (totalParsed.get() != expectedINodes.get()) {
            throw new IOException("Expected to parse " + expectedINodes + " in parallel, but parsed " + totalParsed.get() + ". The image may be corrupt.");
        }
        LOG.info("Completed outputting all INode sub-sections to {} tmp files.", (Object)subSections.size());
        try (PrintStream ps = new PrintStream(this.parallelOutputFile, "UTF-8");){
            ps.println(this.getHeader());
        }
        long startTime = Time.monotonicNow();
        PBImageTextWriter.mergeFiles(paths, this.parallelOutputFile);
        long timeTaken = Time.monotonicNow() - startTime;
        LOG.info("Completed all stages. Time to merge files: {} ms", (Object)timeTaken);
    }

    protected PermissionStatus getPermission(long perm) {
        return FSImageFormatPBINode.Loader.loadPermission(perm, this.stringTable);
    }

    private void loadDirectories(FileInputStream fin, List<FsImageProto.FileSummary.Section> sections, FsImageProto.FileSummary summary, Configuration conf) throws IOException {
        LOG.info("Loading directories");
        long startTime = Time.monotonicNow();
        for (FsImageProto.FileSummary.Section section : sections) {
            if (FSImageFormatProtobuf.SectionName.fromString(section.getName()) != FSImageFormatProtobuf.SectionName.INODE) continue;
            fin.getChannel().position(section.getOffset());
            InputStream is = FSImageUtil.wrapInputStreamForCompression(conf, summary.getCodec(), new BufferedInputStream((InputStream)new LimitInputStream((InputStream)fin, section.getLength())));
            this.loadDirectoriesInINodeSection(is);
        }
        long timeTaken = Time.monotonicNow() - startTime;
        LOG.info("Finished loading directories in {}ms", (Object)timeTaken);
    }

    private void loadINodeDirSection(FileInputStream fin, List<FsImageProto.FileSummary.Section> sections, FsImageProto.FileSummary summary, Configuration conf, List<Long> refIdList) throws IOException {
        LOG.info("Loading INode directory section.");
        long startTime = Time.monotonicNow();
        for (FsImageProto.FileSummary.Section section : sections) {
            if (FSImageFormatProtobuf.SectionName.fromString(section.getName()) != FSImageFormatProtobuf.SectionName.INODE_DIR) continue;
            fin.getChannel().position(section.getOffset());
            InputStream is = FSImageUtil.wrapInputStreamForCompression(conf, summary.getCodec(), new BufferedInputStream((InputStream)new LimitInputStream((InputStream)fin, section.getLength())));
            this.buildNamespace(is, refIdList);
        }
        long timeTaken = Time.monotonicNow() - startTime;
        LOG.info("Finished loading INode directory section in {}ms", (Object)timeTaken);
    }

    protected void checkNode(FsImageProto.INodeSection.INode p, AtomicInteger numDirs) throws IOException {
        if (p.hasDirectory()) {
            this.metadataMap.putDir(p);
            numDirs.incrementAndGet();
        }
    }

    private void loadDirectoriesInINodeSection(InputStream in) throws IOException {
        FsImageProto.INodeSection s = FsImageProto.INodeSection.parseDelimitedFrom(in);
        LOG.info("Loading directories in INode section.");
        AtomicInteger numDirs = new AtomicInteger(0);
        int i = 0;
        while ((long)i < s.getNumInodes()) {
            FsImageProto.INodeSection.INode p = FsImageProto.INodeSection.INode.parseDelimitedFrom(in);
            if (LOG.isDebugEnabled() && i % 10000 == 0) {
                LOG.debug("Scanned {} inodes.", (Object)i);
            }
            this.checkNode(p, numDirs);
            ++i;
        }
        LOG.info("Found {} directories in INode section.", (Object)numDirs);
    }

    protected void buildNamespace(InputStream in, List<Long> refIdList) throws IOException {
        FsImageProto.INodeDirectorySection.DirEntry e;
        int count = 0;
        while ((e = FsImageProto.INodeDirectorySection.DirEntry.parseDelimitedFrom(in)) != null) {
            int i;
            if (LOG.isDebugEnabled() && ++count % 10000 == 0) {
                LOG.debug("Scanned {} directories.", (Object)count);
            }
            long parentId = e.getParent();
            for (i = 0; i < e.getChildrenCount(); ++i) {
                long childId = e.getChildren(i);
                this.metadataMap.putDirChild(parentId, childId);
            }
            for (i = e.getChildrenCount(); i < e.getChildrenCount() + e.getRefChildrenCount(); ++i) {
                int refId = e.getRefChildren(i - e.getChildrenCount());
                this.metadataMap.putDirChild(parentId, refIdList.get(refId));
            }
        }
        LOG.info("Scanned {} INode directories to build namespace.", (Object)count);
    }

    void printIfNotEmpty(PrintStream outStream, String line) {
        if (!line.isEmpty()) {
            outStream.println(line);
        }
    }

    private int outputINodes(InputStream in, PrintStream outStream) throws IOException {
        FsImageProto.INodeSection.INode p;
        long ignored = 0L;
        long ignoredSnapshots = 0L;
        int count = 0;
        while ((p = FsImageProto.INodeSection.INode.parseDelimitedFrom(in)) != null) {
            block5: {
                try {
                    String parentPath = this.metadataMap.getParentPath(p.getId());
                    this.printIfNotEmpty(outStream, this.getEntry(parentPath, p));
                }
                catch (IOException ioe) {
                    ++ignored;
                    if (!(ioe instanceof IgnoreSnapshotException)) {
                        LOG.warn("Exception caught, ignoring node:{}", (Object)p.getId(), (Object)ioe);
                    }
                    ++ignoredSnapshots;
                    if (!LOG.isDebugEnabled()) break block5;
                    LOG.debug("Exception caught, ignoring node:{}.", (Object)p.getId(), (Object)ioe);
                }
            }
            if (!LOG.isDebugEnabled() || ++count % 100000 != 0) continue;
            LOG.debug("Outputted {} INodes.", (Object)count);
        }
        if (ignored > 0L) {
            LOG.warn("Ignored {} nodes, including {} in snapshots. Please turn on debug log for details", (Object)ignored, (Object)ignoredSnapshots);
        }
        return count;
    }

    private static IgnoreSnapshotException createIgnoredSnapshotException(long inode) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("No snapshot name found for inode {}", (Object)inode);
        }
        return new IgnoreSnapshotException();
    }

    public int getStoragePolicy(FsImageProto.INodeSection.XAttrFeatureProto xattrFeatureProto) {
        List<XAttr> xattrs = FSImageFormatPBINode.Loader.loadXAttrs(xattrFeatureProto, this.stringTable);
        for (XAttr xattr : xattrs) {
            if (!BlockStoragePolicySuite.isStoragePolicyXAttr(xattr)) continue;
            return xattr.getValue()[0];
        }
        return 0;
    }

    private ArrayList<FsImageProto.FileSummary.Section> getINodeSubSections(ArrayList<FsImageProto.FileSummary.Section> sections) {
        ArrayList<FsImageProto.FileSummary.Section> subSections = new ArrayList<FsImageProto.FileSummary.Section>();
        for (FsImageProto.FileSummary.Section s : sections) {
            if (FSImageFormatProtobuf.SectionName.fromString(s.getName()) != FSImageFormatProtobuf.SectionName.INODE_SUB) continue;
            subSections.add(s);
        }
        return subSections;
    }

    private InputStream getInputStreamForSection(FsImageProto.FileSummary.Section section, String compressionCodec, Configuration conf) throws IOException {
        FileInputStream fin = new FileInputStream(this.filename);
        try {
            FileChannel channel = fin.getChannel();
            channel.position(section.getOffset());
            InputStream in = new BufferedInputStream((InputStream)new LimitInputStream((InputStream)fin, section.getLength()));
            in = FSImageUtil.wrapInputStreamForCompression(conf, compressionCodec, in);
            return in;
        }
        catch (IOException e) {
            fin.close();
            throw e;
        }
    }

    public static void mergeFiles(String[] srcPaths, String resultPath) throws IOException {
        if (srcPaths == null || srcPaths.length < 1) {
            LOG.warn("no source files to merge.");
            return;
        }
        File[] files = new File[srcPaths.length];
        for (int i = 0; i < srcPaths.length; ++i) {
            files[i] = new File(srcPaths[i]);
        }
        File resultFile = new File(resultPath);
        try (FileChannel resultChannel = new FileOutputStream(resultFile, true).getChannel();){
            File[] fileArray = files;
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                File file = fileArray[i];
                try (FileChannel src = new FileInputStream(file).getChannel();){
                    resultChannel.transferFrom(src, resultChannel.size(), src.size());
                    continue;
                }
            }
        }
        for (File file : files) {
            if (file.delete() || !file.exists()) continue;
            LOG.warn("delete tmp file: {} returned false", (Object)file);
        }
    }

    public String getErasureCodingPolicyName(FsImageProto.INodeSection.XAttrFeatureProto xattrFeatureProto) {
        List<XAttr> xattrs = FSImageFormatPBINode.Loader.loadXAttrs(xattrFeatureProto, this.stringTable);
        for (XAttr xattr : xattrs) {
            if (!xattr.equalsIgnoreValue((Object)this.ecXAttr)) continue;
            try {
                ByteArrayInputStream bIn = new ByteArrayInputStream(xattr.getValue());
                DataInputStream dIn = new DataInputStream(bIn);
                return WritableUtils.readString((DataInput)dIn);
            }
            catch (IOException ioException) {
                return null;
            }
        }
        return null;
    }

    private static interface MetadataMap
    extends Closeable {
        public void putDirChild(long var1, long var3) throws IOException;

        public void putDir(FsImageProto.INodeSection.INode var1) throws IOException;

        public String getParentPath(long var1) throws IOException;

        public void sync() throws IOException;

        public String getName(long var1) throws IOException;

        public long getParentId(long var1) throws IOException;
    }

    private static class InMemoryMetadataDB
    implements MetadataMap {
        private Map<Long, Dir> dirMap = new HashMap<Long, Dir>();
        private Map<Long, Dir> dirChildMap = new HashMap<Long, Dir>();

        InMemoryMetadataDB() {
        }

        @Override
        public void close() throws IOException {
        }

        private Dir getOrCreateCorrupted(long id) {
            Dir dir = this.dirMap.get(id);
            if (dir == null) {
                dir = new CorruptedDir(id);
                this.dirMap.put(id, dir);
            }
            return dir;
        }

        @Override
        public void putDirChild(long parentId, long childId) {
            Dir parent = this.getOrCreateCorrupted(parentId);
            Dir child = this.getOrCreateCorrupted(childId);
            child.setParent(parent);
            Preconditions.checkState((!this.dirChildMap.containsKey(childId) ? 1 : 0) != 0);
            this.dirChildMap.put(childId, parent);
        }

        @Override
        public void putDir(FsImageProto.INodeSection.INode p) {
            Preconditions.checkState((!this.dirMap.containsKey(p.getId()) ? 1 : 0) != 0);
            Dir dir = new Dir(p.getId(), p.getName().toStringUtf8());
            this.dirMap.put(p.getId(), dir);
        }

        @Override
        public String getParentPath(long inode) throws IOException {
            if (inode == 16385L) {
                return "/";
            }
            Dir parent = this.dirChildMap.get(inode);
            if (parent == null) {
                throw PBImageTextWriter.createIgnoredSnapshotException(inode);
            }
            return parent.getPath();
        }

        @Override
        public void sync() {
        }

        @Override
        public String getName(long id) throws IgnoreSnapshotException {
            Dir dir = this.dirMap.get(id);
            if (dir != null) {
                return dir.getName();
            }
            throw PBImageTextWriter.createIgnoredSnapshotException(id);
        }

        @Override
        public long getParentId(long id) throws IgnoreSnapshotException {
            Dir parentDir = this.dirChildMap.get(id);
            if (parentDir != null) {
                return parentDir.getId();
            }
            throw PBImageTextWriter.createIgnoredSnapshotException(id);
        }

        private static class Dir {
            private final long inode;
            private Dir parent = null;
            private String name;
            private String path = null;

            Dir(long inode, String name) {
                this.inode = inode;
                this.name = name;
            }

            private void setParent(Dir parent) {
                Preconditions.checkState((this.parent == null ? 1 : 0) != 0);
                this.parent = parent;
            }

            String getPath() throws IgnoreSnapshotException {
                if (this.parent == null) {
                    if (this.inode == 16385L) {
                        return "/";
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Not root inode with id {} having no parent.", (Object)this.inode);
                    }
                    throw PBImageTextWriter.createIgnoredSnapshotException(this.inode);
                }
                if (this.path == null) {
                    this.path = new Path(this.parent.getPath(), this.name.isEmpty() ? "/" : this.name).toString();
                }
                return this.path;
            }

            String getName() throws IgnoreSnapshotException {
                return this.name;
            }

            long getId() {
                return this.inode;
            }

            public boolean equals(Object o) {
                return o instanceof Dir && this.inode == ((Dir)o).inode;
            }

            public int hashCode() {
                return Long.valueOf(this.inode).hashCode();
            }
        }

        private static class CorruptedDir
        extends Dir {
            CorruptedDir(long inode) {
                super(inode, null);
            }

            @Override
            String getPath() throws IgnoreSnapshotException {
                throw PBImageTextWriter.createIgnoredSnapshotException(this.getId());
            }

            @Override
            String getName() throws IgnoreSnapshotException {
                throw PBImageTextWriter.createIgnoredSnapshotException(this.getId());
            }
        }
    }

    private static class LevelDBMetadataMap
    implements MetadataMap {
        private LevelDBStore dirChildMap = null;
        private LevelDBStore dirMap = null;
        private DirPathCache dirPathCache = new DirPathCache();

        LevelDBMetadataMap(String baseDir) throws IOException {
            File dbDir = new File(baseDir);
            if (dbDir.exists()) {
                throw new IOException("Folder " + dbDir + " already exists! Delete manually or provide another (not existing) directory!");
            }
            if (!dbDir.mkdirs()) {
                throw new IOException("Failed to mkdir on " + dbDir);
            }
            try {
                this.dirChildMap = new LevelDBStore(new File(dbDir, "dirChildMap"));
                this.dirMap = new LevelDBStore(new File(dbDir, "dirMap"));
            }
            catch (IOException e) {
                LOG.error("Failed to open LevelDBs", (Throwable)e);
                IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{this});
            }
        }

        @Override
        public void close() throws IOException {
            IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{this.dirChildMap, this.dirMap});
            this.dirChildMap = null;
            this.dirMap = null;
        }

        private static byte[] toBytes(long value) {
            return ByteBuffer.allocate(8).putLong(value).array();
        }

        private static byte[] toBytes(String value) {
            return value.getBytes(StandardCharsets.UTF_8);
        }

        private static long toLong(byte[] bytes) {
            Preconditions.checkArgument((bytes.length == 8 ? 1 : 0) != 0);
            return ByteBuffer.wrap(bytes).getLong();
        }

        private static String toString(byte[] bytes) throws IOException {
            return new String(bytes, StandardCharsets.UTF_8);
        }

        @Override
        public void putDirChild(long parentId, long childId) throws IOException {
            this.dirChildMap.put(LevelDBMetadataMap.toBytes(childId), LevelDBMetadataMap.toBytes(parentId));
        }

        @Override
        public void putDir(FsImageProto.INodeSection.INode dir) throws IOException {
            Preconditions.checkArgument((boolean)dir.hasDirectory(), (String)"INode %s (%s) is not a directory.", (Object[])new Object[]{dir.getId(), dir.getName()});
            this.dirMap.put(LevelDBMetadataMap.toBytes(dir.getId()), LevelDBMetadataMap.toBytes(dir.getName().toStringUtf8()));
        }

        private long getFromDirChildMap(long inode) throws IOException {
            byte[] bytes = this.dirChildMap.get(LevelDBMetadataMap.toBytes(inode));
            if (bytes == null) {
                throw PBImageTextWriter.createIgnoredSnapshotException(inode);
            }
            if (bytes.length != 8) {
                throw new IOException("bytes array length error. Actual length is " + bytes.length);
            }
            return LevelDBMetadataMap.toLong(bytes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getParentPath(long inode) throws IOException {
            if (inode == 16385L) {
                return "/";
            }
            long parent = this.getFromDirChildMap(inode);
            byte[] bytes = this.dirMap.get(LevelDBMetadataMap.toBytes(parent));
            LevelDBMetadataMap levelDBMetadataMap = this;
            synchronized (levelDBMetadataMap) {
                if (!this.dirPathCache.containsKey(parent)) {
                    if (parent != 16385L && bytes == null) {
                        throw PBImageTextWriter.createIgnoredSnapshotException(inode);
                    }
                    String parentName = LevelDBMetadataMap.toString(bytes);
                    String parentPath = new Path(this.getParentPath(parent), parentName.isEmpty() ? "/" : parentName).toString();
                    this.dirPathCache.put(parent, parentPath);
                }
                return (String)this.dirPathCache.get(parent);
            }
        }

        @Override
        public void sync() throws IOException {
            this.dirChildMap.sync();
            this.dirMap.sync();
        }

        @Override
        public String getName(long id) throws IOException {
            byte[] bytes = this.dirMap.get(LevelDBMetadataMap.toBytes(id));
            if (bytes != null) {
                return LevelDBMetadataMap.toString(bytes);
            }
            throw PBImageTextWriter.createIgnoredSnapshotException(id);
        }

        @Override
        public long getParentId(long id) throws IOException {
            return this.getFromDirChildMap(id);
        }

        private static class LevelDBStore
        implements Closeable {
            private DB db = null;
            private WriteBatch batch = null;
            private int writeCount = 0;
            private static final int BATCH_SIZE = 1024;

            LevelDBStore(File dbPath) throws IOException {
                Options options = new Options();
                options.createIfMissing(true);
                options.errorIfExists(true);
                this.db = JniDBFactory.factory.open(dbPath, options);
                this.batch = this.db.createWriteBatch();
            }

            @Override
            public void close() throws IOException {
                if (this.batch != null) {
                    IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{this.batch});
                    this.batch = null;
                }
                IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{this.db});
                this.db = null;
            }

            public void put(byte[] key, byte[] value) throws IOException {
                this.batch.put(key, value);
                ++this.writeCount;
                if (this.writeCount >= 1024) {
                    this.sync();
                }
            }

            public byte[] get(byte[] key) throws IOException {
                return this.db.get(key);
            }

            public void sync() throws IOException {
                try {
                    this.db.write(this.batch);
                }
                finally {
                    this.batch.close();
                    this.batch = null;
                }
                this.batch = this.db.createWriteBatch();
                this.writeCount = 0;
            }
        }

        private static class DirPathCache
        extends LinkedHashMap<Long, String> {
            private static final int CAPACITY = 16384;

            DirPathCache() {
                super(16384);
            }

            @Override
            protected boolean removeEldestEntry(Map.Entry<Long, String> entry) {
                return super.size() > 16384;
            }
        }
    }
}

